/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.FieldComponent;
import com.garmin.fit.Fit;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Field {
    protected String name;
    protected int num;
    protected int type;
    protected double scale;
    protected double offset;
    protected String units;
    protected ArrayList<Object> values;
    protected ArrayList<FieldComponent> components;

    public Field(Field field) {
        if (field == null) {
            this.name = "unknown";
            this.num = 255;
            this.type = 0;
            this.scale = 1.0;
            this.offset = 1.0;
            this.units = "";
            this.values = new ArrayList();
            this.components = new ArrayList();
            return;
        }
        this.name = new String(field.name);
        this.num = field.num;
        this.type = field.type;
        this.scale = field.scale;
        this.offset = field.offset;
        this.units = new String(field.units);
        this.values = new ArrayList();
        for (Object object : field.values) {
            if (object instanceof Byte) {
                this.values.add(new Byte((Byte)object));
                continue;
            }
            if (object instanceof Short) {
                this.values.add(new Short((Short)object));
                continue;
            }
            if (object instanceof Integer) {
                this.values.add(new Integer((Integer)object));
                continue;
            }
            if (object instanceof Long) {
                this.values.add(new Long((Long)object));
                continue;
            }
            if (object instanceof Float) {
                this.values.add(new Float(((Float)object).floatValue()));
                continue;
            }
            if (object instanceof Double) {
                this.values.add(new Double((Double)object));
                continue;
            }
            if (!(object instanceof String)) continue;
            this.values.add(new String((String)object));
        }
        this.components = field.components;
    }

    protected Field(String string, int n, int n2, double d, double d2, String string2) {
        this.name = new String(string);
        this.num = n;
        this.type = n2;
        this.scale = d;
        this.offset = d2;
        this.units = new String(string2);
        this.values = new ArrayList();
        this.components = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public int getNum() {
        return this.num;
    }

    public String getUnits() {
        return this.units;
    }

    protected int getSize() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 140: {
                return this.getNumValues() * Fit.baseTypeSizes[this.type & 0x1F];
            }
            case 7: {
                return this.getStringValue().length() + 1;
            }
        }
        return 0;
    }

    protected boolean isSignedInteger() {
        switch (this.type) {
            case 1: 
            case 131: 
            case 133: {
                return true;
            }
        }
        return false;
    }

    public void addValue(Object object) {
        if (object instanceof Number && this.type == 7) {
            String string = this.getStringValue();
            Number number = (Number)object;
            if (string == null) {
                string = "";
            }
            string = string + String.valueOf((char)number.intValue());
            this.setValue(string);
            return;
        }
        this.values.add(object);
    }

    public int getNumValues() {
        return this.values.size();
    }

    public Object getValue() {
        return this.getValue(0);
    }

    public Object getValue(int n) {
        if (n >= this.values.size()) {
            return null;
        }
        Object object = this.values.get(n);
        if (object instanceof Number && (this.scale != 1.0 || this.offset != 0.0)) {
            return new Double(((Number)object).doubleValue() / this.scale - this.offset);
        }
        return object;
    }

    public void setValue(Object object) {
        this.setValue(0, object);
    }

    public void setValue(int n, Object object) {
        while (n >= this.getNumValues()) {
            this.addValue(new Object());
        }
        if (object == null) {
            this.values.set(n, null);
        } else if (object instanceof Number && (this.scale != 1.0 || this.offset != 0.0)) {
            this.values.set(n, (((Number)object).doubleValue() + this.offset) * this.scale);
        } else {
            this.values.set(n, object);
        }
    }

    public Long getBitsValue(int n, int n2, boolean bl) {
        long l;
        long l2 = 0L;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            Long l3;
            if ((l3 = this.getLongValue(n4++)) == null) {
                return null;
            }
            l3 = l3 >> n;
            int n5 = Fit.baseTypeSizes[this.type & 0x1F] * 8 - n;
            n -= Fit.baseTypeSizes[this.type & 0x1F] * 8;
            if (n5 <= 0) continue;
            n = 0;
            if (n5 > n2 - n3) {
                n5 = n2 - n3;
            }
            long l4 = (1L << n5) - 1L;
            l2 |= (l3 & l4) << n3;
            n3 += n5;
        }
        if (bl && (l2 & (l = 1L << n2 - 1)) != 0L) {
            l2 = -l + (l2 & l - 1L);
        }
        return l2;
    }

    public Byte getByteValue() {
        return this.getByteValue(0);
    }

    public Byte getByteValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return ((Number)object).byteValue();
    }

    public Short getShortValue() {
        return this.getShortValue(0);
    }

    public Short getShortValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return ((Number)object).shortValue();
    }

    public Integer getIntegerValue() {
        return this.getIntegerValue(0);
    }

    public Integer getIntegerValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return ((Number)object).intValue();
    }

    public Long getLongValue() {
        return this.getLongValue(0);
    }

    public Long getLongValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return ((Number)object).longValue();
    }

    public Float getFloatValue() {
        return this.getFloatValue(0);
    }

    public Float getFloatValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return new Float(((Number)object).doubleValue());
    }

    public Double getDoubleValue() {
        return this.getDoubleValue(0);
    }

    public Double getDoubleValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return new Double(((Number)object).doubleValue());
    }

    public String getStringValue() {
        return this.getStringValue(0);
    }

    public String getStringValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    protected boolean read(InputStream inputStream, int n) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            block18: for (int i = n; i > 0; i -= Fit.baseTypeSizes[this.type & 0x1F]) {
                switch (this.type) {
                    case 0: {
                        Object object = (short)(dataInputStream.readByte() & 0xFF);
                        if (((Short)object).equals(Fit.ENUM_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 2: {
                        Object object = (short)(dataInputStream.readByte() & 0xFF);
                        if (((Short)object).equals(Fit.UINT8_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 10: {
                        Object object = (short)(dataInputStream.readByte() & 0xFF);
                        if (((Short)object).equals(Fit.UINT8Z_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 1: {
                        Object object = dataInputStream.readByte();
                        if (((Byte)object).equals(Fit.SINT8_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 131: {
                        Object object = dataInputStream.readShort();
                        if (((Short)object).equals(Fit.SINT16_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 132: {
                        Object object = dataInputStream.readByte() & 0xFF;
                        object = (Integer)object << 8;
                        object = (Integer)object | dataInputStream.readByte() & 0xFF;
                        if (((Integer)object).equals(Fit.UINT16_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 139: {
                        Object object = dataInputStream.readByte() & 0xFF;
                        object = (Integer)object << 8;
                        object = (Integer)object | dataInputStream.readByte() & 0xFF;
                        if (((Integer)object).equals(Fit.UINT16Z_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 133: {
                        Object object = dataInputStream.readInt();
                        if (((Integer)object).equals(Fit.SINT32_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 134: {
                        Object object = (long)(dataInputStream.readByte() & 0xFF);
                        object = (Long)object << 8;
                        object = (Long)object | (long)(dataInputStream.readByte() & 0xFF);
                        object = (Long)object << 8;
                        object = (Long)object | (long)(dataInputStream.readByte() & 0xFF);
                        object = (Long)object << 8;
                        object = (Long)object | (long)(dataInputStream.readByte() & 0xFF);
                        if (((Long)object).equals(Fit.UINT32_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 140: {
                        Object object = (long)(dataInputStream.readByte() & 0xFF);
                        object = (Long)object << 8;
                        object = (Long)object | (long)(dataInputStream.readByte() & 0xFF);
                        object = (Long)object << 8;
                        object = (Long)object | (long)(dataInputStream.readByte() & 0xFF);
                        object = (Long)object << 8;
                        object = (Long)object | (long)(dataInputStream.readByte() & 0xFF);
                        if (((Long)object).equals(Fit.UINT32Z_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 7: {
                        char c;
                        Object object = new String();
                        while (i-- > 0 && (c = (char)dataInputStream.readByte()) != '\u0000') {
                            object = (String)object + c;
                        }
                        i = 0;
                        if (((String)object).equals(Fit.STRING_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 136: {
                        Object object = Float.valueOf(dataInputStream.readFloat());
                        if (((Float)object).equals(Fit.FLOAT32_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 137: {
                        Object object = dataInputStream.readDouble();
                        if (((Double)object).equals(Fit.FLOAT64_INVALID)) continue block18;
                        this.values.add(object);
                        continue block18;
                    }
                    case 13: {
                        Object object;
                        char c = '\u0001';
                        while (i-- > 0) {
                            object = (short)(dataInputStream.readByte() & 0xFF);
                            this.values.add(object);
                            if (((Short)object).equals(Fit.BYTE_INVALID)) continue;
                            c = '\u0000';
                        }
                        if (c == '\u0000') continue block18;
                        this.values.clear();
                        continue block18;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected int write(DataOutput dataOutput) {
        try {
            block26: for (Object object : this.values) {
                if (object == null) {
                    switch (this.type) {
                        case 0: {
                            dataOutput.writeByte(Fit.ENUM_INVALID.shortValue());
                            continue block26;
                        }
                        case 2: {
                            dataOutput.writeByte(Fit.UINT8_INVALID.shortValue());
                            continue block26;
                        }
                        case 10: {
                            dataOutput.writeByte(Fit.UINT8Z_INVALID.shortValue());
                            continue block26;
                        }
                        case 1: {
                            dataOutput.writeByte(Fit.SINT8_INVALID.byteValue());
                            continue block26;
                        }
                        case 13: {
                            dataOutput.writeByte(Fit.BYTE_INVALID.shortValue());
                            continue block26;
                        }
                        case 131: {
                            dataOutput.writeShort(Fit.SINT16_INVALID.shortValue());
                            continue block26;
                        }
                        case 132: {
                            dataOutput.writeShort(Fit.UINT16_INVALID);
                            continue block26;
                        }
                        case 139: {
                            dataOutput.writeShort(Fit.UINT16Z_INVALID);
                            continue block26;
                        }
                        case 133: {
                            dataOutput.writeInt(Fit.SINT32_INVALID);
                            continue block26;
                        }
                        case 134: {
                            dataOutput.writeInt(Fit.UINT32_INVALID.intValue());
                            continue block26;
                        }
                        case 140: {
                            dataOutput.writeInt(Fit.UINT32Z_INVALID.intValue());
                            continue block26;
                        }
                        case 7: {
                            dataOutput.writeByte(0);
                            continue block26;
                        }
                        case 136: {
                            dataOutput.writeFloat(Fit.FLOAT32_INVALID.floatValue());
                            continue block26;
                        }
                        case 137: {
                            dataOutput.writeDouble(Fit.FLOAT64_INVALID);
                            continue block26;
                        }
                    }
                    return 0;
                }
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 10: 
                    case 13: {
                        if (object instanceof String) {
                            System.err.printf("Field.write(): Field %s value should not be string value %s\n", this.name, object);
                        }
                        dataOutput.writeByte(((Number)object).intValue());
                        continue block26;
                    }
                    case 131: 
                    case 132: 
                    case 139: {
                        dataOutput.writeShort(((Number)object).intValue());
                        continue block26;
                    }
                    case 133: 
                    case 134: 
                    case 140: {
                        dataOutput.writeInt(((Number)object).intValue());
                        continue block26;
                    }
                    case 7: {
                        String string = object.toString();
                        for (int i = 0; i < string.length(); ++i) {
                            dataOutput.writeByte(string.charAt(i));
                        }
                        dataOutput.writeByte(0);
                        continue block26;
                    }
                    case 136: {
                        dataOutput.writeFloat(((Number)object).floatValue());
                        continue block26;
                    }
                    case 137: {
                        dataOutput.writeDouble(((Number)object).doubleValue());
                        continue block26;
                    }
                }
                return 0;
            }
        }
        catch (IOException iOException) {
            return 0;
        }
        return this.getSize();
    }
}

