/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.MesgNum;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Mesg {
    protected String name;
    protected int num;
    protected int localNum;
    protected ArrayList<Field> fields;
    protected long systemTimeOffset;

    public Mesg(Mesg mesg) {
        this.fields = new ArrayList();
        if (mesg == null) {
            this.name = "unknown";
            this.num = MesgNum.INVALID;
            this.systemTimeOffset = 0L;
            return;
        }
        this.name = mesg.name;
        this.num = mesg.num;
        this.localNum = mesg.localNum;
        this.systemTimeOffset = mesg.systemTimeOffset;
        for (Field field : mesg.fields) {
            if (field.getNumValues() <= 0) continue;
            this.fields.add(new Field(field));
        }
    }

    protected Mesg(String string, int n) {
        this.name = new String(string);
        this.num = n;
        this.localNum = 0;
        this.fields = new ArrayList();
        this.systemTimeOffset = 0L;
    }

    protected int write(DataOutput dataOutput) {
        int n = 1;
        if (this.getNumFields() == 0) {
            return 0;
        }
        try {
            dataOutput.writeByte(this.localNum & 0xF);
        }
        catch (IOException iOException) {
            return 0;
        }
        for (Field field : this.fields) {
            int n2 = field.write(dataOutput);
            n += n2;
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public int getNum() {
        return this.num;
    }

    public boolean hasField(int n) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != n) continue;
            return true;
        }
        return false;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void setField(Field field) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != field.num) continue;
            this.fields.set(i, field);
            return;
        }
        this.fields.add(field);
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public Field getField(int n) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != n) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public Field getField(String string) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get((int)i).name.equals(string)) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public int getNumFieldValues(int n) {
        Field field = this.getField(n);
        if (field == null) {
            return 0;
        }
        return field.getNumValues();
    }

    public int getNumFieldValues(String string) {
        Field field = this.getField(string);
        if (field == null) {
            return 0;
        }
        return field.getNumValues();
    }

    public Object getFieldValue(int n) {
        return this.getFieldValue(n, 0);
    }

    public Object getFieldValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getValue(n2);
    }

    public Object getFieldValue(String string) {
        return this.getFieldValue(string, 0);
    }

    public Object getFieldValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getValue(n);
    }

    public void setFieldValue(int n, Object object) {
        this.setFieldValue(n, 0, object);
    }

    public void setFieldValue(int n, int n2, Object object) {
        Field field = this.getField(n);
        if (field == null) {
            field = Factory.createField(this.num, n);
            this.addField(field);
        }
        field.setValue(n2, object);
    }

    public void setFieldValue(String string, Object object) {
        this.setFieldValue(string, 0, object);
    }

    public void setFieldValue(String string, int n, Object object) {
        Field field = this.getField(string);
        if (field == null) {
            field = Factory.createField(this.num, string);
            this.addField(field);
        }
        field.setValue(n, object);
    }

    public Long getFieldBitsValue(int n, int n2, int n3, boolean bl) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getBitsValue(n2, n3, bl);
    }

    public Long getFieldBitsValue(String string, int n, int n2, boolean bl) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getBitsValue(n, n2, bl);
    }

    public Byte getFieldByteValue(int n) {
        return this.getFieldByteValue(n, 0);
    }

    public Byte getFieldByteValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getByteValue(n2);
    }

    public Byte getFieldByteValue(String string) {
        return this.getFieldByteValue(string, 0);
    }

    public Byte getFieldByteValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getByteValue(n);
    }

    public Short getFieldShortValue(int n) {
        return this.getFieldShortValue(n, 0);
    }

    public Short getFieldShortValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getShortValue(n2);
    }

    public Short getFieldShortValue(String string) {
        return this.getFieldShortValue(string, 0);
    }

    public Short getFieldShortValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getShortValue(n);
    }

    public Integer getFieldIntegerValue(int n) {
        return this.getFieldIntegerValue(n, 0);
    }

    public Integer getFieldIntegerValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getIntegerValue(n2);
    }

    public Integer getFieldIntegerValue(String string) {
        return this.getFieldIntegerValue(string, 0);
    }

    public Integer getFieldIntegerValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getIntegerValue(n);
    }

    public Long getFieldLongValue(int n) {
        return this.getFieldLongValue(n, 0);
    }

    public Long getFieldLongValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getLongValue(n2);
    }

    public Long getFieldLongValue(String string) {
        return this.getFieldLongValue(string, 0);
    }

    public Long getFieldLongValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getLongValue(n);
    }

    public Float getFieldFloatValue(int n) {
        return this.getFieldFloatValue(n, 0);
    }

    public Float getFieldFloatValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getFloatValue(n2);
    }

    public Float getFieldFloatValue(String string) {
        return this.getFieldFloatValue(string, 0);
    }

    public Float getFieldFloatValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getFloatValue(n);
    }

    public Double getFieldDoubleValue(int n) {
        return this.getFieldDoubleValue(n, 0);
    }

    public Double getFieldDoubleValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getDoubleValue(n2);
    }

    public Double getFieldDoubleValue(String string) {
        return this.getFieldDoubleValue(string, 0);
    }

    public Double getFieldDoubleValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getDoubleValue(n);
    }

    public String getFieldStringValue(int n) {
        return this.getFieldStringValue(n, 0);
    }

    public String getFieldStringValue(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getStringValue(n2);
    }

    public String getFieldStringValue(String string) {
        return this.getFieldStringValue(string, 0);
    }

    public String getFieldStringValue(String string, int n) {
        Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        return field.getStringValue(n);
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public DateTime timestampToDateTime(Long l) {
        if (l == null) {
            return null;
        }
        DateTime dateTime = new DateTime(l);
        dateTime.convertSystemTimeToUTC(this.systemTimeOffset);
        return dateTime;
    }

    public void setLocalNum(int n) {
        if (n >= 16) {
            throw new FitRuntimeException("Invalid local message number " + n + ".  Local message number must be < " + 16 + ".");
        }
        this.localNum = n;
    }

    public int getLocalNum() {
        return this.localNum;
    }
}

