/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import java.util.ArrayList;

public class MesgSubFieldMap {
    protected int mesgNum;
    private ArrayList<FieldMap> fields;

    protected MesgSubFieldMap(int n) {
        this.mesgNum = n;
        this.fields = new ArrayList();
    }

    protected void add(String string, int n, int n2, long l) {
        for (FieldMap fieldMap : this.fields) {
            if (fieldMap.num != n) continue;
            fieldMap.add(string, n2, l);
            return;
        }
        this.fields.add(new FieldMap(n));
        this.fields.get(this.fields.size() - 1).add(string, n2, l);
    }

    protected void map(Mesg mesg) {
        if (mesg.num != this.mesgNum) {
            return;
        }
        for (FieldMap fieldMap : this.fields) {
            fieldMap.map(mesg);
        }
    }

    private class FieldMap {
        public int num;
        public ArrayList<SubFieldMap> subFields;

        public FieldMap(int n) {
            this.num = n;
            this.subFields = new ArrayList();
        }

        public void add(String string, int n, long l) {
            for (SubFieldMap subFieldMap : this.subFields) {
                if (!subFieldMap.name.equals(string)) continue;
                subFieldMap.add(n, l);
            }
            this.subFields.add(new SubFieldMap(string));
            this.subFields.get(this.subFields.size() - 1).add(n, l);
        }

        protected void map(Mesg mesg) {
            if (mesg.getField(this.num) == null) {
                return;
            }
            for (SubFieldMap subFieldMap : this.subFields) {
                subFieldMap.map(this.num, mesg);
            }
        }

        private class SubFieldMap {
            private String name;
            private ArrayList<RefField> fields;

            public SubFieldMap(String string) {
                this.name = string;
                this.fields = new ArrayList();
            }

            public void add(int n, long l) {
                this.fields.add(new RefField(n, l));
            }

            public void map(int n, Mesg mesg) {
                for (RefField refField : this.fields) {
                    Long l;
                    Field field = mesg.getField(refField.num);
                    if (field == null || (l = field.getLongValue()) == null || l != refField.value) continue;
                    mesg.setField(Factory.createField(mesg.name, this.name, mesg.getField((int)n).values));
                }
            }

            private class RefField {
                private int num;
                private long value;

                public RefField(int n, long l) {
                    this.num = n;
                    this.value = l;
                }
            }
        }
    }
}

