/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.data;

import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.util.ResourceReader;
import de.saring.util.data.IdDateObject;

public final class Exercise
extends IdDateObject {
    private SportType sportType;
    private SportSubType sportSubType;
    private int duration;
    private IntensityType intensity;
    private float distance;
    private float avgSpeed;
    private int avgHeartRate;
    private int ascent;
    private int calories;
    private String hrmFile;
    private Equipment equipment;
    private String comment;

    public Exercise(int id) {
        super(id);
    }

    public SportType getSportType() {
        return this.sportType;
    }

    public void setSportType(SportType sportType) {
        this.sportType = sportType;
    }

    public SportSubType getSportSubType() {
        return this.sportSubType;
    }

    public void setSportSubType(SportSubType sportSubType) {
        this.sportSubType = sportSubType;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public IntensityType getIntensity() {
        return this.intensity;
    }

    public void setIntensity(IntensityType intensity) {
        this.intensity = intensity;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getAvgSpeed() {
        return this.avgSpeed;
    }

    public void setAvgSpeed(float avgSpeed) {
        this.avgSpeed = avgSpeed;
    }

    public int getAvgHeartRate() {
        return this.avgHeartRate;
    }

    public void setAvgHeartRate(int avgHeartRate) {
        this.avgHeartRate = avgHeartRate;
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setAscent(int ascent) {
        this.ascent = ascent;
    }

    public int getCalories() {
        return this.calories;
    }

    public void setCalories(int calories) {
        this.calories = calories;
    }

    public String getHrmFile() {
        return this.hrmFile;
    }

    public void setHrmFile(String hrmFile) {
        this.hrmFile = hrmFile;
    }

    public Equipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.valueOf(this.getClass().getName()) + ":\n");
        sBuilder.append(" [id=" + this.getId() + "\n");
        sBuilder.append("  date=" + this.getDate() + "\n");
        sBuilder.append("  sportType=" + this.sportType + "\n");
        sBuilder.append("  sportSubType=" + this.sportSubType + "\n");
        sBuilder.append("  duration=" + this.duration + "\n");
        sBuilder.append("  intensity=" + (Object)((Object)this.intensity) + "\n");
        sBuilder.append("  distance=" + this.distance + "\n");
        sBuilder.append("  avgSpeed=" + this.avgSpeed + "\n");
        sBuilder.append("  avgHeartRate=" + this.avgHeartRate + "\n");
        sBuilder.append("  ascent=" + this.ascent + "\n");
        sBuilder.append("  calories=" + this.calories + "\n");
        sBuilder.append("  hrmFile=" + this.hrmFile + "\n");
        sBuilder.append("  equipment=" + this.equipment + "\n");
        sBuilder.append("  comment=" + this.comment + "]\n");
        return sBuilder.toString();
    }

    public static enum IntensityType {
        MINIMUM(0),
        LOW(1),
        NORMAL(2),
        HIGH(3),
        MAXIMUM(4),
        INTERVALS(5);

        private final int value;
        private static ResourceReader resReader;

        public static void setResReader(ResourceReader resReader) {
            IntensityType.resReader = resReader;
        }

        private IntensityType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this) {
                case MINIMUM: {
                    return resReader.getString("st.intensity.minimum", new Object[0]);
                }
                case LOW: {
                    return resReader.getString("st.intensity.low", new Object[0]);
                }
                case NORMAL: {
                    return resReader.getString("st.intensity.normal", new Object[0]);
                }
                case HIGH: {
                    return resReader.getString("st.intensity.high", new Object[0]);
                }
                case MAXIMUM: {
                    return resReader.getString("st.intensity.maximum", new Object[0]);
                }
                case INTERVALS: {
                    return resReader.getString("st.intensity.intervals", new Object[0]);
                }
            }
            return "???";
        }

        public String toStringEnum() {
            return super.toString();
        }
    }
}

