/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.data;

import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseFilter;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.util.data.IdDateObjectList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ExerciseList
extends IdDateObjectList<Exercise> {
    public void updateSportTypes(SportTypeList sportTypeList) {
        for (Exercise exercise : this) {
            SportType newSportType = (SportType)sportTypeList.getByID(exercise.getSportType().getId());
            exercise.setSportType(newSportType);
            SportSubType newSportSubType = newSportType.getSportSubTypeList().getByID(exercise.getSportSubType().getId());
            exercise.setSportSubType(newSportSubType);
            if (exercise.getEquipment() == null) continue;
            Equipment newEquipment = newSportType.getEquipmentList().getByID(exercise.getEquipment().getId());
            exercise.setEquipment(newEquipment);
        }
    }

    public IdDateObjectList<Exercise> getExercisesForFilter(ExerciseFilter filter) throws PatternSyntaxException {
        IdDateObjectList<Exercise> foundExercises = new IdDateObjectList<Exercise>();
        boolean fCommentStringSearch = filter.getCommentSubString() != null && filter.getCommentSubString().length() > 0;
        String strCommentSubString = null;
        Pattern ptnCommentSubString = null;
        if (fCommentStringSearch) {
            strCommentSubString = filter.getCommentSubString().trim();
            if (!filter.isRegularExpressionMode()) {
                strCommentSubString = strCommentSubString.toLowerCase();
            } else {
                ptnCommentSubString = Pattern.compile(strCommentSubString);
            }
        }
        for (Exercise tempExercise : this) {
            Matcher matcher;
            String strExerciseComment;
            if (filter.getDateStart().after(tempExercise.getDate()) || filter.getDateEnd().before(tempExercise.getDate()) || filter.getSportType() != null && filter.getSportType().getId() != tempExercise.getSportType().getId() || filter.getSportSubType() != null && filter.getSportSubType().getId() != tempExercise.getSportSubType().getId() || filter.getIntensity() != null && filter.getIntensity() != tempExercise.getIntensity() || filter.getEquipment() != null && (tempExercise.getEquipment() == null || filter.getEquipment().getId() != tempExercise.getEquipment().getId()) || fCommentStringSearch && (tempExercise.getComment() == null || tempExercise.getComment().length() == 0 || (!filter.isRegularExpressionMode() ? (strExerciseComment = tempExercise.getComment().toLowerCase()).indexOf(strCommentSubString) == -1 : !(matcher = ptnCommentSubString.matcher(tempExercise.getComment())).find()))) continue;
            foundExercises.set(tempExercise);
        }
        return foundExercises;
    }
}

