/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.data;

import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.SportSubType;
import de.saring.util.data.IdObject;
import de.saring.util.data.IdObjectList;
import java.awt.Color;

public final class SportType
extends IdObject
implements Cloneable {
    private String name;
    private boolean recordDistance = true;
    private String icon;
    private Color color = Color.BLACK;
    private IdObjectList<SportSubType> sportSubTypeList = new IdObjectList();
    private IdObjectList<Equipment> equipmentList = new IdObjectList();

    public SportType(int id) {
        super(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRecordDistance() {
        return this.recordDistance;
    }

    public void setRecordDistance(boolean recordDistance) {
        this.recordDistance = recordDistance;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public IdObjectList<SportSubType> getSportSubTypeList() {
        return this.sportSubTypeList;
    }

    public IdObjectList<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public SportType clone() {
        try {
            SportType clone = (SportType)super.clone();
            if (this.sportSubTypeList != null) {
                clone.sportSubTypeList = new IdObjectList();
                for (SportSubType subType : this.sportSubTypeList) {
                    clone.sportSubTypeList.set(subType.clone());
                }
            }
            if (this.equipmentList != null) {
                clone.equipmentList = new IdObjectList();
                for (Equipment equipment : this.equipmentList) {
                    clone.equipmentList.set(equipment.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    @Override
    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.valueOf(this.getClass().getName()) + ":\n");
        sBuilder.append(" [id=" + this.getId() + "\n");
        sBuilder.append("  name=" + this.name + "\n");
        sBuilder.append("  recordDistance=" + this.recordDistance + "\n");
        sBuilder.append("  icon=" + this.icon + "\n");
        sBuilder.append("  color=" + this.color + "]\n");
        if (this.sportSubTypeList != null) {
            for (SportSubType subType : this.sportSubTypeList) {
                sBuilder.append(subType);
            }
        }
        if (this.equipmentList != null) {
            for (Equipment equipment : this.equipmentList) {
                sBuilder.append(equipment);
            }
        }
        return sBuilder.toString();
    }
}

