/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.gui.EVMain;
import de.saring.exerciseviewer.parser.ExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserFactory;
import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.dialogs.HRMFileOpenDialog;
import de.saring.util.gui.DialogUtils;
import de.saring.util.gui.GuiCreateUtils;
import de.saring.util.unitcalc.CalculationUtils;
import de.saring.util.unitcalc.ConvertUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.swingx.JXDatePicker;

public class ExerciseDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ExerciseDialog.class.getName());
    private STContext context;
    private STDocument document;
    @Inject
    private Provider<HRMFileOpenDialog> prHRMFileOpenDialog;
    @Inject
    private Provider<EVMain> prExerciseViewer;
    private Exercise exercise;
    private FormatUtils formatUtils;
    private Integer previousExerciseIndex = null;
    private boolean distanceActive = true;
    private static final String ACTION_AUTO_CALC_DISTANCE = "st.dlg.exercise.auto_calc_distance";
    private static final String ACTION_AUTO_CALC_AVG_SPEED = "st.dlg.exercise.auto_calc_avg_speed";
    private static final String ACTION_AUTO_CALC_DURATION = "st.dlg.exercise.auto_calc_duration";
    private static final String ACTION_HRM_BROWSE = "st.dlg.exercise.hrm_browse";
    private static final String ACTION_HRM_VIEW = "st.dlg.exercise.hrm_view";
    private static final String ACTION_HRM_IMPORT = "st.dlg.exercise.hrm_import";
    private static final String ACTION_COPY_COMMENT = "st.dlg.exercise.copy_comment";
    private static final String ACTION_OK = "st.dlg.exercise.ok";
    private static final String ACTION_CANCEL = "st.dlg.exercise.cancel";
    private static final int TABINDEX_MAIN = 0;
    private static final int TABINDEX_OPTIONAL = 1;
    private static final int TABINDEX_COMMENT = 2;
    private ButtonGroup bgAutoCalculation;
    private JButton btCancel;
    private JButton btCopyComment;
    private JButton btHRMBrowse;
    private JButton btHRMImport;
    private JButton btHRMView;
    private JButton btOK;
    private JRadioButton cbAutoCalcAvgSpeed;
    private JRadioButton cbAutoCalcDistance;
    private JRadioButton cbAutoCalcDuration;
    private JComboBox cbEquipment;
    private JComboBox cbIntensity;
    private JComboBox cbSportSubType;
    private JComboBox cbSportType;
    private JXDatePicker dpDate;
    private JLabel jLabel2;
    private JLabel laAscent;
    private JLabel laAvgHeartrate;
    private JLabel laAvgSpeed;
    private JLabel laCalories;
    private JLabel laDate;
    private JLabel laDistance;
    private JLabel laDuration;
    private JLabel laEquipment;
    private JLabel laHRMFile;
    private JLabel laIntensity;
    private JLabel laSportSubType;
    private JLabel laSportType;
    private JLabel laTime;
    private JPanel pComment;
    private JPanel pExerciseData;
    private JPanel pOptionalData;
    private JScrollPane spComment;
    private JSpinner spHour;
    private JSpinner spMinute;
    private JTextArea taComment;
    private JTabbedPane tabbedPane;
    private JTextField tfAscent;
    private JTextField tfAvgHeartrate;
    private JTextField tfAvgSpeed;
    private JTextField tfCalories;
    private JTextField tfDistance;
    private JTextField tfDuration;
    private JTextField tfHRMFile;

    @Inject
    public ExerciseDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.formatUtils = context.getFormatUtils();
        this.initComponents();
        this.setTextTranslations();
        this.getRootPane().setDefaultButton(this.btOK);
        this.taComment.setFont(this.tfDistance.getFont());
        this.dpDate.setFormats(DateFormat.getDateInstance(2));
        this.dpDate.setLinkPanel(null);
        GuiCreateUtils.addMouseWheelSupportToSpinner(this.spHour);
        GuiCreateUtils.addMouseWheelSupportToSpinner(this.spMinute);
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.cbAutoCalcDistance.setAction(actionMap.get(ACTION_AUTO_CALC_DISTANCE));
        this.cbAutoCalcAvgSpeed.setAction(actionMap.get(ACTION_AUTO_CALC_AVG_SPEED));
        this.cbAutoCalcDuration.setAction(actionMap.get(ACTION_AUTO_CALC_DURATION));
        this.btHRMBrowse.setAction(actionMap.get(ACTION_HRM_BROWSE));
        this.btHRMView.setAction(actionMap.get(ACTION_HRM_VIEW));
        this.btHRMImport.setAction(actionMap.get(ACTION_HRM_IMPORT));
        this.btCopyComment.setAction(actionMap.get(ACTION_COPY_COMMENT));
        this.btOK.setAction(actionMap.get(ACTION_OK));
        javax.swing.Action aCancel = actionMap.get(ACTION_CANCEL);
        this.btCancel.setAction(aCancel);
        DialogUtils.setDialogEscapeKeyAction(this, aCancel);
        this.cbSportType.removeAllItems();
        for (SportType sportType : document.getSportTypeList()) {
            this.cbSportType.addItem(sportType.getName());
        }
        this.cbSportType.setSelectedIndex(-1);
        this.cbIntensity.removeAllItems();
        Exercise.IntensityType[] intensityTypeArray = Exercise.IntensityType.values();
        int n = intensityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Exercise.IntensityType intensity = intensityTypeArray[n2];
            this.cbIntensity.addItem(intensity);
            ++n2;
        }
    }

    public void setExercise(Exercise exercise) {
        this.exercise = exercise;
        this.setInitialValues();
        this.setupListeners();
    }

    @Override
    public void setTitle(String title) {
        if (this.document.getExerciseList().getByID(this.exercise.getId()) == null) {
            super.setTitle(this.context.getResReader().getString("st.dlg.exercise.title.add", new Object[0]));
        } else {
            super.setTitle(title);
        }
    }

    private void setTextTranslations() {
        this.tabbedPane.setTitleAt(0, this.context.getResReader().getString("st.dlg.exercise.main.title", new Object[0]));
        this.tabbedPane.setTitleAt(1, this.context.getResReader().getString("st.dlg.exercise.optional.title", new Object[0]));
        this.tabbedPane.setTitleAt(2, this.context.getResReader().getString("st.dlg.exercise.comment.title", new Object[0]));
        this.laDistance.setText(this.context.getResReader().getString("st.dlg.exercise.distance.text", this.formatUtils.getDistanceUnitName()));
        this.laAvgSpeed.setText(this.context.getResReader().getString("st.dlg.exercise.avg_speed.text", this.formatUtils.getSpeedUnitName()));
        this.laAscent.setText(this.context.getResReader().getString("st.dlg.exercise.ascent.text", this.formatUtils.getAltitudeUnitName()));
    }

    private void setInitialValues() {
        this.dpDate.setDate(this.exercise.getDate());
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(this.exercise.getDate());
        this.spHour.setValue(calTemp.get(11));
        this.spMinute.setValue(calTemp.get(12));
        int sportTypeIndex = this.document.getSportTypeList().indexOf(this.exercise.getSportType());
        this.cbSportType.setSelectedIndex(this.cbSportType.getItemCount() == 1 ? 0 : sportTypeIndex);
        this.updateForSelectedSportType();
        int subTypeIndex = -1;
        if (this.exercise.getSportSubType() != null) {
            subTypeIndex = this.exercise.getSportType().getSportSubTypeList().indexOf(this.exercise.getSportSubType());
        }
        this.cbSportSubType.setSelectedIndex(this.cbSportSubType.getItemCount() == 1 ? 0 : subTypeIndex);
        if (this.exercise.getIntensity() != null) {
            this.cbIntensity.setSelectedItem((Object)this.exercise.getIntensity());
        } else {
            this.cbIntensity.setSelectedItem((Object)Exercise.IntensityType.NORMAL);
        }
        this.tfDistance.setText(this.formatUtils.distanceToStringWithoutUnitName(this.exercise.getDistance(), 3));
        this.tfAvgSpeed.setText(this.formatUtils.speedToStringWithoutUnitName(this.exercise.getAvgSpeed(), 3));
        this.tfDuration.setText(this.formatUtils.seconds2TimeString(this.exercise.getDuration()));
        switch (this.document.getOptions().getDefaultAutoCalcuation()) {
            case Distance: {
                this.cbAutoCalcDistance.setSelected(true);
                break;
            }
            case AvgSpeed: {
                this.cbAutoCalcAvgSpeed.setSelected(true);
                break;
            }
            default: {
                this.cbAutoCalcDuration.setSelected(true);
            }
        }
        this.updateInputs();
        int equipmentIndex = 0;
        if (this.exercise.getEquipment() != null) {
            equipmentIndex = this.exercise.getSportType().getEquipmentList().indexOf(this.exercise.getEquipment()) + 1;
        }
        this.cbEquipment.setSelectedIndex(equipmentIndex);
        if (this.exercise.getAscent() > 0) {
            this.tfAscent.setText(this.formatUtils.heightToStringWithoutUnitName(this.exercise.getAscent()));
        }
        NumberFormat nf = NumberFormat.getIntegerInstance();
        if (this.exercise.getAvgHeartRate() > 0) {
            this.tfAvgHeartrate.setText(nf.format(this.exercise.getAvgHeartRate()));
        }
        if (this.exercise.getCalories() > 0) {
            this.tfCalories.setText(nf.format(this.exercise.getCalories()));
        }
        this.tfHRMFile.setText(this.exercise.getHrmFile());
        this.taComment.setText(this.exercise.getComment());
        this.taComment.setCaretPosition(0);
    }

    private void setupListeners() {
        this.cbSportType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExerciseDialog.this.updateForSelectedSportType();
                ExerciseDialog.this.previousExerciseIndex = null;
            }
        });
        this.cbSportSubType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExerciseDialog.this.previousExerciseIndex = null;
            }
        });
        FocusAdapter focusListenerAutoCalc = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ExerciseDialog.this.calculateAutomaticValue();
            }
        };
        this.tfDistance.addFocusListener(focusListenerAutoCalc);
        this.tfAvgSpeed.addFocusListener(focusListenerAutoCalc);
        this.tfDuration.addFocusListener(focusListenerAutoCalc);
        FocusAdapter focusListenerSelectAll = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                final JTextField tf = (JTextField)e.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tf.selectAll();
                    }
                });
            }
        };
        ((JSpinner.DefaultEditor)this.spHour.getEditor()).getTextField().addFocusListener(focusListenerSelectAll);
        ((JSpinner.DefaultEditor)this.spMinute.getEditor()).getTextField().addFocusListener(focusListenerSelectAll);
    }

    private void updateForSelectedSportType() {
        int selSportTypeIndex = this.cbSportType.getSelectedIndex();
        this.cbSportSubType.setEnabled(selSportTypeIndex >= 0);
        this.cbSportSubType.removeAllItems();
        this.cbEquipment.setEnabled(selSportTypeIndex >= 0);
        this.cbEquipment.removeAllItems();
        if (selSportTypeIndex < 0) {
            this.cbSportSubType.addItem(" ");
            this.cbEquipment.addItem(" ");
            return;
        }
        SportType selSportType = (SportType)this.document.getSportTypeList().getAt(selSportTypeIndex);
        for (SportSubType sportSubType : selSportType.getSportSubTypeList()) {
            this.cbSportSubType.addItem(sportSubType.getName());
        }
        this.cbEquipment.addItem(this.context.getResReader().getString("st.dlg.exercise.equipment.none.text", new Object[0]));
        for (Equipment equipment : selSportType.getEquipmentList()) {
            this.cbEquipment.addItem(equipment.getName());
        }
        this.cbEquipment.setSelectedIndex(0);
        this.cbSportSubType.setSelectedIndex(this.cbSportSubType.getItemCount() == 1 ? 0 : -1);
        this.distanceActive = selSportType.isRecordDistance();
        this.updateInputs();
    }

    @Action(name="st.dlg.exercise.auto_calc_distance")
    public void autoCalculdateDistance() {
        this.updateInputs();
    }

    @Action(name="st.dlg.exercise.auto_calc_avg_speed")
    public void autoCalculdateAvgSpeed() {
        this.updateInputs();
    }

    @Action(name="st.dlg.exercise.auto_calc_duration")
    public void autoCalculdateDuration() {
        this.updateInputs();
    }

    @Action(name="st.dlg.exercise.hrm_browse")
    public void browseHRMFile() {
        File selectedFile;
        File initialFile = null;
        String strHRMFile = this.tfHRMFile.getText().trim();
        if (strHRMFile.length() > 0) {
            initialFile = new File(strHRMFile);
        }
        if ((selectedFile = this.prHRMFileOpenDialog.get().selectHRMFile(this.document.getOptions(), initialFile)) != null) {
            this.tfHRMFile.setText(selectedFile.getAbsolutePath());
        }
    }

    @Action(name="st.dlg.exercise.hrm_view")
    public void viewHRMFile() {
        String hrmFile = this.getHRMFile();
        if (hrmFile != null) {
            EVMain pv = this.prExerciseViewer.get();
            pv.showExercise(hrmFile, this.document.getOptions(), true);
        }
    }

    @Action(name="st.dlg.exercise.hrm_import")
    public void importHRMFile() {
        String hrmFile = this.getHRMFile();
        if (hrmFile == null) {
            return;
        }
        EVExercise pvExercise = null;
        try {
            ExerciseParser parser = ExerciseParserFactory.getParser(hrmFile);
            pvExercise = parser.parseExercise(hrmFile);
        }
        catch (EVException pe) {
            LOGGER.log(Level.SEVERE, "Failed to parse exercise file!", pe);
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.import", hrmFile);
            return;
        }
        if (pvExercise.getDate() != null) {
            this.dpDate.setDate(pvExercise.getDate());
            Calendar calTemp = Calendar.getInstance();
            calTemp.setTime(pvExercise.getDate());
            this.spHour.setValue(calTemp.get(11));
            this.spMinute.setValue(calTemp.get(12));
        }
        this.tfDuration.setText(this.formatUtils.seconds2TimeString(pvExercise.getDuration() / 10));
        this.tfAvgHeartrate.setText(String.valueOf(pvExercise.getHeartRateAVG()));
        this.tfCalories.setText(String.valueOf(pvExercise.getEnergy()));
        if (pvExercise.getSpeed() != null) {
            this.tfAvgSpeed.setText(this.formatUtils.speedToStringWithoutUnitName(pvExercise.getSpeed().getSpeedAVG(), 3));
            this.tfDistance.setText(this.formatUtils.distanceToStringWithoutUnitName((float)pvExercise.getSpeed().getDistance() / 1000.0f, 3));
            this.calculateAutomaticValue();
        }
        if (pvExercise.getAltitude() != null) {
            this.tfAscent.setText(this.formatUtils.heightToStringWithoutUnitName(pvExercise.getAltitude().getAscent()));
        }
    }

    @Action(name="st.dlg.exercise.copy_comment")
    public void copyComment() {
        if (this.cbSportType.getSelectedIndex() == -1 || this.cbSportSubType.getSelectedIndex() == -1) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.no_sport_and_subtype", new Object[0]);
            return;
        }
        SportType selSportType = (SportType)this.document.getSportTypeList().getAt(this.cbSportType.getSelectedIndex());
        SportSubType selSportSubType = selSportType.getSportSubTypeList().getAt(this.cbSportSubType.getSelectedIndex());
        if (this.previousExerciseIndex == null) {
            int indexCurrentExercise = this.document.getExerciseList().indexOf(this.exercise);
            if (indexCurrentExercise == -1) {
                indexCurrentExercise = this.document.getExerciseList().size();
            }
            this.previousExerciseIndex = indexCurrentExercise;
        }
        int currentSearchIndex = this.previousExerciseIndex - 1;
        while (currentSearchIndex >= 0) {
            Exercise tempExercise = (Exercise)this.document.getExerciseList().getAt(currentSearchIndex);
            if (tempExercise.getSportType().getId() == selSportType.getId() && tempExercise.getSportSubType().getId() == selSportSubType.getId() && tempExercise.getComment() != null && tempExercise.getComment().length() > 0) {
                this.taComment.setText(tempExercise.getComment());
                this.previousExerciseIndex = currentSearchIndex;
                return;
            }
            --currentSearchIndex;
        }
        this.previousExerciseIndex = null;
        this.context.showMessageDialog(this, 1, "common.info", "st.dlg.exercise.error.no_previous_exercise", new Object[0]);
    }

    @Action(name="st.dlg.exercise.ok")
    public void ok() {
        String strComment;
        int selEquipmentIndex;
        int durationCheck;
        Exercise newExercise = new Exercise(this.exercise.getId());
        if (this.dpDate.getDate() == null) {
            this.tabbedPane.getModel().setSelectedIndex(0);
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.date", new Object[0]);
            this.dpDate.requestFocus();
            return;
        }
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(this.dpDate.getDate());
        calTemp.set(11, (Integer)this.spHour.getValue());
        calTemp.set(12, (Integer)this.spMinute.getValue());
        calTemp.set(13, 0);
        newExercise.setDate(calTemp.getTime());
        int selSportTypeIndex = this.cbSportType.getSelectedIndex();
        if (selSportTypeIndex < 0) {
            this.tabbedPane.getModel().setSelectedIndex(0);
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.no_sport_type", new Object[0]);
            this.cbSportType.requestFocus();
            return;
        }
        newExercise.setSportType((SportType)this.document.getSportTypeList().getAt(selSportTypeIndex));
        boolean recordDistance = newExercise.getSportType().isRecordDistance();
        int selSportSubTypeIndex = this.cbSportSubType.getSelectedIndex();
        if (selSportSubTypeIndex < 0) {
            this.tabbedPane.getModel().setSelectedIndex(0);
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.no_sport_subtype", new Object[0]);
            this.cbSportSubType.requestFocus();
            return;
        }
        newExercise.setSportSubType(newExercise.getSportType().getSportSubTypeList().getAt(selSportSubTypeIndex));
        if (this.cbIntensity.getSelectedIndex() < 0) {
            this.tabbedPane.getModel().setSelectedIndex(0);
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.no_intensity", new Object[0]);
            this.cbIntensity.requestFocus();
            return;
        }
        newExercise.setIntensity((Exercise.IntensityType)((Object)this.cbIntensity.getSelectedItem()));
        try {
            if (recordDistance) {
                newExercise.setDistance(this.getDistanceEntry(true));
                newExercise.setAvgSpeed(this.getAvgSpeedEntry(true));
            } else {
                newExercise.setDistance(0.0f);
                newExercise.setAvgSpeed(0.0f);
            }
            newExercise.setDuration(this.getDurationEntry(true));
        }
        catch (STException sTException) {
            return;
        }
        if (recordDistance && ((durationCheck = CalculationUtils.calculateDuration(newExercise.getDistance(), newExercise.getAvgSpeed())) < newExercise.getDuration() - 60 || durationCheck > newExercise.getDuration() + 60)) {
            this.tabbedPane.getModel().setSelectedIndex(0);
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.wrong_relation", new Object[0]);
            return;
        }
        Integer iAscent = this.getOptionalIntValueFromTextField(this.tfAscent, "st.dlg.exercise.error.ascent");
        if (iAscent == null) {
            return;
        }
        newExercise.setAscent(iAscent);
        Integer iAvgHeartrate = this.getOptionalIntValueFromTextField(this.tfAvgHeartrate, "st.dlg.exercise.error.avg_heartrate");
        if (iAvgHeartrate == null) {
            return;
        }
        newExercise.setAvgHeartRate(iAvgHeartrate);
        Integer iCalories = this.getOptionalIntValueFromTextField(this.tfCalories, "st.dlg.exercise.error.calories");
        if (iCalories == null) {
            return;
        }
        newExercise.setCalories(iCalories);
        String strHRMFile = this.tfHRMFile.getText().trim();
        if (strHRMFile.length() > 0) {
            newExercise.setHrmFile(strHRMFile);
        }
        if ((selEquipmentIndex = this.cbEquipment.getSelectedIndex() - 1) >= 0) {
            newExercise.setEquipment(newExercise.getSportType().getEquipmentList().getAt(selEquipmentIndex));
        }
        if ((strComment = this.taComment.getText().trim()).length() > 0) {
            newExercise.setComment(strComment);
        }
        if (this.document.getOptions().getUnitSystem() == FormatUtils.UnitSystem.English) {
            newExercise.setDistance((float)ConvertUtils.convertMiles2Kilometer(newExercise.getDistance()));
            newExercise.setAvgSpeed((float)ConvertUtils.convertMiles2Kilometer(newExercise.getAvgSpeed()));
            newExercise.setAscent(ConvertUtils.convertFeet2Meter(newExercise.getAscent()));
        }
        this.document.getExerciseList().set(newExercise);
        this.dispose();
    }

    @Action(name="st.dlg.exercise.cancel")
    public void cancel() {
        this.dispose();
    }

    private void updateInputs() {
        this.cbAutoCalcDistance.setEnabled(this.distanceActive);
        this.cbAutoCalcAvgSpeed.setEnabled(this.distanceActive);
        this.cbAutoCalcDuration.setEnabled(this.distanceActive);
        if (!this.distanceActive) {
            this.tfDistance.setText("0");
            this.tfAvgSpeed.setText("0");
            this.tfDistance.setEnabled(false);
            this.tfAvgSpeed.setEnabled(false);
            this.tfDuration.setEnabled(true);
        } else {
            this.tfDistance.setEnabled(!this.cbAutoCalcDistance.isSelected());
            this.tfAvgSpeed.setEnabled(!this.cbAutoCalcAvgSpeed.isSelected());
            this.tfDuration.setEnabled(!this.cbAutoCalcDuration.isSelected());
        }
    }

    private void calculateAutomaticValue() {
        if (this.distanceActive) {
            if (this.cbAutoCalcDistance.isSelected()) {
                this.autoCalculateDistance();
            } else if (this.cbAutoCalcAvgSpeed.isSelected()) {
                this.autoCalculateAvgSpeed();
            } else {
                this.autoCalculateDuration();
            }
        }
    }

    private void autoCalculateDistance() {
        int duration;
        float avgSpeed;
        try {
            avgSpeed = this.getAvgSpeedEntry(false);
            duration = this.getDurationEntry(false);
        }
        catch (STException sTException) {
            return;
        }
        float distance = CalculationUtils.calculateDistance(avgSpeed, duration);
        if (this.document.getOptions().getUnitSystem() == FormatUtils.UnitSystem.English) {
            distance = (float)ConvertUtils.convertMiles2Kilometer(distance);
        }
        this.tfDistance.setText(this.formatUtils.distanceToStringWithoutUnitName(distance, 3));
    }

    private void autoCalculateAvgSpeed() {
        int duration;
        float distance;
        try {
            distance = this.getDistanceEntry(false);
            duration = this.getDurationEntry(false);
        }
        catch (STException sTException) {
            return;
        }
        if (this.document.getOptions().getUnitSystem() == FormatUtils.UnitSystem.English) {
            distance = (float)ConvertUtils.convertMiles2Kilometer(distance);
        }
        float avgSpeed = CalculationUtils.calculateAvgSpeed(distance, duration);
        this.tfAvgSpeed.setText(this.formatUtils.speedToStringWithoutUnitName(avgSpeed, 3));
    }

    private void autoCalculateDuration() {
        float avgSpeed;
        float distance;
        try {
            distance = this.getDistanceEntry(false);
            avgSpeed = this.getAvgSpeedEntry(false);
        }
        catch (STException sTException) {
            return;
        }
        int duration = CalculationUtils.calculateDuration(distance, avgSpeed);
        this.tfDuration.setText(this.formatUtils.seconds2TimeString(duration));
    }

    private float getDistanceEntry(boolean displayError) throws STException {
        try {
            float value = NumberFormat.getInstance().parse(this.tfDistance.getText()).floatValue();
            if (value <= 0.0f) {
                throw new Exception("The value must be greater than 0...");
            }
            return value;
        }
        catch (Exception e) {
            if (displayError) {
                this.tabbedPane.getModel().setSelectedIndex(0);
                this.tfDistance.selectAll();
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.distance", new Object[0]);
                this.tfDistance.requestFocus();
            }
            throw new STException(STExceptionID.GUI_EXERCISEDIALOG_INVALID_DISTANCE, "Failed to parse distance entry ...", e);
        }
    }

    private float getAvgSpeedEntry(boolean displayError) throws STException {
        try {
            if (this.document.getOptions().getSpeedView() == FormatUtils.SpeedView.DistancePerHour) {
                float value = NumberFormat.getInstance().parse(this.tfAvgSpeed.getText()).floatValue();
                if (value <= 0.0f) {
                    throw new Exception("The value must be greater than 0...");
                }
                return value;
            }
            Date value = new SimpleDateFormat("mm:ss").parse(this.tfAvgSpeed.getText());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            return 3600.0f / (float)(minutes * 60 + seconds);
        }
        catch (Exception e) {
            if (displayError) {
                this.tabbedPane.getModel().setSelectedIndex(0);
                this.tfAvgSpeed.selectAll();
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.avg_speed", new Object[0]);
                this.tfAvgSpeed.requestFocus();
            }
            throw new STException(STExceptionID.GUI_EXERCISEDIALOG_INVALID_AVGSPEED, "Failed to parse average speed entry ...", e);
        }
    }

    private int getDurationEntry(boolean displayError) throws STException {
        int duration = this.formatUtils.timeString2TotalSeconds(this.tfDuration.getText());
        if (duration <= 0) {
            if (displayError) {
                this.tabbedPane.getModel().setSelectedIndex(0);
                this.tfDuration.selectAll();
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.duration", new Object[0]);
                this.tfDuration.requestFocus();
            }
            throw new STException(STExceptionID.GUI_EXERCISEDIALOG_INVALID_DURATION, "Failed to parse duration entry ...");
        }
        return duration;
    }

    private Integer getOptionalIntValueFromTextField(JTextField textField, String errorKey) {
        String strValue = textField.getText().trim();
        if (strValue.length() > 0) {
            try {
                return NumberFormat.getIntegerInstance().parse(strValue).intValue();
            }
            catch (Exception exception) {
                this.tabbedPane.getModel().setSelectedIndex(1);
                textField.selectAll();
                this.context.showMessageDialog(this, 0, "common.error", errorKey, new Object[0]);
                textField.requestFocus();
                return null;
            }
        }
        return 0;
    }

    private String getHRMFile() {
        String hrmFile = this.tfHRMFile.getText().trim();
        if (hrmFile.length() == 0) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.exercise.error.no_hrm_file", new Object[0]);
            return null;
        }
        return hrmFile;
    }

    private void initComponents() {
        this.bgAutoCalculation = new ButtonGroup();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.pExerciseData = new JPanel();
        this.laDate = new JLabel();
        this.dpDate = new JXDatePicker();
        this.laTime = new JLabel();
        this.spHour = new JSpinner();
        this.jLabel2 = new JLabel();
        this.spMinute = new JSpinner();
        this.laDistance = new JLabel();
        this.tfDistance = new JTextField();
        this.laAvgSpeed = new JLabel();
        this.tfAvgSpeed = new JTextField();
        this.laDuration = new JLabel();
        this.tfDuration = new JTextField();
        this.cbAutoCalcDistance = new JRadioButton();
        this.cbAutoCalcAvgSpeed = new JRadioButton();
        this.cbAutoCalcDuration = new JRadioButton();
        this.laSportType = new JLabel();
        this.cbSportType = new JComboBox();
        this.laSportSubType = new JLabel();
        this.cbSportSubType = new JComboBox();
        this.laIntensity = new JLabel();
        this.cbIntensity = new JComboBox();
        this.pOptionalData = new JPanel();
        this.laHRMFile = new JLabel();
        this.tfHRMFile = new JTextField();
        this.btHRMBrowse = new JButton();
        this.btHRMView = new JButton();
        this.btHRMImport = new JButton();
        this.laEquipment = new JLabel();
        this.cbEquipment = new JComboBox();
        this.laAscent = new JLabel();
        this.tfAscent = new JTextField();
        this.laAvgHeartrate = new JLabel();
        this.tfAvgHeartrate = new JTextField();
        this.laCalories = new JLabel();
        this.tfCalories = new JTextField();
        this.pComment = new JPanel();
        this.spComment = new JScrollPane();
        this.taComment = new JTextArea();
        this.btCopyComment = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("st.dlg.exercise");
        this.setResizable(false);
        this.btOK.setText("_OK");
        this.btCancel.setText("_Cancel");
        this.laDate.setText("_Date:");
        this.laDate.setName("st.dlg.exercise.date");
        this.laTime.setText("_Time (hh:mm):");
        this.laTime.setName("st.dlg.exercise.time");
        this.spHour.setModel(new SpinnerNumberModel(12, 0, 23, 1));
        this.jLabel2.setText(":");
        this.spMinute.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.laDistance.setText("_Distance (km):");
        this.laAvgSpeed.setText("_Avg. speed (km/h):");
        this.laDuration.setText("_Duration (hh:mm:ss):");
        this.laDuration.setName("st.dlg.exercise.duration");
        this.bgAutoCalculation.add(this.cbAutoCalcDistance);
        this.cbAutoCalcDistance.setText("_Calculate automatically");
        this.bgAutoCalculation.add(this.cbAutoCalcAvgSpeed);
        this.cbAutoCalcAvgSpeed.setText("_Calculate automatically");
        this.bgAutoCalculation.add(this.cbAutoCalcDuration);
        this.cbAutoCalcDuration.setText("_Calculate automatically");
        this.laSportType.setText("_Sport type:");
        this.laSportType.setName("st.dlg.exercise.sport_type");
        this.cbSportType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.laSportSubType.setText("_Sport subtype:");
        this.laSportSubType.setName("st.dlg.exercise.sport_subtype");
        this.cbSportSubType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.laIntensity.setText("_Intensity:");
        this.laIntensity.setName("st.dlg.exercise.intensity");
        this.cbIntensity.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        GroupLayout pExerciseDataLayout = new GroupLayout(this.pExerciseData);
        this.pExerciseData.setLayout(pExerciseDataLayout);
        pExerciseDataLayout.setHorizontalGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pExerciseDataLayout.createSequentialGroup().addContainerGap().addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pExerciseDataLayout.createSequentialGroup().addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laSportType).addComponent(this.laSportSubType).addComponent(this.laIntensity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSportType, 0, 391, Short.MAX_VALUE).addComponent(this.cbSportSubType, 0, 391, Short.MAX_VALUE).addComponent(this.cbIntensity, 0, 391, Short.MAX_VALUE))).addGroup(pExerciseDataLayout.createSequentialGroup().addComponent(this.laDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dpDate, -2, 150, -2).addGap(25, 25, 25).addComponent(this.laTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spHour, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel2).addGap(5, 5, 5).addComponent(this.spMinute, -2, -1, -2)).addGroup(pExerciseDataLayout.createSequentialGroup().addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAvgSpeed).addComponent(this.laDuration).addComponent(this.laDistance)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfDistance, -1, 156, Short.MAX_VALUE).addComponent(this.tfAvgSpeed, -1, 156, Short.MAX_VALUE).addComponent(this.tfDuration, -1, 156, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAutoCalcDistance, -1, -1, Short.MAX_VALUE).addComponent(this.cbAutoCalcAvgSpeed, -1, 180, Short.MAX_VALUE).addComponent(this.cbAutoCalcDuration, -1, 180, Short.MAX_VALUE)))).addContainerGap()));
        pExerciseDataLayout.setVerticalGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pExerciseDataLayout.createSequentialGroup().addContainerGap().addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dpDate, -2, -1, -2).addComponent(this.laTime).addComponent(this.spHour, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.spMinute, -2, -1, -2).addComponent(this.laDate)).addGap(30, 30, 30).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laSportType).addComponent(this.cbSportType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laSportSubType).addComponent(this.cbSportSubType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laIntensity).addComponent(this.cbIntensity, -2, -1, -2)).addGap(30, 30, 30).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfDistance, -2, -1, -2).addComponent(this.cbAutoCalcDistance).addComponent(this.laDistance)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgSpeed).addComponent(this.tfAvgSpeed, -2, -1, -2).addComponent(this.cbAutoCalcAvgSpeed)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pExerciseDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laDuration).addComponent(this.tfDuration, -2, -1, -2).addComponent(this.cbAutoCalcDuration)).addContainerGap()));
        pExerciseDataLayout.linkSize(1, this.dpDate, this.spHour, this.spMinute);
        this.tabbedPane.addTab("_Exercise Data", this.pExerciseData);
        this.laHRMFile.setText("_HRM file:");
        this.laHRMFile.setName("st.dlg.exercise.hrm_file");
        this.btHRMBrowse.setText("...");
        this.btHRMView.setText("_View HRM file");
        this.btHRMImport.setText("_Import from HRM file");
        this.laEquipment.setText("_Equipment:");
        this.laEquipment.setName("st.dlg.exercise.equipment");
        this.cbEquipment.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.laAscent.setText("_Ascent (m):");
        this.tfAscent.setColumns(10);
        this.laAvgHeartrate.setText("_Avg. heart rate (bpm):");
        this.laAvgHeartrate.setName("st.dlg.exercise.avg_heartrate");
        this.tfAvgHeartrate.setColumns(10);
        this.laCalories.setText("_Calorie consumed (kCal):");
        this.laCalories.setName("st.dlg.exercise.calories");
        this.tfCalories.setColumns(10);
        GroupLayout pOptionalDataLayout = new GroupLayout(this.pOptionalData);
        this.pOptionalData.setLayout(pOptionalDataLayout);
        pOptionalDataLayout.setHorizontalGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pOptionalDataLayout.createSequentialGroup().addContainerGap().addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pOptionalDataLayout.createSequentialGroup().addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAscent).addComponent(this.laAvgHeartrate).addComponent(this.laCalories)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tfCalories).addComponent(this.tfAvgHeartrate).addComponent(this.tfAscent))).addGroup(pOptionalDataLayout.createSequentialGroup().addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laEquipment).addComponent(this.laHRMFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pOptionalDataLayout.createSequentialGroup().addComponent(this.btHRMView).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btHRMImport)).addGroup(GroupLayout.Alignment.TRAILING, pOptionalDataLayout.createSequentialGroup().addComponent(this.tfHRMFile, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btHRMBrowse)).addComponent(this.cbEquipment, 0, 412, Short.MAX_VALUE)))).addContainerGap()));
        pOptionalDataLayout.linkSize(0, this.btHRMImport, this.btHRMView);
        pOptionalDataLayout.setVerticalGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pOptionalDataLayout.createSequentialGroup().addContainerGap().addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAscent).addComponent(this.tfAscent, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgHeartrate).addComponent(this.tfAvgHeartrate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laCalories).addComponent(this.tfCalories, -2, -1, -2)).addGap(30, 30, 30).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laEquipment).addComponent(this.cbEquipment, -2, -1, -2)).addGap(30, 30, 30).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laHRMFile).addComponent(this.btHRMBrowse).addComponent(this.tfHRMFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pOptionalDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btHRMView).addComponent(this.btHRMImport)).addContainerGap()));
        this.tabbedPane.addTab("_Optional Data", this.pOptionalData);
        this.taComment.setColumns(20);
        this.taComment.setLineWrap(true);
        this.taComment.setRows(4);
        this.taComment.setWrapStyleWord(true);
        this.spComment.setViewportView(this.taComment);
        this.btCopyComment.setText("_Copy from previous similar Exercise");
        GroupLayout pCommentLayout = new GroupLayout(this.pComment);
        this.pComment.setLayout(pCommentLayout);
        pCommentLayout.setHorizontalGroup(pCommentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pCommentLayout.createSequentialGroup().addContainerGap().addGroup(pCommentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spComment, GroupLayout.Alignment.TRAILING, -1, 504, Short.MAX_VALUE).addComponent(this.btCopyComment, -1, 504, Short.MAX_VALUE)).addContainerGap()));
        pCommentLayout.setVerticalGroup(pCommentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pCommentLayout.createSequentialGroup().addContainerGap().addComponent(this.spComment, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btCopyComment).addContainerGap()));
        this.tabbedPane.addTab("_Comment", this.pComment);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbedPane, GroupLayout.Alignment.LEADING, -1, 540, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btOK))).addContainerGap()));
        layout.linkSize(0, this.btCancel, this.btOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btOK).addComponent(this.btCancel)).addContainerGap()));
        this.pack();
    }
}

