/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.exerciseviewer.parser.ExerciseParserFactory;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import de.saring.sportstracker.core.STOptions;
import de.saring.sportstracker.gui.STContext;
import de.saring.util.ResourceReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class HRMFileOpenDialog {
    private static final String DEFAULT_S710_DATA_DIRECTORY = "/var/polar";
    private STContext context;

    @Inject
    public HRMFileOpenDialog(STContext context) {
        this.context = context;
    }

    public File selectHRMFile(STOptions options, File initialFile) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setDialogTitle(this.context.getResReader().getString("st.dlg.hrm_file_open.title", new Object[0]));
        this.addFileFilters(fChooser, this.context.getResReader());
        if (initialFile != null) {
            fChooser.setSelectedFile(initialFile);
        } else {
            File initialDirectory = null;
            String strPreviousExerciseDirectory = options.getPreviousExerciseDirectory();
            initialDirectory = strPreviousExerciseDirectory != null ? new File(strPreviousExerciseDirectory) : new File(DEFAULT_S710_DATA_DIRECTORY);
            if (initialDirectory != null && initialDirectory.exists()) {
                fChooser.setCurrentDirectory(initialDirectory);
            }
        }
        int option = fChooser.showOpenDialog(this.context.getMainFrame());
        if (option != 0) {
            return null;
        }
        File selectedFile = fChooser.getSelectedFile();
        options.setPreviousExerciseDirectory(selectedFile.getParentFile().getAbsolutePath());
        return selectedFile;
    }

    private void addFileFilters(JFileChooser fChooser, ResourceReader resReader) {
        List<ExerciseParserInfo> parserInfos = ExerciseParserFactory.getExerciseParserInfos();
        ArrayList<String> lAllExtensions = new ArrayList<String>();
        for (ExerciseParserInfo parserInfo : parserInfos) {
            fChooser.addChoosableFileFilter(new FileNameExtensionFilter(resReader.getString("st.dlg.hrm_file_open.filter_specific", parserInfo.getName()), parserInfo.getSuffixes()));
            String[] stringArray = parserInfo.getSuffixes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                lAllExtensions.add(extension);
                ++n2;
            }
        }
        fChooser.addChoosableFileFilter(new FileNameExtensionFilter(resReader.getString("st.dlg.hrm_file_open.filter_all", new Object[0]), lAllExtensions.toArray(new String[0])));
    }
}

