/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseFilter;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.util.ResourceReader;
import de.saring.util.gui.DialogUtils;
import de.saring.util.gui.jfreechart.ChartUtils;
import de.saring.util.gui.jfreechart.StackedRenderer;
import de.saring.util.unitcalc.ConvertUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class OverviewDialog
extends JDialog {
    private STContext context;
    private STDocument document;
    private ChartPanel chartPanel;
    private static final String ACTION_CLOSE = "st.dlg.overview.close";
    private JButton btClose;
    private JComboBox cbDisplay;
    private JComboBox cbSportType;
    private JComboBox cbTimeRange;
    private JLabel laDisplay;
    private JLabel laFor;
    private JLabel laOptions;
    private JLabel laTimeRange;
    private JPanel pDiagram;
    private JSeparator separator;
    private JSpinner spYear;

    @Inject
    public OverviewDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        OverviewType.setResReader(context.getResReader());
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btClose);
        this.chartPanel = new ChartPanel(null);
        this.pDiagram.add((Component)this.chartPanel, "Center");
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        javax.swing.Action aClose = actionMap.get(ACTION_CLOSE);
        this.btClose.setAction(aClose);
        DialogUtils.setDialogEscapeKeyAction(this, aClose);
        this.setInitialValues();
        this.updateDiagram();
        ActionListener alUpdate = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewDialog.this.updateDiagram();
            }
        };
        this.cbTimeRange.addActionListener(alUpdate);
        this.cbDisplay.addActionListener(alUpdate);
        this.cbSportType.addActionListener(alUpdate);
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OverviewDialog.this.updateDiagram();
            }
        });
    }

    @Override
    public void setTitle(String title) {
        if (this.document.isFilterEnabled()) {
            super.setTitle(String.valueOf(title) + " " + this.context.getResReader().getString("st.dlg.overview.title.filter", new Object[0]));
        } else {
            super.setTitle(title);
        }
    }

    private void setInitialValues() {
        this.cbTimeRange.removeAllItems();
        this.cbTimeRange.addItem(this.context.getResReader().getString("st.dlg.overview.time_range.last_12_months.text", new Object[0]));
        this.cbTimeRange.addItem(this.context.getResReader().getString("st.dlg.overview.time_range.months_of_year.text", new Object[0]));
        this.cbTimeRange.addItem(this.context.getResReader().getString("st.dlg.overview.time_range.weeks_of_year.text", new Object[0]));
        this.cbTimeRange.addItem(this.context.getResReader().getString("st.dlg.overview.time_range.ten_years.text", new Object[0]));
        this.cbDisplay.removeAllItems();
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.distance_sum.text", new Object[0]));
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.duration_sum.text", new Object[0]));
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.ascent_sum.text", new Object[0]));
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.calorie_sum.text", new Object[0]));
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.exercise_count.text", new Object[0]));
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.avg_speed.text", new Object[0]));
        this.cbDisplay.addItem(this.context.getResReader().getString("st.dlg.overview.display.weight.text", new Object[0]));
        this.cbSportType.removeAllItems();
        this.cbSportType.addItem(OverviewType.EACH_SPLITTED);
        this.cbSportType.addItem(OverviewType.EACH_STACKED);
        this.cbSportType.addItem(OverviewType.ALL_SUMMARY);
        ((JSpinner.NumberEditor)this.spYear.getEditor()).getFormat().setGroupingUsed(false);
        this.spYear.setValue(Calendar.getInstance().get(1));
    }

    private void updateDiagram() {
        this.updateSelectionControlsState();
        TimeRangeType timeType = this.getCurrentTimeRangeType();
        ValueType vType = this.getCurrentValueType();
        String vTypeName = this.getCurrentValueTypeName();
        int year = ((Number)this.spYear.getValue()).intValue();
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        ArrayList<Color> lGraphColors = new ArrayList<Color>();
        if (this.getCurrentValueType() != ValueType.WEIGHT) {
            switch ((OverviewType)((Object)this.cbSportType.getSelectedItem())) {
                case EACH_STACKED: 
                case ALL_SUMMARY: {
                    this.addExerciseTimeSeries(dataset, timeType, year, vType, null);
                    lGraphColors.add(this.context.getResReader().getColor("st.dlg.overview.graph_color.all_types"));
                    break;
                }
                case EACH_SPLITTED: {
                    for (SportType sportType : this.document.getSportTypeList()) {
                        this.addExerciseTimeSeries(dataset, timeType, year, vType, sportType);
                        lGraphColors.add(sportType.getColor());
                    }
                }
            }
        } else {
            this.addWeightTimeSeries(dataset, timeType, year);
            lGraphColors.add(this.context.getResReader().getColor("st.dlg.overview.graph_color.all_types"));
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart(null, null, vTypeName, dataset, true, true, false);
        ChartUtils.customizeChart(chart, this.chartPanel);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setBaseShapesFilled(true);
        int i = 0;
        while (i < lGraphColors.size()) {
            Color tempColor = (Color)lGraphColors.get(i);
            renderer.setSeriesPaint(i, tempColor);
            ++i;
        }
        String dateFormatTooltip = null;
        String dateFormatAxis = null;
        DateTickUnit dateTickUnit = null;
        switch (timeType) {
            case LAST_12_MONTHS: {
                dateFormatTooltip = "MMMMM yyyy";
                dateFormatAxis = "MMM";
                dateTickUnit = new DateTickUnit(DateTickUnitType.MONTH, 1);
                break;
            }
            case MONTHS_OF_YEAR: {
                dateFormatTooltip = "MMMMM";
                dateFormatAxis = "MMM";
                dateTickUnit = new DateTickUnit(DateTickUnitType.MONTH, 1);
                break;
            }
            case WEEKS_OF_YEAR: {
                dateFormatTooltip = "yy";
                dateFormatAxis = "yy";
                dateTickUnit = new DateTickUnit(DateTickUnitType.YEAR, 2);
                break;
            }
            default: {
                dateFormatTooltip = "yyyy";
                dateFormatAxis = "yyyy";
                dateTickUnit = new DateTickUnit(DateTickUnitType.YEAR, 1);
            }
        }
        String toolTipFormat = "{1}: {2}";
        renderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator(toolTipFormat, new SimpleDateFormat(dateFormatTooltip), new DecimalFormat()){

            @Override
            public String generateToolTip(XYDataset dataset, int series, int item) {
                return dataset.getSeriesKey(series) + ", " + super.generateToolTip(dataset, series, item);
            }
        });
        if (this.cbSportType.getSelectedItem() == OverviewType.EACH_STACKED && this.getCurrentValueType() != ValueType.WEIGHT) {
            renderer.setSeriesLinesVisible(0, false);
            renderer.setSeriesShapesVisible(0, false);
            renderer.setSeriesVisibleInLegend(0, (Boolean)false);
            dataset = new TimeTableXYDataset();
            lGraphColors = new ArrayList();
            for (SportType sportType : this.document.getSportTypeList()) {
                this.addExerciseTimeSeries(dataset, timeType, year, vType, sportType);
                lGraphColors.add(sportType.getColor());
            }
            plot.setDataset(1, dataset);
            StackedRenderer stackedRenderer = new StackedRenderer();
            int i2 = 0;
            while (i2 < lGraphColors.size()) {
                Color tempColor = (Color)lGraphColors.get(i2);
                stackedRenderer.setSeriesPaint(i2, tempColor);
                ++i2;
            }
            stackedRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator(toolTipFormat, new SimpleDateFormat(dateFormatTooltip), new DecimalFormat()){

                @Override
                public String generateToolTip(XYDataset dataset, int series, int item) {
                    return dataset.getSeriesKey(series) + ", " + super.generateToolTip(dataset, series, item);
                }
            });
            plot.setRenderer(1, stackedRenderer);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat(dateFormatAxis));
        axis.setTickUnit(dateTickUnit);
        if (plot.getRangeAxis().getRange().getCentralValue() == 0.0) {
            plot.getRangeAxis().setRange(new Range(0.0, 10.0));
        }
        if (timeType == TimeRangeType.LAST_12_MONTHS) {
            Calendar today = Calendar.getInstance();
            Calendar newYear = this.createCalendarFor(today.get(1), 0, 1, true);
            newYear.add(5, -15);
            ValueMarker newYearMarker = new ValueMarker(newYear.getTimeInMillis());
            newYearMarker.setPaint(this.context.getResReader().getColor("st.dlg.overview.graph_color.year_break"));
            newYearMarker.setStroke(new BasicStroke(0.8f));
            newYearMarker.setLabel(" " + today.get(1));
            newYearMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            newYearMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            plot.addDomainMarker(newYearMarker);
        }
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        this.chartPanel.setChart(chart);
    }

    private void updateSelectionControlsState() {
        this.spYear.setVisible(this.getCurrentTimeRangeType() != TimeRangeType.LAST_12_MONTHS);
        boolean sssEnabled = this.getCurrentValueType() != ValueType.WEIGHT;
        this.laFor.setVisible(sssEnabled);
        this.cbSportType.setVisible(sssEnabled);
    }

    private TimeRangeType getCurrentTimeRangeType() {
        switch (this.cbTimeRange.getSelectedIndex()) {
            case 0: {
                return TimeRangeType.LAST_12_MONTHS;
            }
            case 1: {
                return TimeRangeType.MONTHS_OF_YEAR;
            }
            case 2: {
                return TimeRangeType.WEEKS_OF_YEAR;
            }
            case 3: {
                return TimeRangeType.LAST_10_YEARS;
            }
        }
        throw new IllegalArgumentException("Invalid time range type type selection!");
    }

    private ValueType getCurrentValueType() {
        switch (this.cbDisplay.getSelectedIndex()) {
            case 0: {
                return ValueType.DISTANCE;
            }
            case 1: {
                return ValueType.DURATION;
            }
            case 2: {
                return ValueType.ASCENT;
            }
            case 3: {
                return ValueType.CALORIES;
            }
            case 4: {
                return ValueType.EXERCISES;
            }
            case 5: {
                return ValueType.AVG_SPEED;
            }
            case 6: {
                return ValueType.WEIGHT;
            }
        }
        throw new IllegalArgumentException("Invalid display type selection!");
    }

    private String getCurrentValueTypeName() {
        ValueType vType = this.getCurrentValueType();
        FormatUtils formatUtils = this.context.getFormatUtils();
        switch (vType) {
            case DISTANCE: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.distance_sum", formatUtils.getDistanceUnitName());
            }
            case DURATION: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.duration_sum", new Object[0]);
            }
            case ASCENT: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.ascent_sum", formatUtils.getAltitudeUnitName());
            }
            case CALORIES: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.calories_sum", new Object[0]);
            }
            case EXERCISES: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.exercise_count", new Object[0]);
            }
            case AVG_SPEED: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.avg_speed", formatUtils.getSpeedUnitName());
            }
            case WEIGHT: {
                return this.context.getResReader().getString("st.dlg.overview.value_type.weight", formatUtils.getWeightUnitName());
            }
        }
        throw new IllegalArgumentException("Invalid value type!");
    }

    /*
     * Unable to fully structure code
     */
    private void addExerciseTimeSeries(TimeTableXYDataset dataset, TimeRangeType timeType, int year, ValueType valueType, SportType sportType) {
        seriesName = sportType != null ? sportType.getName() : this.context.getResReader().getString("st.dlg.overview.graph.all_types", new Object[0]);
        timeStepCount = this.getTimeStepCount(timeType, year);
        timeStep = 0;
        while (timeStep < timeStepCount) {
            timePeriod = this.createTimePeriodForTimeStep(timeType, year, timeStep);
            filter = this.createExerciseFilterForTimeStep(timeType, year, timeStep);
            filter.setSportType(sportType);
            if (!this.document.isFilterEnabled()) ** GOTO lbl28
            currentFilter = this.document.getCurrentFilter();
            if (currentFilter.getDateStart().after(filter.getDateStart())) {
                filter.setDateStart(currentFilter.getDateStart());
            }
            if (currentFilter.getDateEnd().before(filter.getDateEnd())) {
                filter.setDateEnd(currentFilter.getDateEnd());
            }
            if (currentFilter.getSportType() == null) ** GOTO lbl21
            if (filter.getSportType() != null && currentFilter.getSportType().getId() != filter.getSportType().getId()) {
                dataset.add(timePeriod, 0.0, seriesName);
            } else {
                filter.setSportType(currentFilter.getSportType());
                if (currentFilter.getSportSubType() != null) {
                    filter.setSportSubType(currentFilter.getSportSubType());
                }
lbl21:
                // 4 sources

                if (currentFilter.getIntensity() != null) {
                    filter.setIntensity(currentFilter.getIntensity());
                }
                if (currentFilter.getEquipment() != null) {
                    filter.setEquipment(currentFilter.getEquipment());
                }
                if (currentFilter.getCommentSubString() != null) {
                    filter.setCommentSubString(currentFilter.getCommentSubString());
                    filter.setRegularExpressionMode(currentFilter.isRegularExpressionMode());
                }
lbl28:
                // 4 sources

                if ((lExercises = this.document.getExerciseList().getExercisesForFilter(filter)).size() == 0) {
                    dataset.add(timePeriod, 0.0, seriesName);
                } else {
                    sumDistance = 0.0;
                    sumDuration = 0.0;
                    sumAscent = 0.0;
                    sumCalories = 0.0;
                    for (Exercise tempExercise : lExercises) {
                        sumDistance += (double)tempExercise.getDistance();
                        sumDuration += (double)tempExercise.getDuration();
                        sumAscent += (double)tempExercise.getAscent();
                        sumCalories += (double)tempExercise.getCalories();
                    }
                    options = this.document.getOptions();
                    switch (OverviewDialog.$SWITCH_TABLE$de$saring$sportstracker$gui$dialogs$OverviewDialog$ValueType()[valueType.ordinal()]) {
                        case 1: {
                            if (options.getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                                sumDistance = ConvertUtils.convertKilometer2Miles(sumDistance, false);
                            }
                            dataset.add(timePeriod, sumDistance, seriesName);
                            break;
                        }
                        case 2: {
                            dataset.add(timePeriod, sumDuration / 3600.0, seriesName);
                            break;
                        }
                        case 3: {
                            if (options.getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                                sumAscent = ConvertUtils.convertMeter2Feet((int)sumAscent);
                            }
                            dataset.add(timePeriod, sumAscent, seriesName);
                            break;
                        }
                        case 4: {
                            dataset.add(timePeriod, sumCalories, seriesName);
                            break;
                        }
                        case 5: {
                            dataset.add(timePeriod, lExercises.size(), seriesName);
                            break;
                        }
                        case 6: {
                            if (options.getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                                sumDistance = ConvertUtils.convertKilometer2Miles(sumDistance, false);
                            }
                            averageSpeed = sumDistance / (sumDuration / 3600.0);
                            if (options.getSpeedView() == FormatUtils.SpeedView.MinutesPerDistance) {
                                if (averageSpeed == 0.0) {
                                    dataset.add(timePeriod, 0.0, seriesName);
                                    break;
                                }
                                dataset.add(timePeriod, 60.0 / averageSpeed, seriesName);
                                break;
                            }
                            dataset.add(timePeriod, averageSpeed, seriesName);
                            break;
                        }
                        default: {
                            dataset.add(timePeriod, 0.0, seriesName);
                        }
                    }
                }
            }
            ++timeStep;
        }
    }

    private void addWeightTimeSeries(TimeTableXYDataset dataset, TimeRangeType timeType, int year) {
        String seriesName = this.context.getResReader().getString("st.dlg.overview.display.weight.text", new Object[0]);
        int timeStepCount = this.getTimeStepCount(timeType, year);
        int timeStep = 0;
        while (timeStep < timeStepCount) {
            RegularTimePeriod timePeriod = this.createTimePeriodForTimeStep(timeType, year, timeStep);
            ExerciseFilter filter = this.createExerciseFilterForTimeStep(timeType, year, timeStep);
            double avgWeight = this.getAverageWeightInTimeRange(filter);
            if (this.document.getOptions().getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                avgWeight = ConvertUtils.convertKilogram2Lbs(avgWeight);
            }
            dataset.add(timePeriod, avgWeight, seriesName);
            ++timeStep;
        }
    }

    private int getTimeStepCount(TimeRangeType timeType, int year) {
        switch (timeType) {
            case LAST_12_MONTHS: {
                return 13;
            }
            case MONTHS_OF_YEAR: {
                return 12;
            }
            case WEEKS_OF_YEAR: {
                Calendar calTemp = this.createCalendarForWeekOfYear(year, 3);
                return calTemp.getActualMaximum(3);
            }
            case LAST_10_YEARS: {
                return 10;
            }
        }
        throw new IllegalArgumentException("Unknow TimeRangeType!");
    }

    private RegularTimePeriod createTimePeriodForTimeStep(TimeRangeType timeType, int year, int timeStep) {
        switch (timeType) {
            case LAST_12_MONTHS: {
                Calendar today = Calendar.getInstance();
                int tempMonth = today.get(2) + timeStep;
                int tempYear = today.get(1) - 1 + tempMonth / 12;
                return new Month(tempMonth % 12 + 1, tempYear);
            }
            case MONTHS_OF_YEAR: {
                return new Month(timeStep + 1, year);
            }
            case WEEKS_OF_YEAR: {
                int tempWeekNr = timeStep + 1;
                return new Year(1900 + tempWeekNr);
            }
            case LAST_10_YEARS: {
                return new Year(year - 9 + timeStep);
            }
        }
        throw new IllegalArgumentException("Unknow TimeRangeType!");
    }

    private ExerciseFilter createExerciseFilterForTimeStep(TimeRangeType timeType, int year, int timeStep) {
        ExerciseFilter filter = new ExerciseFilter();
        switch (timeType) {
            case LAST_12_MONTHS: {
                Calendar today = Calendar.getInstance();
                int tempMonth = today.get(2) + timeStep;
                int tempYear = today.get(1) - 1 + tempMonth / 12;
                Calendar calMonth = this.createCalendarFor(tempYear, tempMonth % 12, 1, true);
                filter.setDateStart(calMonth.getTime());
                calMonth.add(2, 1);
                calMonth.add(13, -1);
                filter.setDateEnd(calMonth.getTime());
                break;
            }
            case MONTHS_OF_YEAR: {
                int tempMonth = timeStep;
                Calendar calMonth = this.createCalendarFor(year, tempMonth, 1, true);
                filter.setDateStart(calMonth.getTime());
                calMonth.add(2, 1);
                calMonth.add(13, -1);
                filter.setDateEnd(calMonth.getTime());
                break;
            }
            case WEEKS_OF_YEAR: {
                int tempWeekNr = timeStep + 1;
                Calendar calWeek = this.createCalendarForWeekOfYear(year, tempWeekNr);
                filter.setDateStart(calWeek.getTime());
                calWeek.add(3, 1);
                calWeek.add(13, -1);
                filter.setDateEnd(calWeek.getTime());
                break;
            }
            case LAST_10_YEARS: {
                int tempYear = year - 9 + timeStep;
                Calendar calYear = this.createCalendarFor(tempYear, 0, 1, true);
                filter.setDateStart(calYear.getTime());
                calYear.add(1, 1);
                calYear.add(13, -1);
                filter.setDateEnd(calYear.getTime());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow TimeRangeType!");
            }
        }
        return filter;
    }

    private Calendar createCalendarFor(int year, int month, int day, boolean startOfDay) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if (startOfDay) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, 23, 59, 59);
        }
        return cal;
    }

    private Calendar createCalendarForWeekOfYear(int year, int weekNr) {
        int firstWeekDay = this.document.getOptions().isWeekStartSunday() ? 1 : 2;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setFirstDayOfWeek(firstWeekDay);
        cal.set(year, 0, 1, 0, 0, 0);
        cal.set(3, weekNr);
        cal.set(7, firstWeekDay);
        return cal;
    }

    private double getAverageWeightInTimeRange(ExerciseFilter filter) {
        List weightsInTimeRange = this.document.getWeightList().getEntriesInTimeRange(filter.getDateStart(), filter.getDateEnd());
        if (weightsInTimeRange.isEmpty()) {
            return 0.0;
        }
        double weightSum = 0.0;
        for (Weight weight : weightsInTimeRange) {
            weightSum += (double)weight.getValue();
        }
        return weightSum / (double)weightsInTimeRange.size();
    }

    @Action(name="st.dlg.overview.close")
    public void close() {
        this.dispose();
    }

    private void initComponents() {
        this.btClose = new JButton();
        this.laTimeRange = new JLabel();
        this.cbTimeRange = new JComboBox();
        this.spYear = new JSpinner();
        this.pDiagram = new JPanel();
        this.laOptions = new JLabel();
        this.laDisplay = new JLabel();
        this.cbDisplay = new JComboBox();
        this.laFor = new JLabel();
        this.cbSportType = new JComboBox();
        this.separator = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("st.dlg.overview");
        this.setResizable(false);
        this.btClose.setText("_Close");
        this.btClose.setName("btClose");
        this.laTimeRange.setFont(this.laTimeRange.getFont().deriveFont(this.laTimeRange.getFont().getStyle() | 1));
        this.laTimeRange.setText("_Displayed Time Range");
        this.laTimeRange.setName("st.dlg.overview.time_range");
        this.cbTimeRange.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbTimeRange.setName("cbTimeRange");
        this.spYear.setModel(new SpinnerNumberModel(2000, 1900, 2999, 1));
        this.spYear.setName("spYear");
        this.pDiagram.setName("pDiagram");
        this.pDiagram.setLayout(new BorderLayout());
        this.laOptions.setFont(this.laOptions.getFont().deriveFont(this.laOptions.getFont().getStyle() | 1));
        this.laOptions.setText("_Display Options");
        this.laOptions.setName("st.dlg.overview.options");
        this.laDisplay.setText("_Display");
        this.laDisplay.setName("st.dlg.overview.display");
        this.cbDisplay.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbDisplay.setName("cbDisplay");
        this.laFor.setText("_for");
        this.laFor.setName("st.dlg.overview.for");
        this.cbSportType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbSportType.setName("cbSportType");
        this.separator.setName("separator");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.laDisplay).addGap(18, 18, 18).addComponent(this.cbDisplay, -2, -1, -2).addGap(18, 18, 18).addComponent(this.laFor).addGap(18, 18, 18).addComponent(this.cbSportType, -2, -1, -2)).addComponent(this.pDiagram, -1, 712, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.cbTimeRange, -2, -1, -2).addGap(18, 18, 18).addComponent(this.spYear, -2, -1, -2)).addComponent(this.laTimeRange).addComponent(this.laOptions).addComponent(this.btClose, GroupLayout.Alignment.TRAILING)).addContainerGap()).addComponent(this.separator, -1, 736, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.laTimeRange).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTimeRange, -2, -1, -2).addComponent(this.spYear, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.pDiagram, -1, 316, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.laOptions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laDisplay).addComponent(this.cbDisplay, -2, -1, -2).addComponent(this.laFor).addComponent(this.cbSportType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btClose).addContainerGap()));
        layout.linkSize(1, this.cbTimeRange, this.spYear);
        this.pack();
    }

    private static enum OverviewType {
        EACH_SPLITTED,
        EACH_STACKED,
        ALL_SUMMARY;

        private static ResourceReader resReader;

        public static void setResReader(ResourceReader resReader) {
            OverviewType.resReader = resReader;
        }

        public String toString() {
            switch (this) {
                case EACH_STACKED: {
                    return resReader.getString("st.dlg.overview.sport_type.each_stacked.text", new Object[0]);
                }
                case EACH_SPLITTED: {
                    return resReader.getString("st.dlg.overview.sport_type.each_splitted.text", new Object[0]);
                }
                case ALL_SUMMARY: {
                    return resReader.getString("st.dlg.overview.sport_type.all_summary.text", new Object[0]);
                }
            }
            return "???";
        }
    }

    private static enum TimeRangeType {
        MONTHS_OF_YEAR,
        WEEKS_OF_YEAR,
        LAST_10_YEARS,
        LAST_12_MONTHS;

    }

    private static enum ValueType {
        DISTANCE,
        DURATION,
        ASCENT,
        CALORIES,
        EXERCISES,
        AVG_SPEED,
        WEIGHT;

    }
}

