/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.util.gui.DialogUtils;
import de.saring.util.gui.GuiCreateUtils;
import de.saring.util.unitcalc.ConvertUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.text.NumberFormat;
import java.util.Calendar;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.swingx.JXDatePicker;

public class WeightDialog
extends JDialog {
    private STContext context;
    private STDocument document;
    private JXDatePicker dpDate;
    private JSpinner spHour;
    private JSpinner spMinute;
    private JTextField tfWeight;
    private JTextArea taComment;
    private JButton btOK;
    private JButton btCancel;
    private Weight weight;
    private static final String ACTION_OK = "st.dlg.weight.ok";
    private static final String ACTION_CANCEL = "st.dlg.weight.cancel";

    @Inject
    public WeightDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initGUI();
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btOK.setAction(actionMap.get(ACTION_OK));
        javax.swing.Action aCancel = actionMap.get(ACTION_CANCEL);
        this.btCancel.setAction(aCancel);
        DialogUtils.setDialogEscapeKeyAction(this, aCancel);
    }

    private void initGUI() {
        this.setName("st.dlg.weight");
        JLabel laDate = GuiCreateUtils.createLabel("st.dlg.weight.date", false);
        JLabel laTime = GuiCreateUtils.createLabel("st.dlg.weight.time", false);
        JLabel laTimeSeparator = new JLabel(":");
        JLabel laWeight = GuiCreateUtils.createLabel("st.dlg.weight.weight", false);
        JLabel laWeightUnit = GuiCreateUtils.createLabel(null, false);
        laWeightUnit.setText(this.context.getFormatUtils().getWeightUnitName());
        JLabel laText = GuiCreateUtils.createLabel("st.dlg.weight.comment", false);
        this.dpDate = GuiCreateUtils.createDatePicker();
        this.spHour = GuiCreateUtils.createSpinner(new SpinnerNumberModel(12, 0, 23, 1));
        this.spMinute = GuiCreateUtils.createSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.tfWeight = new JTextField(8);
        this.taComment = new JTextArea();
        this.taComment.setLineWrap(true);
        this.taComment.setWrapStyleWord(true);
        JScrollPane spText = new JScrollPane(this.taComment);
        this.taComment.setFont(new JTextField().getFont());
        this.btOK = new JButton();
        this.btCancel = new JButton();
        JPanel pButtons = GuiCreateUtils.createDialogButtonPanel(this.btCancel, this.btOK);
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("insets 12, gap 12", "[][]25[][]5[]5[]", "[][]16[]8[grow][]"));
        pane.add(laDate);
        pane.add((Component)this.dpDate, "growx");
        pane.add(laTime);
        pane.add(this.spHour);
        pane.add(laTimeSeparator);
        pane.add((Component)this.spMinute, "wrap");
        pane.add(laWeight);
        pane.add((Component)this.tfWeight, "split, growx");
        pane.add((Component)laWeightUnit, "wrap");
        pane.add((Component)laText, "spanx, wrap");
        pane.add((Component)spText, "spanx, width 300, height 100, grow, wrap");
        pane.add((Component)pButtons, "spanx, growx");
        this.getRootPane().setDefaultButton(this.btOK);
        this.setResizable(false);
        this.pack();
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
        this.setInitialValues();
    }

    @Override
    public void setTitle(String title) {
        if (this.document.getWeightList().getByID(this.weight.getId()) == null) {
            super.setTitle(this.context.getResReader().getString("st.dlg.weight.title.add", new Object[0]));
        } else {
            super.setTitle(title);
        }
    }

    private void setInitialValues() {
        this.dpDate.setDate(this.weight.getDate());
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(this.weight.getDate());
        this.spHour.setValue(calTemp.get(11));
        this.spMinute.setValue(calTemp.get(12));
        this.tfWeight.setText(this.context.getFormatUtils().weightToStringWithoutUnitName(this.weight.getValue(), 2));
        this.taComment.setText(this.weight.getComment());
        this.taComment.setCaretPosition(0);
    }

    @Action(name="st.dlg.weight.ok")
    public void ok() {
        Weight newWeight = new Weight(this.weight.getId());
        if (this.dpDate.getDate() == null) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.weight.error.date", new Object[0]);
            this.dpDate.requestFocus();
            return;
        }
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(this.dpDate.getDate());
        calTemp.set(11, (Integer)this.spHour.getValue());
        calTemp.set(12, (Integer)this.spMinute.getValue());
        calTemp.set(13, 0);
        newWeight.setDate(calTemp.getTime());
        try {
            float value = NumberFormat.getInstance().parse(this.tfWeight.getText()).floatValue();
            if (value <= 0.0f) {
                throw new Exception("The value must be greater than 0 ...");
            }
            if (this.document.getOptions().getUnitSystem() == FormatUtils.UnitSystem.English) {
                value = (float)ConvertUtils.convertLbs2Kilogram(value);
            }
            newWeight.setValue(value);
        }
        catch (Exception exception) {
            this.tfWeight.selectAll();
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.weight.error.weight", new Object[0]);
            this.tfWeight.requestFocus();
            return;
        }
        String strComment = this.taComment.getText().trim();
        if (strComment.length() > 0) {
            newWeight.setComment(strComment);
        }
        this.document.getWeightList().set(newWeight);
        this.dispose();
    }

    @Action(name="st.dlg.weight.cancel")
    public void cancel() {
        this.dispose();
    }
}

