/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.calendarview;

import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.Note;
import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STController;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.views.calendarview.CalendarDay;
import de.saring.sportstracker.gui.views.calendarview.CalendarEntry;
import de.saring.sportstracker.gui.views.calendarview.HrmDndTransferHandler;
import de.saring.util.data.IdDateObject;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JComponent;

public class CalendarWidget
extends JComponent {
    private STContext context;
    @Inject
    private STDocument document;
    private CalendarDay[] arCalendarDays;
    private int displayedMonth;
    private int displayedYear;
    private CalendarEntry selectedCalendarEntry;
    private int weekdayLineHeight;
    private double dCellWidth;
    private double dCellHeight;
    private Calendar calendarToday;
    private final Color COLOR_BACKGROUND1;
    private final Color COLOR_BACKGROUND2;
    private final Color COLOR_BACKGROUND_SUM1;
    private final Color COLOR_BACKGROUND_SUM2;
    private final Color COLOR_BACKGROUND_WEEKDAY1;
    private final Color COLOR_BACKGROUND_WEEKDAY2;
    private final Color COLOR_BACKGROUND_WEEKDAY3;
    private final Color COLOR_BACKGROUND_WEEKDAY4;
    private final Color COLOR_BACKGROUND_SELECTED1;
    private final Color COLOR_BACKGROUND_SELECTED2;
    private final Color COLOR_BACKGROUND_SELECTED_BORDER;
    private final Color COLOR_FOREGROUND;
    private final Color COLOR_FOREGROUND_OUTSIDE;
    private final Color COLOR_FOREGROUND_SUNDAY;
    private final Color COLOR_FOREGROUND_SUNDAY_OUTSIDE;
    private final Color COLOR_FOREGROUND_NOTE;
    private final Color COLOR_FOREGROUND_WEIGHT;
    private static final int COLUMN_NAME_VERTICAL_SPACE = 2;
    private static final int CELL_BORDER_SPACE = 4;

    @Inject
    public CalendarWidget(STContext context, STController controller) {
        this.context = context;
        this.COLOR_BACKGROUND1 = context.getResReader().getColor("st.calendar.background1");
        this.COLOR_BACKGROUND2 = context.getResReader().getColor("st.calendar.background2");
        this.COLOR_BACKGROUND_SUM1 = context.getResReader().getColor("st.calendar.background_sum1");
        this.COLOR_BACKGROUND_SUM2 = context.getResReader().getColor("st.calendar.background_sum2");
        this.COLOR_BACKGROUND_WEEKDAY1 = context.getResReader().getColor("st.calendar.background_weekday1");
        this.COLOR_BACKGROUND_WEEKDAY2 = context.getResReader().getColor("st.calendar.background_weekday2");
        this.COLOR_BACKGROUND_WEEKDAY3 = context.getResReader().getColor("st.calendar.background_weekday3");
        this.COLOR_BACKGROUND_WEEKDAY4 = context.getResReader().getColor("st.calendar.background_weekday4");
        this.COLOR_BACKGROUND_SELECTED1 = context.getResReader().getColor("st.calendar.background_selected1");
        this.COLOR_BACKGROUND_SELECTED2 = context.getResReader().getColor("st.calendar.background_selected2");
        this.COLOR_BACKGROUND_SELECTED_BORDER = context.getResReader().getColor("st.calendar.background_selected_border");
        this.COLOR_FOREGROUND = context.getResReader().getColor("st.calendar.foreground");
        this.COLOR_FOREGROUND_OUTSIDE = context.getResReader().getColor("st.calendar.foreground_outside");
        this.COLOR_FOREGROUND_SUNDAY = context.getResReader().getColor("st.calendar.foreground_sunday");
        this.COLOR_FOREGROUND_SUNDAY_OUTSIDE = context.getResReader().getColor("st.calendar.foreground_sunday_outside");
        this.COLOR_FOREGROUND_NOTE = context.getResReader().getColor("st.calendar.foreground.note");
        this.COLOR_FOREGROUND_WEIGHT = context.getResReader().getColor("st.calendar.foreground.weight");
        this.setToolTipText("");
        this.setTransferHandler(new HrmDndTransferHandler(context, controller, this));
    }

    public CalendarDay[] getCalendarDays() {
        return this.arCalendarDays;
    }

    public void setCalendarDays(CalendarDay[] arCalendarDays, int month, int year) {
        this.selectedCalendarEntry = this.lookupSelectedCalendarEntry(arCalendarDays);
        this.arCalendarDays = arCalendarDays;
        this.displayedMonth = month;
        this.displayedYear = year;
    }

    private CalendarEntry lookupSelectedCalendarEntry(CalendarDay[] calendarDays) {
        if (this.selectedCalendarEntry != null) {
            CalendarDay[] calendarDayArray = calendarDays;
            int n = calendarDays.length;
            int n2 = 0;
            while (n2 < n) {
                CalendarDay calDay = calendarDayArray[n2];
                for (CalendarEntry calEntry : calDay.getCalendarEntries()) {
                    if (calEntry.getEntry().getClass() != this.selectedCalendarEntry.getEntry().getClass() || calEntry.getEntry().getId() != this.selectedCalendarEntry.getEntry().getId()) continue;
                    return calEntry;
                }
                ++n2;
            }
        }
        return null;
    }

    public CalendarEntry getSelectedCalendarEntry() {
        return this.selectedCalendarEntry;
    }

    public void removeSelection() {
        this.selectedCalendarEntry = null;
        this.repaint();
    }

    public void selectCalendarEntryAtPoint(Point point) {
        this.selectedCalendarEntry = this.getCalendarEntryForPoint(point);
        this.repaint();
    }

    CalendarDay getCalendarDayForPoint(Point point) {
        int column = (int)(point.getX() / this.dCellWidth);
        if (point.getY() <= (double)this.weekdayLineHeight || column > 6) {
            return null;
        }
        int row = (int)((point.getY() - (double)this.weekdayLineHeight) / this.dCellHeight);
        column = Math.min(column, 6);
        int cellIndex = (row = Math.min(row, 5)) * 7 + column;
        return cellIndex >= 0 && cellIndex < this.arCalendarDays.length ? this.arCalendarDays[cellIndex] : null;
    }

    CalendarEntry getCalendarEntryForPoint(Point point) {
        CalendarDay calDay = this.getCalendarDayForPoint(point);
        if (calDay != null) {
            for (CalendarEntry tempEntry : calDay.getCalendarEntries()) {
                if (tempEntry.getLocationRect() == null || !tempEntry.getLocationRect().contains(point)) continue;
                return tempEntry;
            }
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawCalendar((Graphics2D)g);
    }

    private void drawCalendar(Graphics2D g) {
        this.calendarToday = Calendar.getInstance();
        this.weekdayLineHeight = g.getFontMetrics().getHeight() + 4;
        this.dCellWidth = (double)(this.getWidth() - 1) / 8.0;
        this.dCellHeight = (double)(this.getHeight() - this.weekdayLineHeight - 1) / 6.0;
        this.drawCalendarBackground(g);
        this.drawSummaryBackground(g);
        this.drawColumnNames(g);
        this.drawCalendarLines(g);
        if (this.arCalendarDays == null || this.arCalendarDays.length != 42) {
            return;
        }
        int row = 0;
        while (row < 6) {
            ArrayList<Exercise> exercisesOfWeek = new ArrayList<Exercise>();
            int column = 0;
            while (column < 8) {
                int cellIndex = row * 7 + column;
                boolean fWeekDay = column < 7;
                int xPos = (int)((double)column * this.dCellWidth);
                int nextXPos = (int)((double)(column + 1) * this.dCellWidth);
                int yPos = (int)((double)row * this.dCellHeight) + this.weekdayLineHeight;
                Rectangle cellClipFull = new Rectangle(xPos, yPos, nextXPos - xPos, (int)this.dCellHeight);
                Rectangle cellClipWithBorderSpace = new Rectangle(xPos, yPos, (int)this.dCellWidth - 4, (int)this.dCellHeight - 4);
                g.setClip(cellClipWithBorderSpace);
                if (fWeekDay) {
                    this.drawCalendarDayCell(g, this.arCalendarDays[cellIndex], exercisesOfWeek, xPos, yPos, cellClipFull, cellClipWithBorderSpace);
                } else {
                    int weekNr = this.arCalendarDays[row * 7].getDate().get(3);
                    this.drawWeekSummaryCell(g, String.valueOf(weekNr), exercisesOfWeek, xPos, yPos);
                }
                g.setClip(null);
                ++column;
            }
            ++row;
        }
    }

    private void drawCalendarBackground(Graphics2D g) {
        g.setPaint(new GradientPaint(0.0f, 0.0f, this.COLOR_BACKGROUND1, (float)this.getWidth() - (float)this.dCellWidth, 0.0f, this.COLOR_BACKGROUND2));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.COLOR_FOREGROUND);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private void drawSummaryBackground(Graphics2D g) {
        int xPosWeekSummary = (int)(this.dCellWidth * 7.0) + 1;
        g.setPaint(new GradientPaint(xPosWeekSummary, 0.0f, this.COLOR_BACKGROUND_SUM1, (float)xPosWeekSummary + (float)this.dCellWidth, 0.0f, this.COLOR_BACKGROUND_SUM2));
        g.fillRect(xPosWeekSummary, 1, this.getWidth() - xPosWeekSummary - 1, this.getHeight() - 2);
    }

    private void drawColumnNames(Graphics2D g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        String[] arColumnNames = this.getCalendarColumnNames();
        int indexSunday = this.getColumnIndexForSunday();
        int weekdayLineHeightHalf = this.weekdayLineHeight / 2;
        g.setPaint(new GradientPaint(0.0f, 1.0f, this.COLOR_BACKGROUND_WEEKDAY1, 0.0f, weekdayLineHeightHalf, this.COLOR_BACKGROUND_WEEKDAY2));
        g.fillRect(1, 1, this.getWidth() - 2, weekdayLineHeightHalf);
        g.setPaint(new GradientPaint(0.0f, weekdayLineHeightHalf, this.COLOR_BACKGROUND_WEEKDAY3, 0.0f, this.weekdayLineHeight, this.COLOR_BACKGROUND_WEEKDAY4));
        g.fillRect(1, weekdayLineHeightHalf + 1, this.getWidth() - 2, weekdayLineHeightHalf);
        g.setColor(this.COLOR_FOREGROUND);
        g.drawLine(0, this.weekdayLineHeight, this.getWidth() - 1, this.weekdayLineHeight);
        int i = 0;
        while (i < 8) {
            if (i == indexSunday) {
                g.setColor(this.COLOR_FOREGROUND_SUNDAY);
            }
            double textWidth = fontMetrics.getStringBounds(arColumnNames[i], g).getWidth();
            int xPos = (int)((double)i * this.dCellWidth + this.dCellWidth / 2.0 - textWidth / 2.0);
            int yPos = 2 + fontMetrics.getAscent();
            g.drawString(arColumnNames[i], xPos, yPos);
            g.setColor(this.COLOR_FOREGROUND);
            ++i;
        }
    }

    private void drawCalendarLines(Graphics2D g) {
        int i = 1;
        while (i < 8) {
            int horizontalPos = (int)((double)i * this.dCellWidth);
            g.drawLine(horizontalPos, 0, horizontalPos, this.getHeight() - 1);
            ++i;
        }
        i = 1;
        while (i < 6) {
            int verticalPos = (int)((double)i * this.dCellHeight) + this.weekdayLineHeight;
            g.drawLine(0, verticalPos, this.getWidth() - 1, verticalPos);
            ++i;
        }
    }

    private void drawCalendarDayCell(Graphics2D g, CalendarDay calendarDay, List<Exercise> exercisesOfWeek, int xPos, int yPos, Rectangle cellClipFull, Rectangle cellClipWithBorderSpace) {
        Font fontDefault = this.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        Calendar calTemp = calendarDay.getDate();
        if (this.isSameDay(calTemp, this.calendarToday)) {
            g.setFont(fontDefault.deriveFont(fontDefault.getStyle() | 1));
            fontMetrics = g.getFontMetrics();
        }
        g.setColor(this.getWeekDayNumberColor(calendarDay));
        String strDayNr = String.valueOf(calendarDay.getDate().get(5));
        double textWidth = fontMetrics.getStringBounds(strDayNr, g).getWidth();
        int dayNrXPos = xPos + (int)(this.dCellWidth - textWidth) - 4;
        int dayNrYPos = yPos + 4 + fontMetrics.getAscent();
        g.drawString(strDayNr, dayNrXPos, dayNrYPos);
        g.setFont(fontDefault);
        fontMetrics = g.getFontMetrics();
        yPos += fontMetrics.getHeight() + 6;
        for (CalendarEntry tempEntry : calendarDay.getCalendarEntries()) {
            IdDateObject tempDateObject = tempEntry.getEntry();
            if (tempEntry.isExercise()) {
                exercisesOfWeek.add((Exercise)tempDateObject);
            }
            Rectangle rectLocation = new Rectangle(xPos, yPos - 1, (int)Math.round(this.dCellWidth), fontMetrics.getHeight() + 2);
            if (tempEntry == this.selectedCalendarEntry) {
                g.setClip(cellClipFull);
                this.drawSelectedEntryBackground(g, rectLocation);
                g.setClip(cellClipWithBorderSpace);
            }
            g.setColor(this.getTextColorForEntry(tempEntry));
            g.drawString(this.createEntryText(tempEntry), xPos + 4, yPos + fontMetrics.getAscent());
            tempEntry.setToolTipText(this.createEntryToolTipText(tempEntry));
            tempEntry.setLocationRect(rectLocation);
            yPos += fontMetrics.getHeight() + 3;
        }
    }

    private void drawWeekSummaryCell(Graphics2D g, String weekNumber, List<Exercise> exercisesOfWeek, int xPos, int yPos) {
        g.setColor(this.COLOR_FOREGROUND);
        FontMetrics fontMetrics = g.getFontMetrics();
        double textWidth = fontMetrics.getStringBounds(weekNumber, g).getWidth();
        int weekNrXPos = xPos + (int)(this.dCellWidth - textWidth) - 4;
        int weekNrYPos = yPos + 4 + fontMetrics.getAscent();
        g.drawString(weekNumber, weekNrXPos, weekNrYPos);
        yPos += fontMetrics.getHeight() + 6;
        if (exercisesOfWeek.size() > 0) {
            float weekDistance = 0.0f;
            int weekDuration = 0;
            for (Exercise exercise : exercisesOfWeek) {
                weekDistance += exercise.getDistance();
                weekDuration += exercise.getDuration();
            }
            FormatUtils formatUtils = this.context.getFormatUtils();
            String strDistance = formatUtils.distanceToString(weekDistance, 2);
            String strDuration = formatUtils.seconds2TimeString(weekDuration);
            g.drawString(strDistance, xPos + 4, yPos + fontMetrics.getAscent());
            g.drawString(strDuration, xPos + 4, (yPos += fontMetrics.getHeight() + 3) + fontMetrics.getAscent());
        }
    }

    private Color getWeekDayNumberColor(CalendarDay calendarDay) {
        boolean isInsideCurrentMonth;
        boolean isSunday = calendarDay.getDate().get(7) == 1;
        boolean bl = isInsideCurrentMonth = calendarDay.getDate().get(2) == this.displayedMonth - 1 && calendarDay.getDate().get(1) == this.displayedYear;
        if (!isSunday) {
            return isInsideCurrentMonth ? this.COLOR_FOREGROUND : this.COLOR_FOREGROUND_OUTSIDE;
        }
        return isInsideCurrentMonth ? this.COLOR_FOREGROUND_SUNDAY : this.COLOR_FOREGROUND_SUNDAY_OUTSIDE;
    }

    private void drawSelectedEntryBackground(Graphics2D g, Rectangle rectLocation) {
        g.setPaint(new GradientPaint(rectLocation.x, rectLocation.y, this.COLOR_BACKGROUND_SELECTED1, rectLocation.x + rectLocation.width, rectLocation.y, this.COLOR_BACKGROUND_SELECTED2));
        g.fillRect(rectLocation.x + 1, rectLocation.y, rectLocation.width, rectLocation.height);
        g.setPaint(this.COLOR_BACKGROUND_SELECTED_BORDER);
        g.drawRect(rectLocation.x + 1, rectLocation.y - 1, rectLocation.width, rectLocation.height + 1);
    }

    private String[] getCalendarColumnNames() {
        String[] arColumnNames = new String[8];
        if (this.document.getOptions().isWeekStartSunday()) {
            arColumnNames[0] = this.context.getResReader().getString("st.valview.weekdays.sunday", new Object[0]);
            arColumnNames[1] = this.context.getResReader().getString("st.valview.weekdays.monday", new Object[0]);
            arColumnNames[2] = this.context.getResReader().getString("st.valview.weekdays.tuesday", new Object[0]);
            arColumnNames[3] = this.context.getResReader().getString("st.valview.weekdays.wednesday", new Object[0]);
            arColumnNames[4] = this.context.getResReader().getString("st.valview.weekdays.thursday", new Object[0]);
            arColumnNames[5] = this.context.getResReader().getString("st.valview.weekdays.friday", new Object[0]);
            arColumnNames[6] = this.context.getResReader().getString("st.valview.weekdays.saturday", new Object[0]);
        } else {
            arColumnNames[0] = this.context.getResReader().getString("st.valview.weekdays.monday", new Object[0]);
            arColumnNames[1] = this.context.getResReader().getString("st.valview.weekdays.tuesday", new Object[0]);
            arColumnNames[2] = this.context.getResReader().getString("st.valview.weekdays.wednesday", new Object[0]);
            arColumnNames[3] = this.context.getResReader().getString("st.valview.weekdays.thursday", new Object[0]);
            arColumnNames[4] = this.context.getResReader().getString("st.valview.weekdays.friday", new Object[0]);
            arColumnNames[5] = this.context.getResReader().getString("st.valview.weekdays.saturday", new Object[0]);
            arColumnNames[6] = this.context.getResReader().getString("st.valview.weekdays.sunday", new Object[0]);
        }
        arColumnNames[7] = this.context.getResReader().getString("st.valview.week_sum", new Object[0]);
        return arColumnNames;
    }

    private int getColumnIndexForSunday() {
        return this.document.getOptions().isWeekStartSunday() ? 0 : 6;
    }

    private boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    private String createEntryText(CalendarEntry calendarEntry) {
        FormatUtils formatUtils = this.context.getFormatUtils();
        StringBuilder sb = new StringBuilder();
        if (calendarEntry.isNote()) {
            Note note = (Note)calendarEntry.getEntry();
            sb.append(this.context.getResReader().getString("st.calview.note_short", new Object[0]));
            sb.append(" ");
            sb.append(note.getText());
        } else if (calendarEntry.isWeight()) {
            Weight weight = (Weight)calendarEntry.getEntry();
            sb.append(this.context.getResReader().getString("st.calview.weight_short", new Object[0]));
            sb.append(" ");
            sb.append(formatUtils.weightToString(weight.getValue(), 2));
        } else if (calendarEntry.isExercise()) {
            Exercise exercise = (Exercise)calendarEntry.getEntry();
            sb.append(exercise.getSportType().getName().charAt(0));
            sb.append(": ");
            if (exercise.getSportType().isRecordDistance()) {
                sb.append(formatUtils.distanceToString(exercise.getDistance(), 2));
                sb.append(", ");
            }
            sb.append(formatUtils.seconds2TimeString(exercise.getDuration()));
        }
        return sb.toString();
    }

    private String createEntryToolTipText(CalendarEntry calendarEntry) {
        FormatUtils formatUtils = this.context.getFormatUtils();
        StringBuilder sb = new StringBuilder("<html>");
        if (calendarEntry.isNote()) {
            Note note = (Note)calendarEntry.getEntry();
            sb.append(formatUtils.firstLineOfText(note.getText()));
        } else if (calendarEntry.isWeight()) {
            Weight weight = (Weight)calendarEntry.getEntry();
            sb.append(this.context.getResReader().getString("st.calview.weight_tooltip.weight", new Object[0]));
            sb.append(" ");
            sb.append(formatUtils.weightToString(weight.getValue(), 2));
        } else if (calendarEntry.isExercise()) {
            Exercise exercise = (Exercise)calendarEntry.getEntry();
            sb.append(this.context.getResReader().getString("st.calview.exe_tooltip.sport_type", new Object[0]));
            sb.append(" ");
            sb.append(exercise.getSportType().getName());
            sb.append(" (");
            sb.append(exercise.getSportSubType().getName());
            sb.append(")<br/>");
            if (exercise.getSportType().isRecordDistance()) {
                sb.append(this.context.getResReader().getString("st.calview.exe_tooltip.distance", new Object[0]));
                sb.append(" ");
                sb.append(formatUtils.distanceToString(exercise.getDistance(), 2));
                sb.append("<br/>");
                sb.append(this.context.getResReader().getString("st.calview.exe_tooltip.avg_speed", new Object[0]));
                sb.append(" ");
                sb.append(formatUtils.speedToString(exercise.getAvgSpeed(), 2));
                sb.append("<br/>");
            }
            sb.append(this.context.getResReader().getString("st.calview.exe_tooltip.duration", new Object[0]));
            sb.append(" ");
            sb.append(formatUtils.seconds2TimeString(exercise.getDuration()));
        }
        sb.append("</html>");
        return sb.toString();
    }

    private Color getTextColorForEntry(CalendarEntry calendarEntry) {
        if (calendarEntry.isExercise()) {
            return ((Exercise)calendarEntry.getEntry()).getSportType().getColor();
        }
        if (calendarEntry.isNote()) {
            return this.COLOR_FOREGROUND_NOTE;
        }
        if (calendarEntry.isWeight()) {
            return this.COLOR_FOREGROUND_WEIGHT;
        }
        throw new IllegalArgumentException("Invalid CalendarEntry type!");
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        CalendarEntry calEntry = this.getCalendarEntryForPoint(event.getPoint());
        return calEntry != null ? calEntry.getToolTipText() : null;
    }
}

