/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.listview;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.gui.views.listview.BaseListView;
import de.saring.util.unitcalc.FormatUtils;
import java.util.Date;
import javax.inject.Singleton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

@Singleton
public class WeightListView
extends BaseListView {
    private static final int COLUMN_COUNT = 3;
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_WEIGHT = 1;
    private static final int COLUMN_COMMENT = 2;
    private static final int HIDDEN_COLUMN_ID = 3;
    private String[] columnNames;
    private WeightsTableModel tmWeights;

    @Override
    public void initView() {
        this.columnNames = new String[3];
        this.columnNames[0] = this.getContext().getResReader().getString("st.weightlistview.date", new Object[0]);
        this.columnNames[1] = this.getContext().getResReader().getString("st.weightlistview.weight", new Object[0]);
        this.columnNames[2] = this.getContext().getResReader().getString("st.weightlistview.comment", new Object[0]);
        this.tmWeights = new WeightsTableModel();
        this.createTable();
        this.getTable().setAutoResizeMode(3);
        TableColumnModel tcModel = this.getTable().getColumnModel();
        tcModel.getColumn(0).setWidth(80);
        tcModel.getColumn(1).setWidth(80);
        tcModel.getColumn(2).setPreferredWidth(520);
    }

    @Override
    protected String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    protected AbstractTableModel getTableModel() {
        return this.tmWeights;
    }

    @Override
    protected DefaultTableCellRenderer getTableCellRender() {
        return new WeightCellRenderer();
    }

    @Override
    public int getSelectedWeightCount() {
        return this.getTable().getSelectedRowCount();
    }

    @Override
    public int[] getSelectedWeightIDs() {
        int[] selectedRows = this.getTable().getSelectedRows();
        int[] selectedIDs = new int[selectedRows.length];
        int i = 0;
        while (i < selectedIDs.length) {
            int modelRow = this.getTable().convertRowIndexToModel(selectedRows[i]);
            selectedIDs[i] = (Integer)this.tmWeights.getValueAt(modelRow, 3);
            ++i;
        }
        return selectedIDs;
    }

    @Override
    public void print() throws STException {
        if (!this.getController().checkForExistingWeights()) {
            return;
        }
        this.printList(this.getContext().getResReader().getString("st.weightlistview.print.title", new Object[0]), this.getContext().getResReader().getString("st.weightlistview.print.page", new Object[0]));
    }

    class WeightCellRenderer
    extends BaseListView.BaseListCellRenderer {
        WeightCellRenderer() {
            super(WeightListView.this);
        }

        @Override
        protected String formatText(Object value, int rowIndex, int columnIndex) {
            FormatUtils formatUtils = WeightListView.this.getContext().getFormatUtils();
            switch (columnIndex) {
                case 1: {
                    return formatUtils.weightToString(((Float)value).floatValue(), 2);
                }
                case 2: {
                    return formatUtils.firstLineOfText((String)value);
                }
            }
            return super.formatText(value, rowIndex, columnIndex);
        }
    }

    class WeightsTableModel
    extends BaseListView.BaseListTableModel {
        WeightsTableModel() {
            super(WeightListView.this);
        }

        @Override
        public int getRowCount() {
            return WeightListView.this.getDocument().getWeightList().size();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Date.class;
                }
                case 1: {
                    return Float.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Weight weight = (Weight)WeightListView.this.getDocument().getWeightList().getAt(row);
            switch (col) {
                case 0: {
                    return weight.getDate();
                }
                case 1: {
                    return Float.valueOf(weight.getValue());
                }
                case 2: {
                    return weight.getComment();
                }
                case 3: {
                    return weight.getId();
                }
            }
            return null;
        }
    }
}

