/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.storage;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.data.WeightList;
import de.saring.sportstracker.storage.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class XMLWeightList {
    private static final String XSD_WEIGHTS = "weights.xsd";
    private SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public WeightList readWeightList(String source) throws STException {
        try {
            WeightList weightList = new WeightList();
            File fSource = new File(source);
            if (!fSource.exists()) {
                return weightList;
            }
            Document document = XMLUtils.getJDOMDocument(fSource, XSD_WEIGHTS);
            Element eWeightList = document.getRootElement();
            List lWeights = eWeightList.getChildren("weight");
            for (Element eWeight : lWeights) {
                weightList.set(this.readWeight(eWeight));
            }
            return weightList;
        }
        catch (Exception e) {
            throw new STException(STExceptionID.XMLSTORAGE_READ_WEIGHT_LIST, "Failed to read weight list from XML file '" + source + "' ...", e);
        }
    }

    private Weight readWeight(Element eWeight) throws Exception {
        Weight weight = new Weight(Integer.parseInt(eWeight.getChildText("id")));
        weight.setValue(Float.parseFloat(eWeight.getChildText("value")));
        weight.setComment(eWeight.getChildText("comment"));
        String strDate = eWeight.getChildText("date");
        try {
            weight.setDate(this.sdFormat.parse(strDate));
        }
        catch (Exception exception) {
            throw new Exception("Failed to parse weight with ID '" + weight.getId() + "', the date format '" + strDate + "' is not valid!");
        }
        return weight;
    }

    public void storeWeightList(WeightList weightList, String destination) throws STException {
        Element eWeightList = this.createWeightListElement(weightList);
        try {
            XMLUtils.writeXMLFile(eWeightList, destination);
        }
        catch (IOException e) {
            throw new STException(STExceptionID.XMLSTORAGE_STORE_WEIGHT_LIST, "Failed to write weight list to XML file '" + destination + "' ...", e);
        }
    }

    private Element createWeightListElement(WeightList weightList) {
        Element eWeightList = new Element("weight-list");
        for (Weight weight : weightList) {
            Element eWeight = new Element("weight");
            eWeightList.addContent(eWeight);
            XMLUtils.addElement(eWeight, "id", String.valueOf(weight.getId()));
            XMLUtils.addElement(eWeight, "date", this.sdFormat.format(weight.getDate()));
            XMLUtils.addElement(eWeight, "value", String.valueOf(weight.getValue()));
            XMLUtils.addElement(eWeight, "comment", weight.getComment());
        }
        return eWeightList;
    }
}

