/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui.panels;

import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.panels.BasePanel;
import de.saring.util.ResourceReader;
import de.saring.util.gui.jfreechart.ChartUtils;
import de.saring.util.unitcalc.ConvertUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Series;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class DiagramPanel
extends BasePanel {
    private ChartPanel chartPanel;
    private boolean fIgnoreUpdateDiagramActions = false;
    private int highlightHeartrateRange = -1;
    private static final Color COLOR_AXIS_LEFT = Color.RED;
    private static final Color COLOR_AXIS_RIGHT = Color.BLUE;
    private static final Color COLOR_MARKER_LAP = new Color(0.0f, 0.73f, 0.0f);
    private static final Color COLOR_MARKER_HEARTRATE = Color.LIGHT_GRAY;
    private static final String ACTION_UPDATE_DIAGRAM = "pv.diagram.update";
    private JComboBox cbBottom;
    private JComboBox cbLeft;
    private JComboBox cbRight;
    private JLabel laAxis;
    private JLabel laBottom;
    private JLabel laLeft;
    private JLabel laRight;
    private JPanel pButtons;
    private JPanel pDiagram;

    @Inject
    public DiagramPanel(EVContext context) {
        super(context);
        this.initComponents();
        AxisType.setResReader(this.getContext().getResReader());
        AxisType.setFormatUtils(this.getContext().getFormatUtils());
        this.chartPanel = new ChartPanel(null);
        this.pDiagram.add((Component)this.chartPanel, "Center");
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.chartPanel.setMaximumDrawWidth((int)dimScreen.getWidth());
        this.chartPanel.setMaximumDrawHeight((int)dimScreen.getHeight());
        ApplicationActionMap actionMap = this.getContext().getSAFContext().getActionMap(this.getClass(), (Object)this);
        javax.swing.Action aUpdate = actionMap.get(ACTION_UPDATE_DIAGRAM);
        this.cbLeft.setAction(aUpdate);
        this.cbRight.setAction(aUpdate);
        this.cbBottom.setAction(aUpdate);
    }

    @Override
    public void displayExercise() {
        EVExercise exercise = this.getDocument().getExercise();
        this.fIgnoreUpdateDiagramActions = true;
        this.cbLeft.addItem(AxisType.Heartrate);
        this.cbRight.addItem(AxisType.Nothing);
        this.cbRight.addItem(AxisType.Heartrate);
        this.cbBottom.addItem(AxisType.Time);
        if (exercise.getRecordingMode().isAltitude()) {
            this.cbLeft.addItem(AxisType.Altitude);
            this.cbRight.addItem(AxisType.Altitude);
        }
        if (exercise.getRecordingMode().isSpeed()) {
            this.cbLeft.addItem(AxisType.Speed);
            this.cbRight.addItem(AxisType.Speed);
            this.cbBottom.addItem(AxisType.Distance);
        }
        if (exercise.getRecordingMode().isCadence()) {
            this.cbLeft.addItem(AxisType.Cadence);
            this.cbRight.addItem(AxisType.Cadence);
        }
        if (exercise.getRecordingMode().isTemperature()) {
            this.cbLeft.addItem(AxisType.Temperature);
            this.cbRight.addItem(AxisType.Temperature);
        }
        if (this.getDocument().getOptions().isDisplaySecondDiagram() && this.cbRight.getItemCount() > 2) {
            this.cbRight.setSelectedIndex(2);
        }
        this.fIgnoreUpdateDiagramActions = false;
        this.updateDiagram();
    }

    public void displayDiagramForHeartrateRange(int rangeIndex) {
        this.highlightHeartrateRange = rangeIndex;
        if (this.cbLeft.getItemCount() > 0) {
            this.updateDiagram();
        }
    }

    @Action(name="pv.diagram.update")
    public void updateDiagram() {
        HeartRateLimit currentLimit;
        Second second;
        Number valueRight;
        Number valueLeft;
        int i;
        if (this.fIgnoreUpdateDiagramActions) {
            return;
        }
        EVExercise exercise = this.getDocument().getExercise();
        AxisType axisTypeLeft = (AxisType)((Object)this.cbLeft.getSelectedItem());
        AxisType axisTypeRight = (AxisType)((Object)this.cbRight.getSelectedItem());
        AxisType axisTypeBottom = (AxisType)((Object)this.cbBottom.getSelectedItem());
        boolean fDomainAxisTime = axisTypeBottom == AxisType.Time;
        Series sLeft = this.createSeries(fDomainAxisTime, "left");
        Series sRight = null;
        if (axisTypeRight != AxisType.Nothing && axisTypeRight != axisTypeLeft) {
            sRight = this.createSeries(fDomainAxisTime, "right");
        }
        if (exercise.getSampleList() != null) {
            i = 0;
            while (i < exercise.getSampleList().length) {
                ExerciseSample sample = exercise.getSampleList()[i];
                valueLeft = this.getSampleValue(axisTypeLeft, sample);
                valueRight = this.getSampleValue(axisTypeRight, sample);
                if (fDomainAxisTime) {
                    int timeSeconds = (int)(sample.getTimestamp() / 1000L);
                    second = this.createJFreeChartSecond(timeSeconds);
                    this.fillDataInTimeSeries((TimeSeries)sLeft, (TimeSeries)sRight, second, valueLeft, valueRight);
                } else {
                    double fDistance = (float)sample.getDistance() / 1000.0f;
                    if (this.getContext().getFormatUtils().getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                        fDistance = ConvertUtils.convertKilometer2Miles((double)fDistance, (boolean)false);
                    }
                    this.fillDataInXYSeries((XYSeries)sLeft, (XYSeries)sRight, fDistance, valueLeft, valueRight);
                }
                ++i;
            }
        } else if (exercise.getLapList() != null) {
            if (fDomainAxisTime) {
                this.fillDataInTimeSeries((TimeSeries)sLeft, (TimeSeries)sRight, this.createJFreeChartSecond(0), 0, 0);
            } else {
                this.fillDataInXYSeries((XYSeries)sLeft, (XYSeries)sRight, 0.0, 0, 0);
            }
            i = 0;
            while (i < exercise.getLapList().length) {
                Lap lap = exercise.getLapList()[i];
                valueLeft = this.getLapValue(axisTypeLeft, lap);
                valueRight = this.getLapValue(axisTypeRight, lap);
                if (fDomainAxisTime) {
                    int timeSeconds = Math.round((float)lap.getTimeSplit() / 10.0f);
                    second = this.createJFreeChartSecond(timeSeconds);
                    this.fillDataInTimeSeries((TimeSeries)sLeft, (TimeSeries)sRight, second, valueLeft, valueRight);
                } else {
                    double fDistance = (float)lap.getSpeed().getDistance() / 1000.0f;
                    if (this.getContext().getFormatUtils().getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                        fDistance = ConvertUtils.convertKilometer2Miles((double)fDistance, (boolean)false);
                    }
                    this.fillDataInXYSeries((XYSeries)sLeft, (XYSeries)sRight, fDistance, valueLeft, valueRight);
                }
                ++i;
            }
        }
        XYDataset dataset = this.createDataSet(fDomainAxisTime, sLeft);
        JFreeChart chart = null;
        chart = fDomainAxisTime ? ChartFactory.createTimeSeriesChart(null, (String)axisTypeBottom.toString(), (String)axisTypeLeft.toString(), (XYDataset)dataset, (boolean)false, (boolean)true, (boolean)false) : ChartFactory.createXYLineChart(null, (String)axisTypeBottom.toString(), (String)axisTypeLeft.toString(), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ChartUtils.customizeChart((JFreeChart)chart, (JComponent)this.chartPanel);
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis axisLeft = plot.getRangeAxis(0);
        axisLeft.setLabelPaint((Paint)COLOR_AXIS_LEFT);
        axisLeft.setTickLabelPaint((Paint)COLOR_AXIS_LEFT);
        XYItemRenderer rendererLeft = plot.getRenderer(0);
        rendererLeft.setSeriesPaint(0, (Paint)COLOR_AXIS_LEFT);
        this.setTooltipGenerator(rendererLeft, axisTypeBottom, axisTypeLeft);
        if (sRight != null) {
            NumberAxis axisRight = new NumberAxis(axisTypeRight.toString());
            axisRight.setAutoRangeIncludesZero(false);
            plot.setRangeAxis(1, (ValueAxis)axisRight);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            axisRight.setLabelPaint((Paint)COLOR_AXIS_RIGHT);
            axisRight.setTickLabelPaint((Paint)COLOR_AXIS_RIGHT);
            XYDataset datasetRight = this.createDataSet(fDomainAxisTime, sRight);
            plot.setDataset(1, datasetRight);
            plot.mapDatasetToRangeAxis(1, 1);
            StandardXYItemRenderer rendererRight = new StandardXYItemRenderer();
            rendererRight.setSeriesPaint(0, (Paint)COLOR_AXIS_RIGHT);
            plot.setRenderer(1, (XYItemRenderer)rendererRight);
            this.setTooltipGenerator((XYItemRenderer)rendererRight, axisTypeBottom, axisTypeRight);
        }
        if (this.highlightHeartrateRange >= 0 && axisTypeLeft == AxisType.Heartrate && (currentLimit = exercise.getHeartRateLimits()[this.highlightHeartrateRange]).isAbsoluteRange()) {
            IntervalMarker hrRangeMarker = new IntervalMarker((double)currentLimit.getLowerHeartRate(), (double)currentLimit.getUpperHeartRate());
            hrRangeMarker.setPaint((Paint)COLOR_MARKER_HEARTRATE);
            hrRangeMarker.setAlpha(0.3f);
            plot.addRangeMarker((Marker)hrRangeMarker);
        }
        if (exercise.getLapList().length > 0) {
            int i2 = 0;
            while (i2 < exercise.getLapList().length - 1) {
                double lapSplitValue;
                Lap lap = exercise.getLapList()[i2];
                if (fDomainAxisTime) {
                    int lapSplitSeconds = lap.getTimeSplit() / 10;
                    lapSplitValue = this.createJFreeChartSecond(lapSplitSeconds).getFirstMillisecond();
                } else {
                    lapSplitValue = (double)lap.getSpeed().getDistance() / 1000.0;
                    if (this.getContext().getFormatUtils().getUnitSystem() == FormatUtils.UnitSystem.English) {
                        lapSplitValue = ConvertUtils.convertKilometer2Miles((double)lapSplitValue, (boolean)false);
                    }
                }
                ValueMarker lapMarker = new ValueMarker(lapSplitValue);
                lapMarker.setPaint((Paint)COLOR_MARKER_LAP);
                lapMarker.setStroke((Stroke)new BasicStroke(1.5f));
                lapMarker.setLabel(this.getContext().getResReader().getString("pv.diagram.lap", new Object[]{i2 + 1}));
                lapMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                lapMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                plot.addDomainMarker((Marker)lapMarker);
                ++i2;
            }
        }
        this.chartPanel.setChart(chart);
    }

    private Second createJFreeChartSecond(int seconds) {
        return new Second(new Date(seconds * 1000 - 3600000));
    }

    private Series createSeries(boolean fDomainAxisTime, String name) {
        if (fDomainAxisTime) {
            return new TimeSeries((Comparable)((Object)name));
        }
        return new XYSeries((Comparable)((Object)name));
    }

    private XYDataset createDataSet(boolean fDomainAxisTime, Series series) {
        if (fDomainAxisTime) {
            return new TimeSeriesCollection((TimeSeries)series);
        }
        return new XYSeriesCollection((XYSeries)series);
    }

    private void fillDataInTimeSeries(TimeSeries sLeft, TimeSeries sRight, Second second, Number valueLeft, Number valueRight) {
        if (sLeft.getValue((RegularTimePeriod)second) == null) {
            sLeft.add((RegularTimePeriod)second, valueLeft);
            if (sRight != null) {
                sRight.add((RegularTimePeriod)second, valueRight);
            }
        }
    }

    private void fillDataInXYSeries(XYSeries sLeft, XYSeries sRight, double valueBottom, Number valueLeft, Number valueRight) {
        sLeft.add(valueBottom, valueLeft);
        if (sRight != null) {
            sRight.add(valueBottom, valueRight);
        }
    }

    private void setTooltipGenerator(XYItemRenderer renderer, AxisType domainAxis, AxisType valueAxis) {
        String format = (Object)((Object)domainAxis) + ": {1}, " + (Object)((Object)valueAxis) + ": {2}";
        if (domainAxis == AxisType.Time) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator(format, (DateFormat)new SimpleDateFormat("HH:mm"), (NumberFormat)new DecimalFormat()));
        } else {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator(format, (NumberFormat)new DecimalFormat(), (NumberFormat)new DecimalFormat()));
        }
    }

    private Number getSampleValue(AxisType axisType, ExerciseSample sample) {
        FormatUtils formatUtils = this.getContext().getFormatUtils();
        switch (axisType) {
            case Heartrate: {
                return sample.getHeartRate();
            }
            case Altitude: {
                if (formatUtils.getUnitSystem() == FormatUtils.UnitSystem.Metric) {
                    return sample.getAltitude();
                }
                return ConvertUtils.convertMeter2Feet((int)sample.getAltitude());
            }
            case Speed: {
                float speed = sample.getSpeed();
                if (formatUtils.getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                    speed = (float)ConvertUtils.convertKilometer2Miles((double)speed, (boolean)false);
                }
                if (formatUtils.getSpeedView() == FormatUtils.SpeedView.MinutesPerDistance && speed != 0.0f) {
                    speed = 60.0f / speed;
                }
                return Float.valueOf(speed);
            }
            case Cadence: {
                return sample.getCadence();
            }
            case Temperature: {
                if (formatUtils.getUnitSystem() == FormatUtils.UnitSystem.Metric) {
                    return sample.getTemperature();
                }
                return ConvertUtils.convertCelsius2Fahrenheit((short)sample.getTemperature());
            }
        }
        return 0;
    }

    private Number getLapValue(AxisType axisType, Lap lap) {
        FormatUtils formatUtils = this.getContext().getFormatUtils();
        switch (axisType) {
            case Heartrate: {
                return lap.getHeartRateAVG();
            }
            case Speed: {
                float speed = lap.getSpeed().getSpeedAVG();
                if (formatUtils.getUnitSystem() != FormatUtils.UnitSystem.Metric) {
                    speed = (float)ConvertUtils.convertKilometer2Miles((double)speed, (boolean)false);
                }
                if (formatUtils.getSpeedView() == FormatUtils.SpeedView.MinutesPerDistance && speed != 0.0f) {
                    speed = 60.0f / speed;
                }
                return Float.valueOf(speed);
            }
        }
        return 0;
    }

    private void initComponents() {
        this.pDiagram = new JPanel();
        this.pButtons = new JPanel();
        this.laAxis = new JLabel();
        this.laLeft = new JLabel();
        this.cbLeft = new JComboBox();
        this.laRight = new JLabel();
        this.cbRight = new JComboBox();
        this.laBottom = new JLabel();
        this.cbBottom = new JComboBox();
        this.pDiagram.setLayout(new BorderLayout());
        this.laAxis.setFont(this.laAxis.getFont().deriveFont(this.laAxis.getFont().getStyle() | 1));
        this.laAxis.setText("_Axis Usage");
        this.laAxis.setName("pv.diagram.axis_usage");
        this.laLeft.setText("_Left:");
        this.laLeft.setName("pv.diagram.left");
        this.laRight.setText("_Right:");
        this.laRight.setName("pv.diagram.right");
        this.laBottom.setText("_Bottom:");
        this.laBottom.setName("pv.diagram.bottom");
        GroupLayout pButtonsLayout = new GroupLayout(this.pButtons);
        this.pButtons.setLayout(pButtonsLayout);
        pButtonsLayout.setHorizontalGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pButtonsLayout.createSequentialGroup().addGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAxis).addGroup(pButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.laLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLeft, -2, -1, -2).addGap(25, 25, 25).addComponent(this.laRight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRight, -2, -1, -2).addGap(25, 25, 25).addComponent(this.laBottom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBottom, -2, -1, -2))).addContainerGap(204, Short.MAX_VALUE)));
        pButtonsLayout.setVerticalGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.laAxis).addGap(15, 15, 15).addGroup(pButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laLeft).addComponent(this.cbLeft, -2, -1, -2).addComponent(this.laRight).addComponent(this.cbRight, -2, -1, -2).addComponent(this.laBottom).addComponent(this.cbBottom, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pDiagram, GroupLayout.Alignment.LEADING, -1, 528, Short.MAX_VALUE).addComponent(this.pButtons, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.pDiagram, -1, 204, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pButtons, -2, -1, -2).addContainerGap()));
    }

    private static enum AxisType {
        Nothing,
        Heartrate,
        Altitude,
        Speed,
        Cadence,
        Temperature,
        Time,
        Distance;

        private static ResourceReader resReader;
        private static FormatUtils formatUtils;

        public static void setResReader(ResourceReader resReader) {
            AxisType.resReader = resReader;
        }

        public static void setFormatUtils(FormatUtils formatUtils) {
            AxisType.formatUtils = formatUtils;
        }

        public String toString() {
            switch (this) {
                case Nothing: {
                    return resReader.getString("pv.diagram.axis.nothing", new Object[0]);
                }
                case Heartrate: {
                    return resReader.getString("pv.diagram.axis.heartrate", new Object[0]);
                }
                case Altitude: {
                    return resReader.getString("pv.diagram.axis.altitude", new Object[]{formatUtils.getAltitudeUnitName()});
                }
                case Speed: {
                    return resReader.getString("pv.diagram.axis.speed", new Object[]{formatUtils.getSpeedUnitName()});
                }
                case Cadence: {
                    return resReader.getString("pv.diagram.axis.cadence", new Object[0]);
                }
                case Temperature: {
                    return resReader.getString("pv.diagram.axis.temperature", new Object[]{formatUtils.getTemperatureUnitName()});
                }
                case Time: {
                    return resReader.getString("pv.diagram.axis.time", new Object[0]);
                }
                case Distance: {
                    return resReader.getString("pv.diagram.axis.distance", new Object[]{formatUtils.getDistanceUnitName()});
                }
            }
            return "???";
        }
    }
}

