/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.parser.ExerciseParser;
import de.saring.util.unitcalc.CalculationUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;

public abstract class AbstractExerciseParser
implements ExerciseParser {
    protected int[] readFileToByteArray(String filename) throws EVException {
        try {
            File file = new File(filename);
            FileInputStream fiStream = new FileInputStream(file);
            int fileLength = (int)file.length();
            byte[] byteBuffer = new byte[fileLength];
            int[] intBuffer = new int[fileLength];
            if (fiStream.read(byteBuffer) != fileLength) {
                throw new Exception("Failed to read complete file content ...");
            }
            int i = 0;
            while (i < fileLength) {
                intBuffer[i] = this.unsignedByteToInt(byteBuffer[i]);
                ++i;
            }
            fiStream.close();
            return intBuffer;
        }
        catch (Exception e) {
            throw new EVException("Failed to read binary content from exercise file '" + filename + "' ...", e);
        }
    }

    protected String[] readFileToStringArray(String filename) throws EVException {
        try {
            BufferedReader bufReader = new BufferedReader(new FileReader(filename));
            ArrayList<String> lLines = new ArrayList<String>();
            String strCurrentLine = null;
            while ((strCurrentLine = bufReader.readLine()) != null) {
                lLines.add(strCurrentLine);
            }
            bufReader.close();
            return lLines.toArray(new String[lLines.size()]);
        }
        catch (Exception e) {
            throw new EVException("Failed to read text content from exercise file '" + filename + "' ...", e);
        }
    }

    private int unsignedByteToInt(byte value) {
        return value & 0xFF;
    }

    protected void calculateAverageLapSpeed(EVExercise exercise) {
        if (!exercise.getRecordingMode().isSpeed() || exercise.getLapList() == null) {
            return;
        }
        int distanceBefore = 0;
        int timeSplitBefore = 0;
        Lap[] lapArray = exercise.getLapList();
        int n = lapArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lap lap = lapArray[n2];
            int lapDistance = lap.getSpeed().getDistance() - distanceBefore;
            int lapDuration = lap.getTimeSplit() - timeSplitBefore;
            distanceBefore = lap.getSpeed().getDistance();
            timeSplitBefore = lap.getTimeSplit();
            lap.getSpeed().setSpeedAVG(CalculationUtils.calculateAvgSpeed((float)((float)lapDistance / 1000.0f), (int)Math.round((float)lapDuration / 10.0f)));
            ++n2;
        }
    }
}

