/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseAltitude;
import de.saring.exerciseviewer.data.ExerciseCadence;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.ExerciseSpeed;
import de.saring.exerciseviewer.data.ExerciseTemperature;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.LapAltitude;
import de.saring.exerciseviewer.data.LapSpeed;
import de.saring.exerciseviewer.data.LapTemperature;
import de.saring.exerciseviewer.data.RecordingMode;
import de.saring.exerciseviewer.parser.AbstractExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import de.saring.util.unitcalc.ConvertUtils;
import java.util.Calendar;

public class PolarSRawParser
extends AbstractExerciseParser {
    private final ExerciseParserInfo info = new ExerciseParserInfo("Polar SRD", new String[]{"srd", "SRD"});
    private int[] fileContent;

    @Override
    public ExerciseParserInfo getInfo() {
        return this.info;
    }

    @Override
    public EVExercise parseExercise(String filename) throws EVException {
        this.fileContent = this.readFileToByteArray(filename);
        boolean fS610 = this.fileContent[34] == 0 && this.fileContent[36] == 251;
        EVExercise exercise = new EVExercise();
        if (!fS610) {
            exercise.setFileType(EVExercise.ExerciseFileType.S710RAW);
        } else {
            exercise.setFileType(EVExercise.ExerciseFileType.S610RAW);
        }
        int bytesInFile = this.fileContent[1] * 256 + this.fileContent[0];
        if (bytesInFile != this.fileContent.length) {
            throw new EVException("The exercise file is not valid, the file length is not correct ...");
        }
        exercise.setType((byte)this.fileContent[2]);
        StringBuilder sbExerciseLabel = new StringBuilder();
        int i = 0;
        while (i < 7) {
            sbExerciseLabel.append(this.decodeChar(this.fileContent[i + 3]));
            ++i;
        }
        exercise.setTypeLabel(sbExerciseLabel.toString());
        int dateSeconds = this.decodeBCD(this.fileContent[10]);
        int dateMinutes = this.decodeBCD(this.fileContent[11]);
        int dateHours = this.decodeBCD(this.fileContent[12] & 0x7F);
        int dateDay = this.decodeBCD(this.fileContent[13] & 0x7F);
        int dateYear = 2000 + this.decodeBCD(this.fileContent[14]);
        int dateMonth = this.fileContent[15] & 0xF;
        if (dateHours < 12 && (this.fileContent[12] & 0x80) == 128) {
            dateHours += 12;
        }
        Calendar calDate = Calendar.getInstance();
        calDate.set(dateYear, dateMonth - 1, dateDay, dateHours, dateMinutes, dateSeconds);
        exercise.setDate(calDate.getTime());
        int durationTenthSeconds = this.fileContent[15] >> 4;
        int durationSeconds = this.decodeBCD(this.fileContent[16]);
        int durationMinutes = this.decodeBCD(this.fileContent[17]);
        int durationHours = this.decodeBCD(this.fileContent[18]);
        exercise.setDuration(durationHours * 60 * 60 * 10 + durationMinutes * 60 * 10 + durationSeconds * 10 + durationTenthSeconds);
        exercise.setHeartRateAVG((short)this.fileContent[19]);
        exercise.setHeartRateMax((short)this.fileContent[20]);
        int numberOfLaps = this.decodeBCD(this.fileContent[21]);
        exercise.setUserID((byte)this.decodeBCD(this.fileContent[24]));
        boolean fMetricUnits = (this.fileContent[25] & 2) == 0;
        RecordingMode recMode = new RecordingMode();
        exercise.setRecordingMode(recMode);
        if (!fS610) {
            boolean fBike2 = (this.fileContent[26] & 0x20) == 32;
            boolean fBike1 = (this.fileContent[26] & 0x10) == 16;
            recMode.setPower((this.fileContent[26] & 8) == 8);
            recMode.setCadence((this.fileContent[26] & 4) == 4);
            recMode.setAltitude((this.fileContent[26] & 2) == 2);
            if (!fBike1 && !fBike2) {
                recMode.setSpeed(false);
                recMode.setBikeNumber((byte)0);
            } else {
                recMode.setSpeed(true);
                if (fBike1) {
                    recMode.setBikeNumber((byte)1);
                } else {
                    recMode.setBikeNumber((byte)2);
                }
            }
        }
        short recInterval = 0;
        int indexRecInt = this.getProperIndex(27, 26, fS610);
        switch (this.fileContent[indexRecInt] & 0xF) {
            case 0: {
                recInterval = 5;
                break;
            }
            case 1: {
                recInterval = 15;
                break;
            }
            case 2: {
                recInterval = 60;
                break;
            }
            default: {
                throw new EVException("Recording interval '" + this.fileContent[indexRecInt] + "' not valid ...");
            }
        }
        exercise.setRecordingInterval(recInterval);
        boolean fHeartRateRangeAbsolute = (this.fileContent[indexRecInt] & 0x10) == 0;
        int numberOfSamples = exercise.getDuration() / 10 / recInterval + 1;
        int indexHRLimitStart = this.getProperIndex(29, 28, fS610);
        exercise.setHeartRateLimits(new HeartRateLimit[3]);
        exercise.getHeartRateLimits()[0] = this.decodeHeartRateLimit(indexHRLimitStart + 0, indexHRLimitStart + 9);
        exercise.getHeartRateLimits()[1] = this.decodeHeartRateLimit(indexHRLimitStart + 2, indexHRLimitStart + 18);
        exercise.getHeartRateLimits()[2] = this.decodeHeartRateLimit(indexHRLimitStart + 4, indexHRLimitStart + 27);
        HeartRateLimit[] heartRateLimitArray = exercise.getHeartRateLimits();
        int n = heartRateLimitArray.length;
        int n2 = 0;
        while (n2 < n) {
            HeartRateLimit hrLimit = heartRateLimitArray[n2];
            hrLimit.setAbsoluteRange(fHeartRateRangeAbsolute);
            ++n2;
        }
        int indexEnergyStart = this.getProperIndex(70, 69, fS610);
        int energyPart1 = this.decodeBCD(this.fileContent[indexEnergyStart + 0]);
        int energyPart2 = this.decodeBCD(this.fileContent[indexEnergyStart + 1]);
        int energyPart3 = this.decodeBCD(this.fileContent[indexEnergyStart + 2]);
        exercise.setEnergy((energyPart1 + energyPart2 * 100 + energyPart3 * 10000) / 10);
        int indexTotalEnergyStart = this.getProperIndex(73, 72, fS610);
        int energyTotalPart1 = this.decodeBCD(this.fileContent[indexTotalEnergyStart + 0]);
        int energyTotalPart2 = this.decodeBCD(this.fileContent[indexTotalEnergyStart + 1]);
        int energyTotalPart3 = this.decodeBCD(this.fileContent[indexTotalEnergyStart + 2]);
        exercise.setEnergyTotal(energyTotalPart1 + energyTotalPart2 * 100 + energyTotalPart3 * 10000);
        int indexCumWorkoutStart = this.getProperIndex(76, 75, fS610);
        int cumWorkoutPart1 = this.decodeBCD(this.fileContent[indexCumWorkoutStart + 0]);
        int cumWorkoutPart2 = this.decodeBCD(this.fileContent[indexCumWorkoutStart + 1]);
        int cumWorkoutPart3 = this.decodeBCD(this.fileContent[indexCumWorkoutStart + 2]);
        exercise.setSumExerciseTime(cumWorkoutPart3 + cumWorkoutPart1 * 60 + cumWorkoutPart2 * 60 * 100);
        if (!fS610) {
            int cumRidePart1 = this.decodeBCD(this.fileContent[79]);
            int cumRidePart2 = this.decodeBCD(this.fileContent[80]);
            int cumRidePart3 = this.decodeBCD(this.fileContent[81]);
            exercise.setSumRideTime(cumRidePart3 + cumRidePart1 * 60 + cumRidePart2 * 60 * 100);
            int odometerPart1 = this.decodeBCD(this.fileContent[82]);
            int odometerPart2 = this.decodeBCD(this.fileContent[83]);
            int odometerPart3 = this.decodeBCD(this.fileContent[84]);
            int odometer = odometerPart1 + odometerPart2 * 100 + odometerPart3 * 10000;
            if (fMetricUnits) {
                exercise.setOdometer(odometer);
            } else {
                exercise.setOdometer(ConvertUtils.convertMiles2Kilometer((int)odometer));
            }
        }
        if (recMode.isSpeed()) {
            ExerciseSpeed speed = new ExerciseSpeed();
            exercise.setSpeed(speed);
            int distance = (this.fileContent[85] + (this.fileContent[86] << 8)) * 100;
            if (fMetricUnits) {
                speed.setDistance(distance);
            } else {
                speed.setDistance(ConvertUtils.convertMiles2Kilometer((int)distance));
            }
            int avgSpeedPart1 = this.fileContent[87];
            int avgSpeedPart2 = this.fileContent[88] & 0xF;
            float avgSpeed = (float)(avgSpeedPart2 << 8 | avgSpeedPart1) / 16.0f;
            if (fMetricUnits) {
                speed.setSpeedAVG(avgSpeed);
            } else {
                speed.setSpeedAVG((float)ConvertUtils.convertMiles2Kilometer((double)avgSpeed));
            }
            int maxSpeedPart1 = this.fileContent[88] >> 4;
            int maxSpeedPart2 = this.fileContent[89];
            float maxSpeed = (float)(maxSpeedPart2 << 4 | maxSpeedPart1) / 16.0f;
            if (fMetricUnits) {
                speed.setSpeedMax(maxSpeed);
            } else {
                speed.setSpeedMax((float)ConvertUtils.convertMiles2Kilometer((double)maxSpeed));
            }
        }
        if (recMode.isCadence()) {
            ExerciseCadence cadence = new ExerciseCadence();
            exercise.setCadence(cadence);
            cadence.setCadenceAVG((short)this.fileContent[90]);
            cadence.setCadenceMax((short)this.fileContent[91]);
        }
        if (recMode.isAltitude()) {
            ExerciseAltitude altitude = new ExerciseAltitude();
            exercise.setAltitude(altitude);
            altitude.setAltitudeMin(this.decodeAltitude(this.fileContent[92], this.fileContent[93]));
            altitude.setAltitudeAVG(this.decodeAltitude(this.fileContent[94], this.fileContent[95]));
            altitude.setAltitudeMax(this.decodeAltitude(this.fileContent[96], this.fileContent[97]));
            altitude.setAscent(this.fileContent[101] + (this.fileContent[102] << 8));
            if (!fMetricUnits) {
                altitude.setAltitudeMin((short)ConvertUtils.convertFeet2Meter((int)altitude.getAltitudeMin()));
                altitude.setAltitudeAVG((short)ConvertUtils.convertFeet2Meter((int)altitude.getAltitudeAVG()));
                altitude.setAltitudeMax((short)ConvertUtils.convertFeet2Meter((int)altitude.getAltitudeMax()));
                altitude.setAscent(ConvertUtils.convertFeet2Meter((int)altitude.getAscent()));
            }
            ExerciseTemperature temperature = new ExerciseTemperature();
            exercise.setTemperature(temperature);
            temperature.setTemperatureMin(this.decodeTemperature(this.fileContent[98], fMetricUnits));
            temperature.setTemperatureAVG(this.decodeTemperature(this.fileContent[99], fMetricUnits));
            temperature.setTemperatureMax(this.decodeTemperature(this.fileContent[100], fMetricUnits));
        }
        int lapSize = 6;
        if (recMode.isAltitude()) {
            lapSize += 5;
        }
        if (recMode.isSpeed()) {
            if (recMode.isCadence()) {
                ++lapSize;
            }
            if (recMode.isPower()) {
                lapSize += 4;
            }
            lapSize += 4;
        }
        int sampleSize = 1;
        if (recMode.isAltitude()) {
            sampleSize += 2;
        }
        if (recMode.isSpeed()) {
            if (recMode.isAltitude()) {
                --sampleSize;
            }
            if (recMode.isCadence()) {
                ++sampleSize;
            }
            if (recMode.isPower()) {
                sampleSize += 4;
            }
            sampleSize += 2;
        }
        int totalLapSize = numberOfLaps * lapSize;
        int totalSampleSize = numberOfSamples * sampleSize;
        int indexLapsStart = bytesInFile - totalLapSize - totalSampleSize;
        exercise.setLapList(new Lap[numberOfLaps]);
        int i2 = 0;
        while (i2 < numberOfLaps) {
            Lap lap;
            int lapOffset = indexLapsStart + i2 * lapSize;
            exercise.getLapList()[i2] = lap = new Lap();
            int bLapEndHour = this.fileContent[lapOffset + 2];
            int bLapEndMinute = this.fileContent[lapOffset + 1] & 0x3F;
            int bLapEndSecond = this.fileContent[lapOffset] & 0x3F;
            int bLapEndTenthSecond = (this.fileContent[lapOffset + 1] & 0xC0) >> 4 | (this.fileContent[lapOffset] & 0xC0) >> 6;
            lap.setTimeSplit(bLapEndTenthSecond + bLapEndSecond * 10 + bLapEndMinute * 60 * 10 + bLapEndHour * 60 * 60 * 10);
            lap.setHeartRateSplit((short)this.fileContent[lapOffset + 3]);
            lap.setHeartRateAVG((short)this.fileContent[lapOffset + 4]);
            lap.setHeartRateMax((short)this.fileContent[lapOffset + 5]);
            lapOffset += 6;
            if (recMode.isAltitude()) {
                lap.setAltitude(new LapAltitude());
                lap.setTemperature(new LapTemperature());
                short lapEndAltitude = (short)(this.fileContent[lapOffset] + (this.fileContent[lapOffset + 1] << 8) - 512);
                if (fMetricUnits) {
                    lap.getAltitude().setAltitude(lapEndAltitude);
                } else {
                    lap.getAltitude().setAltitude((short)ConvertUtils.convertFeet2Meter((int)(lapEndAltitude * 5)));
                }
                int lapAscent = this.fileContent[lapOffset + 2] + (this.fileContent[lapOffset + 3] << 8);
                if (fMetricUnits) {
                    lap.getAltitude().setAscent(lapAscent);
                } else {
                    lap.getAltitude().setAscent(ConvertUtils.convertFeet2Meter((int)lapAscent));
                }
                if (fMetricUnits) {
                    lap.getTemperature().setTemperature((short)(this.fileContent[lapOffset + 4] - 10));
                } else {
                    lap.getTemperature().setTemperature(ConvertUtils.convertFahrenheit2Celsius((short)((short)(this.fileContent[lapOffset + 4] + 14))));
                }
                lapOffset += 5;
            }
            if (recMode.isSpeed()) {
                lap.setSpeed(new LapSpeed());
                if (recMode.isCadence()) {
                    lap.getSpeed().setCadence((short)this.fileContent[lapOffset]);
                    ++lapOffset;
                }
                if (recMode.isPower()) {
                    lapOffset += 4;
                }
                int lapDistance = (this.fileContent[lapOffset] + (this.fileContent[lapOffset + 1] << 8)) * 100;
                if (fMetricUnits) {
                    lap.getSpeed().setDistance(lapDistance);
                } else {
                    lap.getSpeed().setDistance(ConvertUtils.convertMiles2Kilometer((int)lapDistance));
                }
                float lapEndSpeed = (float)(this.fileContent[lapOffset + 2] + ((this.fileContent[lapOffset + 3] & 0xF0) << 4)) / 16.0f;
                if (fMetricUnits) {
                    lap.getSpeed().setSpeedEnd(lapEndSpeed);
                } else {
                    lap.getSpeed().setSpeedEnd((float)ConvertUtils.convertMiles2Kilometer((double)lapEndSpeed));
                }
                lapOffset += 4;
            }
            ++i2;
        }
        int sampleOffset = indexLapsStart + numberOfLaps * lapSize;
        exercise.setSampleList(new ExerciseSample[numberOfSamples]);
        int i3 = 0;
        while (i3 < numberOfSamples) {
            int sampleIndex = numberOfSamples - i3 - 1;
            ExerciseSample exeSample = new ExerciseSample();
            exeSample.setTimestamp((long)(sampleIndex * exercise.getRecordingInterval()) * 1000L);
            exercise.getSampleList()[sampleIndex] = exeSample;
            exeSample.setHeartRate((short)this.fileContent[sampleOffset]);
            ++sampleOffset;
            if (recMode.isAltitude()) {
                short sampleAltitude = (short)(this.fileContent[sampleOffset] + ((this.fileContent[sampleOffset + 1] & 0x1F) << 8) - 512);
                if (fMetricUnits) {
                    exeSample.setAltitude(sampleAltitude);
                } else {
                    exeSample.setAltitude((short)ConvertUtils.convertFeet2Meter((int)(sampleAltitude * 5)));
                }
                sampleOffset += 2;
            }
            if (recMode.isSpeed()) {
                if (recMode.isAltitude()) {
                    --sampleOffset;
                }
                float sampleSpeed = (float)(((this.fileContent[sampleOffset] & 0xE0) << 3) + this.fileContent[sampleOffset + 1]) / 16.0f;
                if (fMetricUnits) {
                    exeSample.setSpeed(sampleSpeed);
                } else {
                    exeSample.setSpeed((float)ConvertUtils.convertMiles2Kilometer((double)sampleSpeed));
                }
                sampleOffset += 2;
                if (recMode.isPower()) {
                    sampleOffset += 4;
                }
                if (recMode.isCadence()) {
                    exeSample.setCadence((short)this.fileContent[sampleOffset]);
                    ++sampleOffset;
                }
            }
            ++i3;
        }
        if (recMode.isSpeed()) {
            double distanceAccum = 0.0;
            ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
            int n3 = exerciseSampleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ExerciseSample exeSample = exerciseSampleArray[n4];
                exeSample.setDistance((int)distanceAccum);
                distanceAccum += (double)(exeSample.getSpeed() * (float)recInterval / 3.6f);
                ++n4;
            }
        }
        exercise.repairSamples();
        this.calculateAverageLapSpeed(exercise);
        return exercise;
    }

    private char decodeChar(int value) {
        char cDecoded = '?';
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                cDecoded = (char)(48 + value);
                break;
            }
            case 10: {
                cDecoded = ' ';
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                cDecoded = (char)(65 + value - 11);
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                cDecoded = (char)(97 + value - 37);
                break;
            }
            case 63: {
                cDecoded = '-';
                break;
            }
            case 64: {
                cDecoded = '%';
                break;
            }
            case 65: {
                cDecoded = '/';
                break;
            }
            case 66: {
                cDecoded = '(';
                break;
            }
            case 67: {
                cDecoded = ')';
                break;
            }
            case 68: {
                cDecoded = '*';
                break;
            }
            case 69: {
                cDecoded = '+';
                break;
            }
            case 70: {
                cDecoded = '.';
                break;
            }
            case 71: {
                cDecoded = ':';
                break;
            }
            case 72: {
                cDecoded = '?';
                break;
            }
        }
        return cDecoded;
    }

    private int decodeBCD(int value) {
        return (value >> 4) * 10 + (value & 0xF);
    }

    private int getProperIndex(int indexS710, int indexS610, boolean fS610) {
        if (fS610) {
            return indexS610;
        }
        return indexS710;
    }

    private HeartRateLimit decodeHeartRateLimit(int offsetLimits, int offsetTimes) {
        HeartRateLimit hrLimit = new HeartRateLimit();
        hrLimit.setLowerHeartRate((short)this.fileContent[offsetLimits + 0]);
        hrLimit.setUpperHeartRate((short)this.fileContent[offsetLimits + 1]);
        int hrLimitBelowSecs = this.decodeBCD(this.fileContent[offsetTimes + 0]);
        hrLimitBelowSecs += this.decodeBCD(this.fileContent[offsetTimes + 1]) * 60;
        hrLimit.setTimeBelow(hrLimitBelowSecs += this.decodeBCD(this.fileContent[offsetTimes + 2]) * 60 * 60);
        int hrLimitWithinSecs = this.decodeBCD(this.fileContent[offsetTimes + 3]);
        hrLimitWithinSecs += this.decodeBCD(this.fileContent[offsetTimes + 4]) * 60;
        hrLimit.setTimeWithin(hrLimitWithinSecs += this.decodeBCD(this.fileContent[offsetTimes + 5]) * 60 * 60);
        int hrLimitAboveSecs = this.decodeBCD(this.fileContent[offsetTimes + 6]);
        hrLimitAboveSecs += this.decodeBCD(this.fileContent[offsetTimes + 7]) * 60;
        hrLimit.setTimeAbove(hrLimitAboveSecs += this.decodeBCD(this.fileContent[offsetTimes + 8]) * 60 * 60);
        return hrLimit;
    }

    private short decodeAltitude(int lsb, int msb) {
        short altitude = (short)(lsb + ((msb & 0x7F) << 8));
        if ((msb & 0x80) != 128) {
            altitude = (short)(altitude * -1);
        }
        return altitude;
    }

    private short decodeTemperature(int temperature, boolean fMetricUnits) {
        if (fMetricUnits) {
            short tempValue = (short)(temperature & 0x7F);
            if ((temperature & 0x80) != 128) {
                tempValue = (short)(tempValue * -1);
            }
            return tempValue;
        }
        return ConvertUtils.convertFahrenheit2Celsius((short)((short)temperature));
    }
}

