/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.database;

import com._17od.upm.crypto.CryptoException;
import com._17od.upm.crypto.DESDecryptionService;
import com._17od.upm.crypto.EncryptionService;
import com._17od.upm.crypto.InvalidPasswordException;
import com._17od.upm.database.AccountInformation;
import com._17od.upm.database.DatabaseHeader;
import com._17od.upm.database.DatabaseOptions;
import com._17od.upm.database.PasswordDatabase;
import com._17od.upm.database.ProblemReadingDatabaseFile;
import com._17od.upm.database.Revision;
import com._17od.upm.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;

public class PasswordDatabasePersistence {
    private static final String FILE_HEADER = "UPM";
    private static final int DB_VERSION = 3;
    private EncryptionService encryptionService;

    public PasswordDatabasePersistence() {
    }

    public PasswordDatabasePersistence(char[] password) throws CryptoException {
        this.encryptionService = new EncryptionService(password);
    }

    public PasswordDatabase load(File databaseFile) throws InvalidPasswordException, ProblemReadingDatabaseFile, IOException {
        byte[] fullDatabase = this.readFile(databaseFile);
        if (fullDatabase.length < 8) {
            throw new ProblemReadingDatabaseFile("This file doesn't appear to be a UPM password database");
        }
        PasswordDatabase passwordDatabase = null;
        ByteArrayInputStream is = null;
        Revision revision = null;
        DatabaseOptions dbOptions = null;
        HashMap<String, AccountInformation> accounts = null;
        Charset charset = Charset.forName("UTF-8");
        byte[] header = new byte[FILE_HEADER.getBytes().length];
        System.arraycopy(fullDatabase, 0, header, 0, header.length);
        if (Arrays.equals(header, FILE_HEADER.getBytes())) {
            int dbVersionPos = header.length;
            int saltPos = dbVersionPos + 1;
            int encryptedBytesPos = saltPos + 8;
            byte dbVersion = fullDatabase[dbVersionPos];
            if (dbVersion == 2 || dbVersion == 3) {
                byte[] decryptedBytes;
                byte[] salt = new byte[8];
                System.arraycopy(fullDatabase, saltPos, salt, 0, 8);
                int encryptedBytesLength = fullDatabase.length - encryptedBytesPos;
                byte[] encryptedBytes = new byte[encryptedBytesLength];
                System.arraycopy(fullDatabase, encryptedBytesPos, encryptedBytes, 0, encryptedBytesLength);
                if (dbVersion < 3) {
                    charset = Util.defaultCharset();
                }
                try {
                    decryptedBytes = this.encryptionService.decrypt(encryptedBytes);
                }
                catch (CryptoException e1) {
                    throw new InvalidPasswordException();
                }
                is = new ByteArrayInputStream(decryptedBytes);
                try {
                    revision = new Revision(is);
                    dbOptions = new DatabaseOptions(is);
                    accounts = new HashMap<String, AccountInformation>();
                    try {
                        while (true) {
                            AccountInformation ai = new AccountInformation(is, charset);
                            accounts.put(ai.getAccountName(), ai);
                        }
                    }
                    catch (EOFException ai) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new ProblemReadingDatabaseFile(e.getMessage(), e);
                }
            }
            throw new ProblemReadingDatabaseFile("Don't know how to handle database version [" + dbVersion + "]");
        }
        throw new InvalidPasswordException();
        passwordDatabase = new PasswordDatabase(revision, dbOptions, accounts, databaseFile);
        return passwordDatabase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PasswordDatabase load(File databaseFile, char[] password) throws IOException, ProblemReadingDatabaseFile, InvalidPasswordException, CryptoException {
        byte[] fullDatabase = this.readFile(databaseFile);
        if (fullDatabase.length < 8) {
            throw new ProblemReadingDatabaseFile("This file doesn't appear to be a UPM password database");
        }
        ByteArrayInputStream is = null;
        Revision revision = null;
        DatabaseOptions dbOptions = null;
        Charset charset = Charset.forName("UTF-8");
        byte[] header = new byte[FILE_HEADER.getBytes().length];
        System.arraycopy(fullDatabase, 0, header, 0, header.length);
        if (Arrays.equals(header, FILE_HEADER.getBytes())) {
            byte[] decryptedBytes;
            int dbVersionPos = header.length;
            int saltPos = dbVersionPos + 1;
            int encryptedBytesPos = saltPos + 8;
            byte dbVersion = fullDatabase[dbVersionPos];
            if (dbVersion != 2) {
                if (dbVersion != 3) throw new ProblemReadingDatabaseFile("Don't know how to handle database version [" + dbVersion + "]");
            }
            byte[] salt = new byte[8];
            System.arraycopy(fullDatabase, saltPos, salt, 0, 8);
            int encryptedBytesLength = fullDatabase.length - encryptedBytesPos;
            byte[] encryptedBytes = new byte[encryptedBytesLength];
            System.arraycopy(fullDatabase, encryptedBytesPos, encryptedBytes, 0, encryptedBytesLength);
            if (dbVersion < 3) {
                charset = Util.defaultCharset();
            }
            this.encryptionService = new EncryptionService(password, salt);
            try {
                decryptedBytes = this.encryptionService.decrypt(encryptedBytes);
            }
            catch (CryptoException e) {
                throw new InvalidPasswordException();
            }
            is = new ByteArrayInputStream(decryptedBytes);
            revision = new Revision(is);
            dbOptions = new DatabaseOptions(is);
        } else {
            if (fullDatabase.length < 8) {
                throw new ProblemReadingDatabaseFile("This file doesn't appear to be a UPM password database");
            }
            byte[] salt = new byte[8];
            System.arraycopy(fullDatabase, 0, salt, 0, 8);
            int encryptedBytesLength = fullDatabase.length - 8;
            byte[] encryptedBytes = new byte[encryptedBytesLength];
            System.arraycopy(fullDatabase, 8, encryptedBytes, 0, encryptedBytesLength);
            byte[] decryptedBytes = null;
            try {
                decryptedBytes = DESDecryptionService.decrypt(password, salt, encryptedBytes);
            }
            catch (CryptoException e) {
                throw new InvalidPasswordException();
            }
            is = new ByteArrayInputStream(decryptedBytes);
            DatabaseHeader dh = new DatabaseHeader(is);
            if (dh.getVersion().equals("1.1.0")) {
                revision = new Revision(is);
                dbOptions = new DatabaseOptions(is);
            } else {
                if (!dh.getVersion().equals("1.0.0")) throw new ProblemReadingDatabaseFile("Don't know how to handle database version [" + dh.getVersion() + "]");
                revision = new Revision();
                dbOptions = new DatabaseOptions();
            }
            this.encryptionService = new EncryptionService(password);
        }
        HashMap<String, AccountInformation> accounts = new HashMap<String, AccountInformation>();
        try {
            while (true) {
                AccountInformation ai = new AccountInformation(is, charset);
                accounts.put(ai.getAccountName(), ai);
            }
        }
        catch (EOFException ai) {
            is.close();
            return new PasswordDatabase(revision, dbOptions, accounts, databaseFile);
        }
    }

    public void save(PasswordDatabase database) throws IOException, CryptoException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        database.getRevisionObj().increment();
        database.getRevisionObj().flatPack(os);
        database.getDbOptions().flatPack(os);
        for (AccountInformation ai : database.getAccountsHash().values()) {
            ai.flatPack(os);
        }
        os.close();
        byte[] dataToEncrypt = os.toByteArray();
        byte[] encryptedData = this.encryptionService.encrypt(dataToEncrypt);
        FileOutputStream fos = new FileOutputStream(database.getDatabaseFile());
        fos.write(FILE_HEADER.getBytes());
        fos.write(3);
        fos.write(this.encryptionService.getSalt());
        fos.write(encryptedData);
        fos.close();
    }

    public EncryptionService getEncryptionService() {
        return this.encryptionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        FileInputStream is;
        try {
            is = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new IOException("There was a problem with opening the file", e);
        }
        byte[] bytes = new byte[(int)file.length()];
        int numRead = 0;
        try {
            int offset;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }
}

