/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.gui;

import com._17od.upm.database.AccountInformation;
import com._17od.upm.gui.EscapeDialog;
import com._17od.upm.util.Preferences;
import com._17od.upm.util.Translator;
import com._17od.upm.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.validator.routines.UrlValidator;

public class AccountDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final char[] ALLOWED_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] EXTRA_ALLOWED_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ',', ')', '_', '-', '+', '=', '|', '/', '<', '>', '.', '?', ';', ':'};
    private static final char[] UPPERCASE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] LOWERCASE_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] NUMBER_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] PUNCTUATION_CHARS = new char[]{'~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ',', ')', '_', '-', '+', '=', '|', '/', '<', '>', '.', '?', ';', ':'};
    private AccountInformation pAccount;
    private JTextField userId;
    private JPasswordField password;
    private JTextArea notes;
    private JTextField url;
    private JTextField accountName;
    private boolean okClicked = false;
    private ArrayList existingAccounts;
    private JFrame parentWindow;
    private boolean accountChanged = false;
    private char defaultEchoChar;

    public AccountDialog(AccountInformation account, JFrame parentWindow, boolean readOnly, ArrayList existingAccounts) {
        super(parentWindow, true);
        boolean addingAccount = false;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    AccountDialog.this.requestFocus();
                }
            }
        });
        String title = null;
        if (readOnly) {
            title = Translator.translate("viewAccount");
        } else if (!readOnly && account.getAccountName().trim().equals("")) {
            title = Translator.translate("addAccount");
            addingAccount = true;
        } else {
            title = Translator.translate("editAccount");
        }
        this.setTitle(title);
        this.pAccount = account;
        this.existingAccounts = existingAccounts;
        this.parentWindow = parentWindow;
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Container container = this.getContentPane();
        JLabel accountLabel = new JLabel(Translator.translate("account"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        container.add((Component)accountLabel, c);
        JPanel accountPanel = new JPanel(new GridBagLayout());
        this.accountName = new JTextField(new String(this.pAccount.getAccountName()), 20);
        if (readOnly) {
            this.accountName.setEditable(false);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        accountPanel.add((Component)this.accountName, c);
        this.accountName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AccountDialog.this.accountName.selectAll();
            }
        });
        JButton acctCopyButton = new JButton();
        acctCopyButton.setIcon(Util.loadImage("copy-icon.png"));
        acctCopyButton.setToolTipText("Copy");
        acctCopyButton.setEnabled(true);
        acctCopyButton.setMargin(new Insets(0, 0, 0, 0));
        acctCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.copyTextField(AccountDialog.this.accountName);
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        accountPanel.add((Component)acctCopyButton, c);
        JButton acctPasteButton = new JButton();
        acctPasteButton.setIcon(Util.loadImage("paste-icon.png"));
        acctPasteButton.setToolTipText("Paste");
        acctPasteButton.setEnabled(!readOnly);
        acctPasteButton.setMargin(new Insets(0, 0, 0, 0));
        acctPasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.pasteToTextField(AccountDialog.this.accountName);
            }
        });
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        accountPanel.add((Component)acctPasteButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        container.add((Component)accountPanel, c);
        JLabel useridLabel = new JLabel(Translator.translate("userid"));
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        container.add((Component)useridLabel, c);
        JPanel idPanel = new JPanel(new GridBagLayout());
        this.userId = new JTextField(new String(this.pAccount.getUserId()), 20);
        if (readOnly) {
            this.userId.setEditable(false);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        idPanel.add((Component)this.userId, c);
        this.userId.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AccountDialog.this.userId.selectAll();
            }
        });
        JButton idCopyButton = new JButton();
        idCopyButton.setIcon(Util.loadImage("copy-icon.png"));
        idCopyButton.setToolTipText("Copy");
        idCopyButton.setEnabled(true);
        idCopyButton.setMargin(new Insets(0, 0, 0, 0));
        idCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.copyTextField(AccountDialog.this.userId);
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        idPanel.add((Component)idCopyButton, c);
        JButton idPasteButton = new JButton();
        idPasteButton.setIcon(Util.loadImage("paste-icon.png"));
        idPasteButton.setToolTipText("Paste");
        idPasteButton.setEnabled(!readOnly);
        idPasteButton.setMargin(new Insets(0, 0, 0, 0));
        idPasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.pasteToTextField(AccountDialog.this.userId);
            }
        });
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        idPanel.add((Component)idPasteButton, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        container.add((Component)idPanel, c);
        JLabel passwordLabel = new JLabel(Translator.translate("password"));
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 23;
        c.insets = new Insets(15, 10, 10, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        container.add((Component)passwordLabel, c);
        JPanel passwordPanel = new JPanel(new GridBagLayout());
        this.password = new JPasswordField(new String(this.pAccount.getPassword()), 20);
        this.password.putClientProperty("JPasswordField.cutCopyAllowed", Boolean.TRUE);
        this.password.setEditable(!readOnly);
        this.password.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AccountDialog.this.password.selectAll();
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        passwordPanel.add((Component)this.password, c);
        JButton generateRandomPasswordButton = new JButton(Translator.translate("generate"));
        if (readOnly) {
            generateRandomPasswordButton.setEnabled(false);
        }
        generateRandomPasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                String Password;
                Boolean includeEscapeChars = new Boolean(Preferences.get("account.inclescapechars", "true"));
                int pwLength = Preferences.getInt("account.passwordLenght", 8);
                if (includeEscapeChars.booleanValue() && pwLength > 3) {
                    while (!AccountDialog.CheckPassStrong(Password = AccountDialog.GeneratePassword(pwLength, includeEscapeChars), includeEscapeChars)) {
                    }
                } else if (!includeEscapeChars.booleanValue() && pwLength > 2) {
                    while (!AccountDialog.CheckPassStrong(Password = AccountDialog.GeneratePassword(pwLength, includeEscapeChars), includeEscapeChars)) {
                    }
                } else {
                    Password = AccountDialog.GeneratePassword(pwLength, includeEscapeChars);
                }
                AccountDialog.this.password.setText(Password);
            }
        });
        if (addingAccount) {
            generateRandomPasswordButton.doClick();
        }
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        passwordPanel.add((Component)generateRandomPasswordButton, c);
        JButton pwCopyButton = new JButton();
        pwCopyButton.setIcon(Util.loadImage("copy-icon.png"));
        pwCopyButton.setToolTipText("Copy");
        pwCopyButton.setEnabled(true);
        pwCopyButton.setMargin(new Insets(0, 0, 0, 0));
        pwCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.copyTextField(AccountDialog.this.password);
            }
        });
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        passwordPanel.add((Component)pwCopyButton, c);
        JButton pwPasteButton = new JButton();
        pwPasteButton.setIcon(Util.loadImage("paste-icon.png"));
        pwPasteButton.setToolTipText("Paste");
        pwPasteButton.setEnabled(!readOnly);
        pwPasteButton.setMargin(new Insets(0, 0, 0, 0));
        pwPasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.pasteToTextField(AccountDialog.this.password);
            }
        });
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        passwordPanel.add((Component)pwPasteButton, c);
        JCheckBox hidePasswordCheckbox = new JCheckBox(Translator.translate("hide"), true);
        this.defaultEchoChar = this.password.getEchoChar();
        hidePasswordCheckbox.setMargin(new Insets(5, 0, 5, 0));
        hidePasswordCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AccountDialog.this.password.setEchoChar(AccountDialog.this.defaultEchoChar);
                } else {
                    AccountDialog.this.password.setEchoChar('\u0000');
                }
            }
        });
        Boolean hideAccountPassword = new Boolean(Preferences.get("account.hidePassword", "true"));
        hidePasswordCheckbox.setSelected(hideAccountPassword);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        passwordPanel.add((Component)hidePasswordCheckbox, c);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        container.add((Component)passwordPanel, c);
        JLabel urlLabel = new JLabel(Translator.translate("url"));
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        container.add((Component)urlLabel, c);
        JPanel urlPanel = new JPanel(new GridBagLayout());
        this.url = new JTextField(new String(this.pAccount.getUrl()), 20);
        if (readOnly) {
            this.url.setEditable(false);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        urlPanel.add((Component)this.url, c);
        this.url.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AccountDialog.this.url.selectAll();
            }
        });
        final JButton urlLaunchButton = new JButton();
        urlLaunchButton.setIcon(Util.loadImage("launch-url-sm.png"));
        urlLaunchButton.setToolTipText("Launch URL");
        urlLaunchButton.setEnabled(true);
        urlLaunchButton.setMargin(new Insets(0, 0, 0, 0));
        urlLaunchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String urlText = AccountDialog.this.url.getText();
                if (urlText == null || urlText.length() == 0) {
                    JOptionPane.showMessageDialog(urlLaunchButton.getParent(), Translator.translate("EmptyUrlJoptionpaneMsg"), Translator.translate("UrlErrorJoptionpaneTitle"), 2);
                } else if (!AccountDialog.this.urlIsValid(urlText)) {
                    JOptionPane.showMessageDialog(urlLaunchButton.getParent(), Translator.translate("InvalidUrlJoptionpaneMsg"), Translator.translate("UrlErrorJoptionpaneTitle"), 2);
                } else {
                    AccountDialog.this.LaunchSelectedURL(urlText);
                }
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        urlPanel.add((Component)urlLaunchButton, c);
        JButton urlCopyButton = new JButton();
        urlCopyButton.setIcon(Util.loadImage("copy-icon.png"));
        urlCopyButton.setToolTipText("Copy");
        urlCopyButton.setEnabled(true);
        urlCopyButton.setMargin(new Insets(0, 0, 0, 0));
        urlCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.copyTextField(AccountDialog.this.url);
            }
        });
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        urlPanel.add((Component)urlCopyButton, c);
        JButton urlPasteButton = new JButton();
        urlPasteButton.setIcon(Util.loadImage("paste-icon.png"));
        urlPasteButton.setToolTipText("Paste");
        urlPasteButton.setEnabled(!readOnly);
        urlPasteButton.setMargin(new Insets(0, 0, 0, 0));
        urlPasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.pasteToTextField(AccountDialog.this.url);
            }
        });
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        urlPanel.add((Component)urlPasteButton, c);
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        container.add((Component)urlPanel, c);
        JLabel notesLabel = new JLabel(Translator.translate("notes"));
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        container.add((Component)notesLabel, c);
        JPanel notesPanel = new JPanel(new GridBagLayout());
        this.notes = new JTextArea(new String(this.pAccount.getNotes()), 10, 20);
        if (readOnly) {
            this.notes.setEditable(false);
        }
        this.notes.setLineWrap(true);
        this.notes.setWrapStyleWord(true);
        JScrollPane notesScrollPane = new JScrollPane(this.notes);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 1;
        notesPanel.add((Component)notesScrollPane, c);
        JButton notesCopyButton = new JButton();
        notesCopyButton.setIcon(Util.loadImage("copy-icon.png"));
        notesCopyButton.setToolTipText("Copy");
        notesCopyButton.setEnabled(true);
        notesCopyButton.setMargin(new Insets(0, 0, 0, 0));
        notesCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.copyTextArea(AccountDialog.this.notes);
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        notesPanel.add((Component)notesCopyButton, c);
        JButton notesPasteButton = new JButton();
        notesPasteButton.setIcon(Util.loadImage("paste-icon.png"));
        notesPasteButton.setToolTipText("Paste");
        notesPasteButton.setEnabled(!readOnly);
        notesPasteButton.setMargin(new Insets(0, 0, 0, 0));
        notesPasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountDialog.this.pasteToTextArea(AccountDialog.this.notes);
            }
        });
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        notesPanel.add((Component)notesPasteButton, c);
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        container.add((Component)notesPanel, c);
        JSeparator sep = new JSeparator();
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 20;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        container.add((Component)sep, c);
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(Translator.translate("ok"));
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDialog.this.okButtonAction();
            }
        });
        buttonPanel.add(okButton);
        if (!readOnly) {
            JButton cancelButton = new JButton(Translator.translate("cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccountDialog.this.closeButtonAction();
                }
            });
            buttonPanel.add(cancelButton);
        }
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 20;
        c.insets = new Insets(5, 0, 5, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 0;
        container.add((Component)buttonPanel, c);
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public AccountInformation getAccount() {
        return this.pAccount;
    }

    private void okButtonAction() {
        if (!this.pAccount.getAccountName().equals(this.accountName.getText().trim())) {
            this.accountChanged = true;
        }
        if (this.accountChanged && this.existingAccounts.indexOf(this.accountName.getText().trim()) > -1) {
            JOptionPane.showMessageDialog(this.parentWindow, Translator.translate("accountAlreadyExistsWithName", this.accountName.getText().trim()), Translator.translate("accountAlreadyExists"), 0);
        } else {
            if (!this.pAccount.getUserId().equals(this.userId.getText())) {
                this.accountChanged = true;
            }
            if (!this.pAccount.getPassword().equals(this.password.getText())) {
                this.accountChanged = true;
            }
            if (!this.pAccount.getUrl().equals(this.url.getText())) {
                this.accountChanged = true;
            }
            if (!this.pAccount.getNotes().equals(this.notes.getText())) {
                this.accountChanged = true;
            }
            this.pAccount.setAccountName(this.accountName.getText().trim());
            this.pAccount.setUserId(this.userId.getText());
            this.pAccount.setPassword(this.password.getText());
            this.pAccount.setUrl(this.url.getText());
            this.pAccount.setNotes(this.notes.getText());
            this.setVisible(false);
            this.dispose();
            this.okClicked = true;
        }
    }

    public boolean getAccountChanged() {
        return this.accountChanged;
    }

    private void closeButtonAction() {
        this.okClicked = false;
        this.setVisible(false);
        this.dispose();
    }

    private static String GeneratePassword(int PassLength, boolean InclEscChars) {
        SecureRandom random = new SecureRandom();
        StringBuffer passwordBuffer = new StringBuffer();
        if (InclEscChars) {
            for (int i = 0; i < PassLength; ++i) {
                passwordBuffer.append(EXTRA_ALLOWED_CHARS[random.nextInt(EXTRA_ALLOWED_CHARS.length)]);
            }
            return passwordBuffer.toString();
        }
        for (int i = 0; i < PassLength; ++i) {
            passwordBuffer.append(ALLOWED_CHARS[random.nextInt(ALLOWED_CHARS.length)]);
        }
        return passwordBuffer.toString();
    }

    private static boolean CheckPassStrong(String Pass, boolean InclEscChars) {
        if (InclEscChars) {
            return AccountDialog.InclUpperCase(Pass) && AccountDialog.InclLowerCase(Pass) && AccountDialog.InclNumber(Pass) && AccountDialog.InclEscape(Pass);
        }
        return AccountDialog.InclUpperCase(Pass) && AccountDialog.InclLowerCase(Pass) && AccountDialog.InclNumber(Pass);
    }

    private static boolean InclUpperCase(String GeneratedPass) {
        char[] PassWordArray = GeneratedPass.toCharArray();
        boolean find = false;
        block0: for (int i = 0; i < PassWordArray.length; ++i) {
            for (int j = 0; j < UPPERCASE_CHARS.length; ++j) {
                if (PassWordArray[i] != UPPERCASE_CHARS[j]) continue;
                find = true;
                break block0;
            }
        }
        return find;
    }

    private static boolean InclLowerCase(String GeneratedPass) {
        char[] PassWordArray = GeneratedPass.toCharArray();
        boolean find = false;
        block0: for (int i = 0; i < PassWordArray.length; ++i) {
            for (int j = 0; j < LOWERCASE_CHARS.length; ++j) {
                if (PassWordArray[i] != LOWERCASE_CHARS[j]) continue;
                find = true;
                break block0;
            }
        }
        return find;
    }

    private static boolean InclNumber(String GeneratedPass) {
        char[] PassWordArray = GeneratedPass.toCharArray();
        boolean find = false;
        block0: for (int i = 0; i < PassWordArray.length; ++i) {
            for (int j = 0; j < NUMBER_CHARS.length; ++j) {
                if (PassWordArray[i] != NUMBER_CHARS[j]) continue;
                find = true;
                break block0;
            }
        }
        return find;
    }

    private static boolean InclEscape(String GeneratedPass) {
        char[] PassWordArray = GeneratedPass.toCharArray();
        boolean find = false;
        block0: for (int i = 0; i < PassWordArray.length; ++i) {
            for (int j = 0; j < PUNCTUATION_CHARS.length; ++j) {
                if (PassWordArray[i] != PUNCTUATION_CHARS[j]) continue;
                find = true;
                break block0;
            }
        }
        return find;
    }

    public void copyTextField(JTextField textField) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selected = new StringSelection(textField.getText());
        clipboard.setContents(selected, selected);
    }

    public void copyTextArea(JTextArea textArea) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selected = new StringSelection(textArea.getSelectedText());
        clipboard.setContents(selected, selected);
    }

    public void pasteToTextField(JTextField textField) {
        String text = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipText = clipboard.getContents(null);
        if (clipText != null && clipText.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                text = (String)clipText.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        textField.setText(text);
    }

    public void pasteToTextArea(JTextArea textArea) {
        String text = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipText = clipboard.getContents(null);
        if (clipText != null && clipText.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                text = (String)clipText.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        textArea.insert(text, textArea.getCaretPosition());
        textArea.requestFocus();
    }

    private boolean urlIsValid(String urL) {
        UrlValidator urlValidator = new UrlValidator();
        return urlValidator.isValid(urL);
    }

    private void LaunchSelectedURL(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

