/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.util;

import com._17od.upm.util.Preferences;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Translator {
    public static Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN, new Locale("es"), new Locale("nl"), new Locale("pl"), new Locale("el"), new Locale("cs")};
    private static ResourceBundle resourceBundle;
    private static MessageFormat formatter;

    public static String translate(String messageName, Object[] params) {
        formatter.applyPattern(resourceBundle.getString(messageName));
        return formatter.format(params);
    }

    public static String translate(String messageName, Object param) {
        formatter.applyPattern(resourceBundle.getString(messageName));
        return formatter.format(new Object[]{param});
    }

    public static String translate(String messageName) {
        return resourceBundle.getString(messageName);
    }

    public static Locale getCurrentLocale() {
        return resourceBundle.getLocale();
    }

    public static void initialise() {
        Locale locale = new Locale("en");
        String localePreference = Preferences.get("locale");
        if (localePreference != null) {
            locale = new Locale(localePreference);
        }
        Translator.loadBundle(locale);
    }

    public static void loadBundle(Locale locale) {
        resourceBundle = ResourceBundle.getBundle("upm", locale);
        formatter = new MessageFormat("");
        formatter.setLocale(locale);
    }
}

