/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileManagerPanel
extends JPanel
implements TreeSelectionListener,
ListSelectionListener,
PropertiesStickListener {
    JSplitPane splitPanel;
    JTree dirTree;
    JTable listTable;
    JScrollPane scrollTree;
    JScrollPane scrollTable;
    HDataTableModel tableModelOrg;
    HDataTreeModel treeModel;
    TableSorter tableModel;
    JLabel statusLabel;
    JLabel unregLabel;
    Box statusLine;
    Vector stickyPropertiesDialogs = new Vector(5);
    JFrame mainFrame;
    HDatabase database;
    static Icon containerIcon = new FolderIcon("c");
    static Icon volumeIcon = new FolderIcon("v");
    static Icon directoryIcon = UIManager.getIcon("Tree.closedIcon");
    static Icon zipIcon = new FolderIcon("z");
    static /* synthetic */ Class class$java$util$Date;

    FileManagerPanel(JFrame jFrame, HDatabase hDatabase) {
        this.mainFrame = jFrame;
        this.database = hDatabase;
        this.treeModel = new HDataTreeModel(new DynamicTreeNode((Object)hDatabase.rootNode, hDatabase));
        this.dirTree = new JTree(this.treeModel);
        this.dirTree.addTreeSelectionListener(this);
        this.dirTree.setCellRenderer(new TreeFolderRenderer());
        this.tableModelOrg = new HDataTableModel(0, this.dirTree, hDatabase);
        this.tableModel = new TableSorter(this.tableModelOrg);
        this.listTable = new JTable(this.tableModel);
        this.tableModel.addMouseListenerToHeaderInTable(this.listTable);
        this.listTable.setShowVerticalLines(false);
        this.listTable.setShowHorizontalLines(false);
        this.listTable.getSelectionModel().addListSelectionListener(this);
        int n = 0;
        while (n < 4) {
            TableColumn tableColumn = this.listTable.getColumnModel().getColumn(n);
            switch (n) {
                case 0: {
                    tableColumn.setPreferredWidth(UIManager.getIcon("Tree.closedIcon").getIconWidth() + 15);
                    tableColumn.setMaxWidth(tableColumn.getPreferredWidth());
                    break;
                }
                case 1: {
                    tableColumn.setPreferredWidth(150);
                    break;
                }
                case 2: {
                    tableColumn.setPreferredWidth(75);
                    break;
                }
                case 3: {
                    tableColumn.setPreferredWidth(100);
                    break;
                }
            }
            ++n;
        }
        this.listTable.setDefaultRenderer(class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = FileManagerPanel.class$("java.util.Date")), new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setHorizontalAlignment(0);
                return super.getTableCellRendererComponent(jTable, DateFormat.getInstance().format((Date)object), bl, bl2, n, n2);
            }
        });
        this.scrollTree = new JScrollPane(this.dirTree);
        this.scrollTree.getViewport().setBackingStoreEnabled(true);
        this.scrollTree.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.scrollTable = new JScrollPane(this.listTable);
        this.scrollTable.getViewport().setBackingStoreEnabled(true);
        this.scrollTable.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.splitPanel = new JSplitPane();
        this.splitPanel.add((Component)this.scrollTree, "left");
        this.splitPanel.add((Component)this.scrollTable, "right");
        this.statusLabel = new JLabel("Nothing yet");
        this.unregLabel = new JLabel("");
        this.unregLabel.setForeground(Color.red);
        this.unregLabel.setAlignmentX(1.0f);
        this.statusLine = Box.createHorizontalBox();
        this.statusLine.add(this.statusLabel);
        this.statusLine.add(Box.createGlue());
        this.statusLine.add(this.unregLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPanel, "Center");
        this.add((Component)this.statusLine, "South");
        this.dirTree.expandPath(new TreePath(this.treeModel.getRoot()));
        this.dirTree.addSelectionRow(0);
    }

    public DynamicTreeNode addNewNode(DynamicTreeNode dynamicTreeNode, HDataNode hDataNode) {
        DynamicTreeNode dynamicTreeNode2 = new DynamicTreeNode((Object)hDataNode, this.database);
        this.treeModel.insertNodeInto(dynamicTreeNode2, dynamicTreeNode, dynamicTreeNode.getChildCount());
        this.treeModel.sortChildren(dynamicTreeNode);
        this.dirTree.setSelectionPath(new TreePath(this.treeModel.getPathToRoot(dynamicTreeNode2)));
        return dynamicTreeNode2;
    }

    public void addStickDialog(PropertiesDialog propertiesDialog) {
        this.stickyPropertiesDialogs.addElement(propertiesDialog);
    }

    public void addTableKeyListener(KeyListener keyListener) {
        this.listTable.addKeyListener(keyListener);
    }

    public void addTableMouseListener(MouseListener mouseListener) {
        this.listTable.addMouseListener(mouseListener);
    }

    public void addTreeMouseListener(MouseListener mouseListener) {
        this.dirTree.addMouseListener(mouseListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void deleteTableNodes(HDataNode[] hDataNodeArray) {
        int n = 0;
        while (n < hDataNodeArray.length) {
            this.tableModel.removeNode(hDataNodeArray[n]);
            ++n;
        }
        this.tableModel.sort();
    }

    public void deleteTreeNode(DynamicTreeNode dynamicTreeNode) {
        TreePath treePath = this.tableModel.getPathToTable();
        DynamicTreeNode dynamicTreeNode2 = (DynamicTreeNode)treePath.getLastPathComponent();
        TreePath treePath2 = null;
        if (dynamicTreeNode2.isNodeAncestor(dynamicTreeNode)) {
            treePath2 = new TreePath(this.treeModel.getPathToRoot(dynamicTreeNode.getParent()));
        }
        if (dynamicTreeNode2.isNodeChild(dynamicTreeNode)) {
            treePath2 = treePath;
        }
        this.treeModel.removeNodeFromParent(dynamicTreeNode);
        if (treePath2 != null) {
            this.dirTree.clearSelection();
            this.dirTree.setSelectionPath(treePath2);
        }
    }

    public static Icon getAssocIcon(int n) {
        switch (n) {
            case 99: {
                return containerIcon;
            }
            case 118: {
                return volumeIcon;
            }
            case 100: {
                return directoryIcon;
            }
            case 122: {
                return zipIcon;
            }
        }
        return UIManager.getIcon("Tree.closedIcon");
    }

    public DynamicTreeNode getFirstOfType(int n) {
        TreePath treePath = this.dirTree.getLeadSelectionPath();
        DynamicTreeNode dynamicTreeNode = null;
        HDataNode hDataNode = null;
        if (n == -1) {
            return (DynamicTreeNode)treePath.getLastPathComponent();
        }
        int n2 = treePath.getPathCount() - 1;
        while (n2 >= 0) {
            dynamicTreeNode = (DynamicTreeNode)treePath.getPathComponent(n2);
            hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
            if (hDataNode.type == n) break;
            --n2;
        }
        return dynamicTreeNode;
    }

    public boolean hasAncestorOfType(DynamicTreeNode dynamicTreeNode, byte by) {
        TreeNode[] treeNodeArray = this.treeModel.getPathToRoot(dynamicTreeNode);
        int n = 0;
        while (n < treeNodeArray.length) {
            HDataNode hDataNode = (HDataNode)((DynamicTreeNode)treeNodeArray[n]).getUserObject();
            if (hDataNode.type == by) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeStickDialog(PropertiesDialog propertiesDialog) {
        this.stickyPropertiesDialogs.removeElement(propertiesDialog);
    }

    public void replaceNode(HDataNode hDataNode, HDataNode hDataNode2, TreePath treePath) {
        DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)treePath.getLastPathComponent();
        int n = dynamicTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DynamicTreeNode dynamicTreeNode2 = (DynamicTreeNode)dynamicTreeNode.getChildAt(n2);
            HDataNode hDataNode3 = (HDataNode)dynamicTreeNode2.getUserObject();
            if (hDataNode3.equals(hDataNode)) {
                dynamicTreeNode2.setUserObject(hDataNode2);
                this.treeModel.sortChildren(dynamicTreeNode);
                this.treeModel.nodeChanged(dynamicTreeNode2);
            } else if (hDataNode3.index > hDataNode.index) {
                --hDataNode3.index;
            }
            ++n2;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.stickyPropertiesDialogs.isEmpty()) {
            HDataNode[] hDataNodeArray = this.tableModel.getNodes(this.listTable.getSelectedRows());
            int n = 0;
            while (n < hDataNodeArray.length && n < this.stickyPropertiesDialogs.size()) {
                ((PropertiesDialog)this.stickyPropertiesDialogs.elementAt(n)).loadNode(hDataNodeArray[n], this.tableModel.getPathToTable());
                ++n;
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        Object object;
        if (!this.stickyPropertiesDialogs.isEmpty()) {
            object = this.dirTree.getSelectionPaths();
            n = 0;
            while (n < ((TreePath[])object).length && n < this.stickyPropertiesDialogs.size()) {
                ((PropertiesDialog)this.stickyPropertiesDialogs.elementAt(n)).loadNode((HDataNode)((DynamicTreeNode)object[n].getLastPathComponent()).getUserObject(), object[n].getParentPath());
                ++n;
            }
        }
        if ((object = (DynamicTreeNode)this.dirTree.getLastSelectedPathComponent()) == null) {
            return;
        }
        try {
            this.tableModel.loadTable((DynamicTreeNode)object);
            n = 0;
            int n2 = 0;
            while (n2 < this.tableModel.getRowCount()) {
                HDataNode hDataNode = this.tableModel.getNode(n2);
                n = (int)((long)n + hDataNode.length);
                ++n2;
            }
            this.statusLabel.setText(String.valueOf(this.tableModel.getRowCount()) + " Files   " + object + "   Total Size " + NumberFormat.getInstance().format(n));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.mainFrame, "Database corrupted, could not load nodes in table.", "Error", 0);
        }
    }

    public static class FolderIcon
    implements Icon {
        Icon orgFolderIcon = UIManager.getIcon("Tree.closedIcon");
        String character;

        public FolderIcon(String string) {
            this.character = string;
        }

        public int getIconHeight() {
            return this.orgFolderIcon.getIconHeight();
        }

        public int getIconWidth() {
            return this.orgFolderIcon.getIconWidth();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.orgFolderIcon.paintIcon(component, graphics, n, n2);
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("Label.foreground"));
            graphics.setFont(UIManager.getFont("Label.font"));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.character, n + this.getIconWidth() / 2 - fontMetrics.stringWidth(this.character) / 2 - 2, n2 + 3 * this.getIconHeight() / 4 - 1);
            graphics.setColor(color);
            graphics.setFont(font);
        }
    }

    public class TreeFolderRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            HDataNode hDataNode = (HDataNode)((DynamicTreeNode)object).getUserObject();
            this.setIcon(FileManagerPanel.getAssocIcon(hDataNode.type));
            return this;
        }
    }
}

