/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class SearchDialog
extends JFrame
implements ActionListener,
Runnable,
ListSelectionListener,
PropertiesStickListener,
PropertiesChangeListener {
    JLabel message = new JLabel("Enter Wildcard Search String:");
    JTextField searchField;
    JCheckBox statusButton = new JCheckBox("Real Time Status");
    JButton searchButton = new JButton("Search");
    JButton stopButton = new JButton("Stop");
    JPanel buttonPane = new JPanel();
    JLabel status = new JLabel(" ");
    HDataTableModel tableModelOrg;
    TableSorter tableModel;
    JTable foundTable;
    JScrollPane scrollFoundTable;
    TreePath aTreePath;
    String path;
    Thread searchThread = null;
    HDatabase database;
    JFrame mainFrame;
    Properties options;
    FileManagerPanel fileManagerPanel;
    JPopupMenu popMenu;
    MyJMenuItem openPop;
    MyJMenuItem proPop;
    MyJMenuItem lookupPop;
    Vector nodesForAction = new Vector(10);
    Vector stickyPropertiesDialogs = new Vector(5);
    UpdateStatus updateStatus = new UpdateStatus();
    AddNodes addNodes = new AddNodes();
    TreePath prevTreePath = null;
    static /* synthetic */ Class class$java$util$Date;

    public SearchDialog(JFrame jFrame, TreePath treePath, HDatabase hDatabase, Properties properties, FileManagerPanel fileManagerPanel) {
        Serializable serializable;
        this.database = hDatabase;
        this.aTreePath = treePath;
        this.mainFrame = jFrame;
        this.options = properties;
        this.fileManagerPanel = fileManagerPanel;
        this.path = new String();
        int n = 0;
        while (n < treePath.getPathCount()) {
            this.path = String.valueOf(this.path) + "/" + treePath.getPathComponent(n);
            ++n;
        }
        this.setTitle("Searching in " + this.path);
        this.tableModelOrg = new HDataTableModel(1, null, hDatabase);
        this.tableModel = new TableSorter(this.tableModelOrg);
        this.foundTable = new JTable(this.tableModel);
        this.foundTable.getSelectionModel().addListSelectionListener(this);
        this.tableModel.addMouseListenerToHeaderInTable(this.foundTable);
        this.scrollFoundTable = new JScrollPane(this.foundTable);
        this.message.setAlignmentX(0.0f);
        this.foundTable.setShowVerticalLines(false);
        this.foundTable.setShowHorizontalLines(false);
        this.scrollFoundTable.getViewport().setBackingStoreEnabled(true);
        this.scrollFoundTable.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        int n2 = 0;
        int n3 = 0;
        while (n3 < 5) {
            serializable = this.foundTable.getColumnModel().getColumn(n3);
            switch (n3) {
                case 0: {
                    ((TableColumn)serializable).setPreferredWidth(UIManager.getIcon("Tree.closedIcon").getIconWidth() + 15);
                    ((TableColumn)serializable).setMaxWidth(((TableColumn)serializable).getPreferredWidth());
                    n2 += ((TableColumn)serializable).getPreferredWidth();
                    break;
                }
                case 1: {
                    ((TableColumn)serializable).setPreferredWidth(125);
                    n2 += 150;
                    break;
                }
                case 2: {
                    ((TableColumn)serializable).setPreferredWidth(175);
                    n2 += 150;
                    break;
                }
                case 3: {
                    ((TableColumn)serializable).setPreferredWidth(75);
                    n2 += 75;
                    break;
                }
                case 4: {
                    ((TableColumn)serializable).setPreferredWidth(100);
                    n2 += 100;
                    break;
                }
            }
            ++n3;
        }
        this.foundTable.setPreferredScrollableViewportSize(new Dimension(n2, 3 * n2 / 4));
        this.foundTable.revalidate();
        this.foundTable.setDefaultRenderer(class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = SearchDialog.class$("java.util.Date")), new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setHorizontalAlignment(0);
                return super.getTableCellRendererComponent(jTable, DateFormat.getInstance().format((Date)object), bl, bl2, n, n2);
            }
        });
        this.foundTable.addMouseListener(new TableMouseListener());
        this.foundTable.addKeyListener(new TableKeyListener());
        this.searchField = new JTextField(properties.getProperty("search.pattern"));
        this.searchField.setMaximumSize(new Dimension(Short.MAX_VALUE, this.searchField.getPreferredSize().height + 5));
        this.searchField.setAlignmentX(0.0f);
        this.searchButton.setAlignmentX(0.0f);
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.buttonPane.add(this.searchField);
        this.buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPane.add(this.searchButton);
        this.buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPane.add(this.stopButton);
        this.buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPane.add(this.statusButton);
        this.buttonPane.setAlignmentX(0.0f);
        this.searchButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.statusButton.setSelected(Boolean.valueOf(properties.getProperty("search.realTimeStatus")));
        this.searchButton.setMnemonic(83);
        this.statusButton.setMnemonic(82);
        this.stopButton.setMnemonic(84);
        this.stopButton.setEnabled(false);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        ((Container)serializable).add(this.message);
        ((Container)serializable).add(Box.createRigidArea(new Dimension(0, 5)));
        ((Container)serializable).add(this.buttonPane);
        ((Container)serializable).add(Box.createRigidArea(new Dimension(0, 5)));
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)serializable, "North");
        this.getContentPane().add((Component)this.scrollFoundTable, "Center");
        this.getContentPane().add((Component)this.status, "South");
        this.addWindowListener(new WindowAdapter(){
            boolean focusSet = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.focusSet) {
                    SearchDialog.this.searchField.requestFocus();
                }
                this.focusSet = true;
            }

            public void windowClosing(WindowEvent windowEvent) {
                ((Hashtable)SearchDialog.this.options).put("search.x", String.valueOf(SearchDialog.this.getLocation().x));
                ((Hashtable)SearchDialog.this.options).put("search.y", String.valueOf(SearchDialog.this.getLocation().y));
                ((Hashtable)SearchDialog.this.options).put("search.width", String.valueOf(SearchDialog.this.getSize().width));
                ((Hashtable)SearchDialog.this.options).put("search.height", String.valueOf(SearchDialog.this.getSize().height));
                ((Hashtable)SearchDialog.this.options).put("search.pattern", SearchDialog.this.searchField.getText());
                ((Hashtable)SearchDialog.this.options).put("search.realTimeStatus", String.valueOf(SearchDialog.this.statusButton.isSelected()));
                DiskIndexer.saveProperties();
                SearchDialog.this.mainFrame.requestFocus();
            }
        });
        this.searchField.setRequestFocusEnabled(true);
        this.searchField.requestFocus();
        this.searchField.grabFocus();
        this.pack();
        String string = properties.getProperty("search.width");
        String string2 = properties.getProperty("search.height");
        if (string != null && string2 != null) {
            ((Component)this).setSize(Integer.parseInt(string), Integer.parseInt(string2));
        }
        ((Component)this).setLocation(Integer.parseInt(properties.getProperty("search.x")), Integer.parseInt(properties.getProperty("search.y")));
        this.popMenu = new JPopupMenu();
        this.openPop = new MyJMenuItem("Open", 111);
        this.openPop.addActionListener(this);
        this.proPop = new MyJMenuItem("Properties", 112);
        this.proPop.addActionListener(this);
        this.lookupPop = new MyJMenuItem("Lookup", 108);
        this.lookupPop.addActionListener(this);
        this.popMenu.add(this.openPop);
        this.popMenu.add(this.proPop);
        this.popMenu.addSeparator();
        this.popMenu.add(this.lookupPop);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            String string;
            block10: {
                string = actionEvent.getActionCommand();
                if (string != "Search") break block10;
                this.searchButton.setEnabled(false);
                this.stopButton.setEnabled(true);
                if (this.searchThread != null) break block11;
                this.tableModel.clearTable();
                this.searchThread = new Thread((Runnable)this, "Searching");
                this.searchThread.start();
                break block11;
            }
            if (string == "Stop") {
                this.searchThread = null;
            } else if (string == "Open") {
                int n = 0;
                while (n < this.nodesForAction.size()) {
                    HDataNode hDataNode = (HDataNode)this.nodesForAction.elementAt(n);
                    DiskIndexer.executeAssoc(hDataNode, hDataNode.treePath, this);
                    ++n;
                }
            } else if (string == "Properties") {
                int n = 0;
                while (n < this.nodesForAction.size()) {
                    HDataNode hDataNode = (HDataNode)this.nodesForAction.elementAt(n);
                    PropertiesDialog.showDialog(this, hDataNode, hDataNode.treePath, this.database, this, this);
                    ++n;
                }
            } else if (string == "Lookup") {
                int n = 0;
                while (n < this.nodesForAction.size()) {
                    HDataNode hDataNode = (HDataNode)this.nodesForAction.elementAt(n);
                    this.lookup(hDataNode);
                    ++n;
                }
            }
        }
    }

    public void addStickDialog(PropertiesDialog propertiesDialog) {
        this.stickyPropertiesDialogs.addElement(propertiesDialog);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.tableModelOrg = null;
        this.tableModel = null;
        this.aTreePath = null;
        this.path = null;
        this.searchThread = null;
        this.database = null;
        this.nodesForAction = null;
        this.stickyPropertiesDialogs = null;
        super.finalize();
    }

    void lookup(HDataNode hDataNode) {
        Object[] objectArray = hDataNode.treePath.getPath();
        TreePath treePath = new TreePath(this.fileManagerPanel.treeModel.getRoot());
        if (treePath.getPathComponent(0) != null) {
            HDataNode hDataNode2;
            DynamicTreeNode dynamicTreeNode;
            Enumeration enumeration;
            DynamicTreeNode dynamicTreeNode2;
            boolean bl = true;
            int n = 1;
            while (n < objectArray.length && bl) {
                dynamicTreeNode2 = (DynamicTreeNode)treePath.getPathComponent(n - 1);
                enumeration = dynamicTreeNode2.children();
                bl = false;
                while (enumeration.hasMoreElements()) {
                    HDataNode hDataNode3;
                    dynamicTreeNode = (DynamicTreeNode)enumeration.nextElement();
                    hDataNode2 = (HDataNode)dynamicTreeNode.getUserObject();
                    if (!hDataNode2.equals(hDataNode3 = (HDataNode)((DynamicTreeNode)objectArray[n]).getUserObject())) continue;
                    treePath = treePath.pathByAddingChild(dynamicTreeNode);
                    bl = true;
                    break;
                }
                ++n;
            }
            bl = false;
            dynamicTreeNode2 = (DynamicTreeNode)treePath.getPathComponent(n - 1);
            enumeration = dynamicTreeNode2.children();
            while (enumeration.hasMoreElements()) {
                dynamicTreeNode = (DynamicTreeNode)enumeration.nextElement();
                hDataNode2 = (HDataNode)dynamicTreeNode.getUserObject();
                if (!hDataNode2.equals(hDataNode)) continue;
                treePath = treePath.pathByAddingChild(dynamicTreeNode);
                bl = true;
                break;
            }
            this.fileManagerPanel.dirTree.setSelectionPath(treePath);
            this.fileManagerPanel.dirTree.scrollPathToVisible(treePath);
            if (!bl) {
                int n2 = -1;
                this.fileManagerPanel.listTable.clearSelection();
                n = 0;
                while (n < this.fileManagerPanel.tableModel.getRowCount()) {
                    hDataNode2 = this.fileManagerPanel.tableModel.getNode(n);
                    if (hDataNode2.equals(hDataNode)) {
                        if (this.prevTreePath != null && !treePath.equals(this.prevTreePath)) {
                            this.fileManagerPanel.listTable.clearSelection();
                        }
                        this.fileManagerPanel.listTable.addRowSelectionInterval(n, n);
                        n2 = n;
                        break;
                    }
                    ++n;
                }
                if (n2 != -1) {
                    this.fileManagerPanel.listTable.scrollRectToVisible(this.fileManagerPanel.listTable.getCellRect(n, 0, false));
                }
            }
        }
        this.prevTreePath = treePath;
    }

    public void nodeChanged(HDataNode hDataNode, HDataNode hDataNode2, TreePath treePath) {
        if (hDataNode2 == hDataNode) {
            return;
        }
        try {
            this.database.update(hDataNode, hDataNode2);
            int n = this.tableModel.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                HDataNode hDataNode3 = this.tableModel.getNode(n2);
                if (hDataNode.treePath.equals(hDataNode3.treePath) && hDataNode.equals(hDataNode3)) {
                    this.tableModel.setNode(n2, hDataNode2);
                }
                hDataNode3 = null;
                ++n2;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Database corrupted, could not Update \"" + hDataNode + "\" node.", "Error", 0);
        }
    }

    public void removeStickDialog(PropertiesDialog propertiesDialog) {
        this.stickyPropertiesDialogs.removeElement(propertiesDialog);
    }

    public void run() {
        try {
            try {
                Thread thread = Thread.currentThread();
                this.updateStatus.path = "";
                SwingUtilities.invokeLater(this.updateStatus);
                this.searchFiles(this.aTreePath, "/", new FilenameMatch(this.searchField.getText()), thread);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Database corrupted", "Error", 0);
            }
            Object var2_2 = null;
            this.searchThread = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.searchThread = null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchDialog.this.searchButton.setEnabled(true);
                    SearchDialog.this.stopButton.setEnabled(false);
                    SearchDialog.this.status.setText("Found " + SearchDialog.this.tableModel.getRowCount() + " matches");
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    protected void searchFiles(TreePath treePath, String string, FilenameMatch filenameMatch, Thread thread) throws IOException {
        DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)treePath.getLastPathComponent();
        HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
        int n = this.database.childCount(hDataNode);
        if (this.statusButton.isSelected()) {
            this.updateStatus.path = string;
            SwingUtilities.invokeLater(this.updateStatus);
        }
        this.addNodes.nodes.setSize(0);
        this.addNodes.nodes.ensureCapacity(n);
        Vector<HDataNode> vector = new Vector<HDataNode>(10, 0);
        int n2 = 0;
        while (n2 < n && thread == this.searchThread) {
            HDataNode hDataNode2 = this.database.read(hDataNode, n2);
            if (filenameMatch.match(hDataNode2.fileName)) {
                hDataNode2.treePath = treePath;
                hDataNode2.path = string;
                this.addNodes.nodes.addElement(hDataNode2);
            }
            if (hDataNode2.childPointer > 0) {
                vector.addElement(hDataNode2);
            }
            ++n2;
        }
        try {
            if (!this.addNodes.nodes.isEmpty()) {
                SwingUtilities.invokeAndWait(this.addNodes);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        int n3 = 0;
        while (n3 < vector.size() && thread == this.searchThread) {
            HDataNode hDataNode3 = (HDataNode)vector.elementAt(n3);
            String string2 = string.endsWith("/") ? String.valueOf(string) + hDataNode3 : String.valueOf(string) + "/" + hDataNode3;
            DynamicTreeNode dynamicTreeNode2 = new DynamicTreeNode((Object)hDataNode3, this.database);
            this.searchFiles(treePath.pathByAddingChild(dynamicTreeNode2), string2, filenameMatch, thread);
            ++n3;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.stickyPropertiesDialogs.isEmpty()) {
            HDataNode[] hDataNodeArray = this.tableModel.getNodes(this.foundTable.getSelectedRows());
            int n = 0;
            while (n < hDataNodeArray.length && n < this.stickyPropertiesDialogs.size()) {
                ((PropertiesDialog)this.stickyPropertiesDialogs.elementAt(n)).loadNode(hDataNodeArray[n], this.tableModel.getPathToTable());
                ++n;
            }
        }
    }

    class UpdateStatus
    implements Runnable {
        String path = null;

        UpdateStatus() {
        }

        public void run() {
            if (this.path == "") {
                SearchDialog.this.status.setText("Searching...");
            } else {
                SearchDialog.this.status.setText("Searching in " + this.path);
            }
        }
    }

    class AddNodes
    implements Runnable {
        Vector nodes = new Vector(10, 0);

        AddNodes() {
        }

        public void run() {
            SearchDialog.this.tableModel.addNodes(this.nodes);
        }
    }

    public class TableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JTable jTable = (JTable)mouseEvent.getComponent();
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                int n = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n != -1) {
                    HDataNode hDataNode = tableSorter.getNode(n);
                    if (hDataNode.type == 102) {
                        DiskIndexer.executeAssoc(hDataNode, hDataNode.treePath, SearchDialog.this);
                    } else {
                        SearchDialog.this.lookup(hDataNode);
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.popthis(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.popthis(mouseEvent);
        }

        public void popthis(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTable jTable = (JTable)mouseEvent.getComponent();
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                int n = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n != -1) {
                    SearchDialog.this.nodesForAction.removeAllElements();
                    int[] nArray = jTable.isRowSelected(n) ? jTable.getSelectedRows() : new int[]{n};
                    SearchDialog.this.nodesForAction.ensureCapacity(nArray.length);
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        HDataNode hDataNode = tableSorter.getNode(nArray[n2]);
                        SearchDialog.this.nodesForAction.addElement(hDataNode);
                        ++n2;
                    }
                    SearchDialog.this.popMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public class TableKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTable jTable = (JTable)keyEvent.getComponent();
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                int n = jTable.getSelectedRow();
                HDataNode hDataNode = tableSorter.getNode(n);
                if (hDataNode.type == 102) {
                    DiskIndexer.executeAssoc(hDataNode, tableSorter.getPathToTable(), SearchDialog.this);
                } else {
                    SearchDialog.this.lookup(hDataNode);
                }
                keyEvent.consume();
            }
        }
    }
}

