/* I stripped shuttlesort out of TableSorter - Samuel Audet <guardia@cam.org> */

public class ShuttleSort
{
   // This is a home-grown implementation which we have not had time
   // to research - it may perform poorly in some circumstances. It
   // requires twice the space of an in-place algorithm and makes
   // NlogN assigments shuttling the values between the two
   // arrays. The number of compares appears to vary between N-1 and
   // NlogN depending on the initial order but the main reason for
   // using it here is that, unlike qsort, it is stable.
   public static void sort(int from[], int to[], int low, int high, ShuttleSortCompare compare) {
      if (high - low < 2) {
            return;
      }
      int middle = (low + high)/2;
      sort(to, from, low, middle, compare);
      sort(to, from, middle, high, compare);

      int p = low;
      int q = middle;

      /* This is an optional short-cut; at each recursive call,
      check to see if the elements in this subset are already
      ordered.  If so, no further comparisons are needed; the
      sub-array can just be copied.  The array must be copied rather
      than assigned otherwise sister calls in the recursion might
      get out of sinc.  When the number of elements is three they
      are partitioned so that the first set, [low, mid), has one
      element and and the second, [mid, high), has two. We skip the
      optimisation when the number of elements is three or less as
      the first compare in the normal merge will produce the same
      sequence of steps. This optimisation seems to be worthwhile
      for partially ordered lists but some analysis is needed to
      find out how the performance drops to Nlog(N) as the initial
      order diminishes - it may drop very quickly.  */

      if (high - low >= 4 && compare.compare(from[middle-1], from[middle]) <= 0) {
         for (int i = low; i < high; i++) {
            to[i] = from[i];
         }
         return;
      }

      // A normal merge.

      for (int i = low; i < high; i++) {
            if (q >= high || (p < middle && compare.compare(from[p], from[q]) <= 0)) {
            to[i] = from[p++];
         }
         else {
            to[i] = from[q++];
         }
      }
   }
}
