/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf;

import com.jgoodies.clearlook.ClearLookManager;
import com.jgoodies.plaf.Options;
import com.jgoodies.plaf.plastic.PlasticLookAndFeel;
import com.jgoodies.plaf.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public final class LookUtils {
    public static final boolean IS_BEFORE_14 = LookUtils.isBefore14();
    public static final boolean IS_140 = LookUtils.is140();
    public static final boolean IS_142_OR_LATER;
    public static final boolean HAS_XP_LAF;
    public static final boolean IS_NETBEANS;
    public static boolean isLowRes;
    private static boolean loggingEnabled;

    private LookUtils() {
    }

    public static boolean isTrueColor(Component c) {
        return c.getToolkit().getColorModel().getPixelSize() >= 24;
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            LookUtils.log("Can't read the System property " + key + ".");
            return "";
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            LookUtils.log("Can't read the System property " + key + ".");
            return "";
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isClassicWindows() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return osName.startsWith("Windows") && osVersion.startsWith("4.0");
    }

    public static boolean isModernWindows() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return osName.startsWith("Windows") && !osVersion.startsWith("4.0");
    }

    public static boolean isWindowsXP() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return osName.startsWith("Windows") && osVersion.startsWith("5.1");
    }

    public static void installNarrowMargin(AbstractButton b, String propertyPrefix) {
        Object value = b.getClientProperty("jgoodies.isNarrow");
        boolean isNarrow = Boolean.TRUE.equals(value);
        String defaultsKey = propertyPrefix + (isNarrow ? "narrowMargin" : "margin");
        Insets insets = b.getMargin();
        if (insets == null || insets instanceof UIResource) {
            b.setMargin(UIManager.getInsets(defaultsKey));
        }
    }

    public static Insets createButtonMargin(boolean narrow) {
        int pad;
        int n = pad = narrow || Options.getUseNarrowButtons() ? 4 : 14;
        return isLowRes ? (IS_BEFORE_14 ? new InsetsUIResource(0, pad, 1, pad) : new InsetsUIResource(2, pad, 1, pad)) : (IS_BEFORE_14 ? new InsetsUIResource(2, pad, 2, pad) : new InsetsUIResource(3, pad, 3, pad));
    }

    public static Color getSlightlyBrighter(Color color) {
        return LookUtils.getSlightlyBrighter(color, 1.1f);
    }

    public static Color getSlightlyBrighter(Color color, float factor) {
        float[] hsbValues = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbValues);
        float hue = hsbValues[0];
        float saturation = hsbValues[1];
        float brightness = hsbValues[2];
        float newBrightness = Math.min(brightness * factor, 1.0f);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static void setLookAndTheme(LookAndFeel laf, Object theme) throws UnsupportedLookAndFeelException {
        if (laf instanceof PlasticLookAndFeel && theme != null && theme instanceof PlasticTheme) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)theme);
        }
        UIManager.setLookAndFeel(laf);
    }

    public static Object getDefaultTheme(LookAndFeel laf) {
        return laf instanceof PlasticLookAndFeel ? PlasticLookAndFeel.createMyDefaultTheme() : null;
    }

    public static List getInstalledThemes(LookAndFeel laf) {
        return laf instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getInstalledThemes() : Collections.EMPTY_LIST;
    }

    public static void setLoggingEnabled(boolean enabled) {
        loggingEnabled = enabled;
    }

    public static void log() {
        if (loggingEnabled) {
            System.out.println();
        }
    }

    public static void log(String message) {
        if (loggingEnabled) {
            System.out.println("JGoodies Looks: " + message);
        }
    }

    private static boolean isBefore14() {
        String version = System.getProperty("java.version");
        return version.startsWith("1.2") || version.startsWith("1.3");
    }

    private static boolean is142orLater() {
        String version = System.getProperty("java.version");
        return !version.startsWith("1.2") && !version.startsWith("1.3") && !version.startsWith("1.4.0") && !version.startsWith("1.4.1");
    }

    private static boolean is140() {
        return System.getProperty("java.version").startsWith("1.4.0");
    }

    private static boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
    }

    private static boolean isNetBeans() {
        boolean hasNetBeansBuildNumber;
        boolean bl = hasNetBeansBuildNumber = LookUtils.getSystemProperty("netbeans.buildnumber") != null;
        if (hasNetBeansBuildNumber) {
            LookUtils.log("NetBeans detected - dobry den!");
        }
        return hasNetBeansBuildNumber;
    }

    static {
        HAS_XP_LAF = IS_142_OR_LATER = LookUtils.is142orLater();
        isLowRes = LookUtils.isLowResolution();
        loggingEnabled = true;
        IS_NETBEANS = LookUtils.isNetBeans();
        if (IS_NETBEANS) {
            ClearLookManager.getMode();
        }
    }
}

