/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats;

import entagged.audioformats.AudioFileIO;
import entagged.audioformats.EncodingInfo;
import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.generic.GenericTag;
import java.io.File;

public class AudioFile
extends File {
    private EncodingInfo info;
    private Tag tag;

    public AudioFile(File file, EncodingInfo encodingInfo) {
        super(file.getAbsolutePath());
        this.info = encodingInfo;
        this.tag = new GenericTag();
    }

    public AudioFile(File file, EncodingInfo encodingInfo, Tag tag) {
        super(file.getAbsolutePath());
        this.info = encodingInfo;
        this.tag = tag;
    }

    public AudioFile(String string, EncodingInfo encodingInfo) {
        super(string);
        this.info = encodingInfo;
        this.tag = new GenericTag();
    }

    public AudioFile(String string, EncodingInfo encodingInfo, Tag tag) {
        super(string);
        this.info = encodingInfo;
        this.tag = tag;
    }

    public void commit() throws CannotWriteException {
        AudioFileIO.write(this);
    }

    public int getBitrate() {
        return this.info.getBitrate();
    }

    public int getChannelNumber() {
        return this.info.getChannelNumber();
    }

    public String getEncodingType() {
        return this.info.getEncodingType();
    }

    public String getExtraEncodingInfos() {
        return this.info.getExtraEncodingInfos();
    }

    public int getLength() {
        return this.info.getLength();
    }

    public float getPreciseLength() {
        return this.info.getPreciseLength();
    }

    public int getSamplingRate() {
        return this.info.getSamplingRate();
    }

    public Tag getTag() {
        return this.tag == null ? new GenericTag() : this.tag;
    }

    public boolean isVbr() {
        return this.info.isVbr();
    }

    public String toString() {
        return "AudioFile " + this.getAbsolutePath() + "  --------\n" + this.info.toString() + "\n" + (this.tag == null ? "" : ((Object)this.tag).toString()) + "\n-------------------";
    }
}

