/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ape.util;

import entagged.audioformats.Tag;
import entagged.audioformats.ape.ApeTag;
import entagged.audioformats.ape.util.ApeTagBinaryField;
import entagged.audioformats.ape.util.ApeTagTextField;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.generic.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ApeTagReader {
    public Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        ApeTag apeTag = new ApeTag();
        randomAccessFile.seek(randomAccessFile.length() - 32L);
        byte[] byArray = new byte[8];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("APETAGEX")) {
            throw new CannotReadException("There is no APE Tag in this file");
        }
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        int n = Utils.getNumber(byArray, 0, 3);
        if (n != 2000) {
            throw new CannotReadException("APE Tag other than version 2.0 are not supported");
        }
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        long l = Utils.getLongNumber(byArray, 0, 3);
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        int n2 = Utils.getNumber(byArray, 0, 3);
        byArray = new byte[4];
        randomAccessFile.read(byArray);
        randomAccessFile.seek(randomAccessFile.length() - l);
        for (int i = 0; i < n2; ++i) {
            byArray = new byte[4];
            randomAccessFile.read(byArray);
            int n3 = Utils.getNumber(byArray, 0, 3);
            if (n3 > 500000) {
                throw new CannotReadException("Item size is much too large: " + n3 + " bytes");
            }
            byArray = new byte[4];
            randomAccessFile.read(byArray);
            boolean bl = (byArray[0] & 6) >> 1 == 1;
            int n4 = 0;
            while (randomAccessFile.readByte() != 0) {
                ++n4;
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() - (long)n4 - 1L);
            int n5 = n4;
            byArray = new byte[n5];
            randomAccessFile.read(byArray);
            randomAccessFile.skipBytes(1);
            String string2 = new String(byArray);
            byArray = new byte[n3];
            randomAccessFile.read(byArray);
            if (!bl) {
                apeTag.add(new ApeTagTextField(string2, new String(byArray, "UTF-8")));
                continue;
            }
            apeTag.add(new ApeTagBinaryField(string2, byArray));
        }
        return apeTag;
    }
}

