/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ape.util;

import entagged.audioformats.Tag;
import entagged.audioformats.ape.util.ApeTagCreator;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.generic.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ApeTagWriter {
    private ApeTagCreator tc = new ApeTagCreator();

    public void delete(RandomAccessFile randomAccessFile) throws IOException {
        if (!this.tagExists(randomAccessFile)) {
            return;
        }
        randomAccessFile.seek(randomAccessFile.length() - 20L);
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        long l = Utils.getLongNumber(byArray, 0, 3);
        randomAccessFile.setLength(randomAccessFile.length() - l);
        if (!this.tagExists(randomAccessFile)) {
            return;
        }
        randomAccessFile.setLength(randomAccessFile.length() - 32L);
    }

    private boolean tagExists(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(randomAccessFile.length() - 32L);
        byte[] byArray = new byte[8];
        randomAccessFile.read(byArray);
        return new String(byArray).equals("APETAGEX");
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        FileChannel fileChannel = randomAccessFile.getChannel();
        ByteBuffer byteBuffer = this.tc.convert(tag, 0);
        if (!this.tagExists(randomAccessFile)) {
            fileChannel.position(fileChannel.size());
            fileChannel.write(byteBuffer);
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 32L + 8L);
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray);
            int n = Utils.getNumber(byArray, 0, 3);
            if (n != 2000) {
                throw new CannotWriteException("APE Tag other than version 2.0 are not supported");
            }
            byArray = new byte[4];
            randomAccessFile.read(byArray);
            long l = Utils.getLongNumber(byArray, 0, 3) + 32L;
            int n2 = byteBuffer.capacity();
            if (l <= (long)n2) {
                System.err.println("Overwriting old tag in mpc file");
                fileChannel.position(fileChannel.size() - l);
                fileChannel.write(byteBuffer);
            } else {
                System.err.println("Shrinking mpc file");
                FileChannel fileChannel2 = randomAccessFile2.getChannel();
                fileChannel2.position(0L);
                fileChannel.position(0L);
                fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size() - l);
                fileChannel2.position(fileChannel2.size());
                fileChannel2.write(byteBuffer);
            }
        }
    }
}

