/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.GUID;
import java.math.BigInteger;

public class Chunk {
    protected final BigInteger chunkLength;
    protected final GUID guid;
    protected final long position;

    public Chunk(GUID gUID, long l, BigInteger bigInteger) {
        if (gUID == null) {
            throw new IllegalArgumentException("GUID must not be null nor anything else than 16 entries long.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Position of header can't be negative.");
        }
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("chunkLen must not be null nor negative.");
        }
        this.guid = gUID;
        this.position = l;
        this.chunkLength = bigInteger;
    }

    public long getChunckEnd() {
        return this.position + this.chunkLength.longValue();
    }

    public BigInteger getChunkLength() {
        return this.chunkLength;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public long getPosition() {
        return this.position;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GUID: " + GUID.getGuidDescription(this.guid));
        stringBuffer.append("\n   Starts at position: " + this.getPosition() + "\n");
        stringBuffer.append("   Last byte at: " + (this.getChunckEnd() - 1L) + "\n\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.prettyPrint();
    }
}

