/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class ContentDescription
extends Chunk {
    private String author = null;
    private String copyRight = null;
    private String description = null;
    private String rating = null;
    private String title = null;

    public ContentDescription() {
        this(0L, BigInteger.valueOf(0L));
    }

    public ContentDescription(long l, BigInteger bigInteger) {
        super(GUID.GUID_CONTENTDESCRIPTION, l, bigInteger);
    }

    public String getAuthor() {
        if (this.author == null) {
            return "";
        }
        return this.author;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            String[] stringArray = new String[]{this.getTitle(), this.getAuthor(), this.getCopyRight(), this.getComment(), this.getRating()};
            byte[][] byArrayArray = new byte[stringArray.length][];
            for (n = 0; n < stringArray.length; ++n) {
                byArrayArray[n] = stringArray[n].getBytes("UTF-16LE");
            }
            for (n = 0; n < byArrayArray.length; ++n) {
                byteArrayOutputStream2.write(Utils.getBytes(byArrayArray[n].length + 2, 2));
            }
            for (n = 0; n < stringArray.length; ++n) {
                byteArrayOutputStream2.write(byArrayArray[n]);
                byteArrayOutputStream2.write(Utils.getBytes(0L, 2));
            }
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream.write(GUID.GUID_CONTENTDESCRIPTION.getBytes());
            byteArrayOutputStream.write(Utils.getBytes(byArray.length + 24, 8));
            byteArrayOutputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getComment() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getCopyRight() {
        if (this.copyRight == null) {
            return "";
        }
        return this.copyRight;
    }

    public String getRating() {
        if (this.rating == null) {
            return "";
        }
        return this.rating;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint());
        stringBuffer.insert(0, Utils.LINE_SEPARATOR + "Content Description:" + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Title      : " + this.getTitle() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Author     : " + this.getAuthor() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Copyright  : " + this.getCopyRight() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Description: " + this.getComment() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Rating     :" + this.getRating() + Utils.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public void setAuthor(String string) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(string);
        this.author = string;
    }

    public void setComment(String string) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(string);
        this.description = string;
    }

    public void setCopyRight(String string) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(string);
        this.copyRight = string;
    }

    public void setRating(String string) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(string);
        this.rating = string;
    }

    public void setTitle(String string) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(string);
        this.title = string;
    }
}

