/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;

public final class ContentDescriptor
implements Comparable {
    public static final HashSet COMMON_FIELD_IDS = new HashSet();
    public static final String ID_ALBUM = "WM/AlbumTitle";
    public static final String ID_ARTIST = "WM/AlbumArtist";
    public static final String ID_GENRE = "WM/Genre";
    public static final String ID_GENREID = "WM/GenreID";
    public static final String ID_TRACKNUMBER = "WM/TrackNumber";
    public static final String ID_YEAR = "WM/Year";
    public static final int TYPE_BINARY = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_DWORD = 3;
    public static final int TYPE_QWORD = 4;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_WORD = 5;
    protected byte[] content = new byte[0];
    private int descriptorType;
    private final String name;

    public ContentDescriptor(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        Utils.checkStringLengthNullSafe(string);
        this.name = string;
        this.descriptorType = n;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.createCopy();
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof ContentDescriptor) {
            ContentDescriptor contentDescriptor = (ContentDescriptor)object;
            n = this.getName().compareTo(contentDescriptor.getName());
        }
        return n;
    }

    public ContentDescriptor createCopy() {
        ContentDescriptor contentDescriptor = new ContentDescriptor(this.getName(), this.getType());
        contentDescriptor.content = this.getRawData();
        return contentDescriptor;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ContentDescriptor) {
            ContentDescriptor contentDescriptor;
            bl = object == this ? true : (contentDescriptor = (ContentDescriptor)object).getName().equals(this.getName()) && contentDescriptor.descriptorType == this.descriptorType && Arrays.equals(this.content, contentDescriptor.content);
        }
        return bl;
    }

    public boolean getBoolean() {
        return this.content.length > 0 && this.content[0] != 0;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = this.getName().getBytes("UTF-16LE");
            byteArrayOutputStream.write(Utils.getBytes(byArray.length + 2, 2));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Utils.getBytes(0L, 2));
            byteArrayOutputStream.write(Utils.getBytes(this.getType(), 2));
            if (this.getType() == 0) {
                byteArrayOutputStream.write(Utils.getBytes(this.content.length + 2, 2));
                byteArrayOutputStream.write(this.content);
                byteArrayOutputStream.write(Utils.getBytes(0L, 2));
            } else {
                byteArrayOutputStream.write(Utils.getBytes(this.content.length, 2));
                byteArrayOutputStream.write(this.content);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getName() {
        return this.name;
    }

    public long getNumber() {
        long l = 0L;
        int n = -1;
        switch (this.getType()) {
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The current type doesn't allow an interpretation as a number.");
            }
        }
        if (n > this.content.length) {
            throw new IllegalStateException("The stored data cannot represent the type of current object.");
        }
        for (int i = 0; i < n; ++i) {
            l |= (long)(this.content[i] << i * 8);
        }
        return l;
    }

    public byte[] getRawData() {
        byte[] byArray = new byte[this.content.length];
        System.arraycopy(byArray, 0, this.content, 0, this.content.length);
        return byArray;
    }

    public String getString() {
        String string = "";
        switch (this.getType()) {
            case 1: {
                string = "binary data";
                break;
            }
            case 2: {
                string = String.valueOf(this.getBoolean());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = String.valueOf(this.getNumber());
                break;
            }
            case 0: {
                try {
                    string = new String(this.content, "UTF-16LE");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            default: {
                throw new IllegalStateException("Current type is not known.");
            }
        }
        return string;
    }

    public int getType() {
        return this.descriptorType;
    }

    public boolean isCommon() {
        return COMMON_FIELD_IDS.contains(this.getName());
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public void setBinaryValue(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("Too many bytes. 65535 is maximum.");
        }
        this.content = byArray;
        this.descriptorType = 1;
    }

    public void setBooleanValue(boolean bl) {
        this.content = new byte[]{bl ? (byte)1 : 0, 0, 0, 0};
        this.descriptorType = 2;
    }

    public void setDWordValue(long l) {
        this.content = Utils.getBytes(l, 4);
        this.descriptorType = 3;
    }

    public void setQWordValue(long l) {
        this.content = Utils.getBytes(l, 8);
        this.descriptorType = 4;
    }

    public void setStringValue(String string) throws IllegalArgumentException {
        try {
            byte[] byArray = string.getBytes("UTF-16LE");
            if (byArray.length > 65535) {
                throw new IllegalArgumentException("Byte representation of String in \"UTF-16LE\" is to great. (Maximum is 65535 Bytes)");
            }
            this.content = byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.content = new byte[0];
        }
        this.descriptorType = 0;
    }

    public void setWordValue(int n) {
        this.content = Utils.getBytes(n, 2);
        this.descriptorType = 5;
    }

    public String toString() {
        return this.getName() + " : " + (new String[]{"String: ", "Binary: ", "Boolean: ", "DWORD: ", "QWORD:", "WORD:"})[this.descriptorType] + this.getString();
    }

    static {
        COMMON_FIELD_IDS.add(ID_ALBUM);
        COMMON_FIELD_IDS.add(ID_ARTIST);
        COMMON_FIELD_IDS.add(ID_GENRE);
        COMMON_FIELD_IDS.add(ID_GENREID);
        COMMON_FIELD_IDS.add(ID_TRACKNUMBER);
        COMMON_FIELD_IDS.add(ID_YEAR);
    }
}

