/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.Tag;
import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.ContentDescriptor;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ExtendedContentDescription
extends Chunk {
    private final ArrayList descriptors = new ArrayList();
    private HashMap indexMap = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtendedContentDescription() {
        this(0L, BigInteger.valueOf(0L));
    }

    public ExtendedContentDescription(long l, BigInteger bigInteger) {
        super(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, l, bigInteger);
    }

    public void addDescriptor(ContentDescriptor contentDescriptor) {
        if (!$assertionsDisabled && contentDescriptor == null) {
            throw new AssertionError((Object)"Argument must not be null.");
        }
        if (this.getDescriptor(contentDescriptor.getName()) != null) {
            throw new RuntimeException(contentDescriptor.getName() + " is already present");
        }
        this.descriptors.add(contentDescriptor);
        this.indexMap.put(contentDescriptor.getName(), new Integer(this.descriptors.size() - 1));
    }

    public void addOrReplace(ContentDescriptor contentDescriptor) {
        if (!$assertionsDisabled && contentDescriptor == null) {
            throw new AssertionError((Object)"Argument must not be null");
        }
        if (this.getDescriptor(contentDescriptor.getName()) != null) {
            this.remove(contentDescriptor.getName());
        }
        this.addDescriptor(contentDescriptor);
    }

    public String getAlbum() {
        ContentDescriptor contentDescriptor = this.getDescriptor("WM/AlbumTitle");
        if (contentDescriptor == null) {
            return "";
        }
        return contentDescriptor.getString();
    }

    public String getArtist() {
        ContentDescriptor contentDescriptor = this.getDescriptor("WM/AlbumArtist");
        if (contentDescriptor == null) {
            return "";
        }
        return contentDescriptor.getString();
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byteArrayOutputStream2.write(Utils.getBytes(this.descriptors.size(), 2));
            Iterator iterator = this.descriptors.iterator();
            while (iterator.hasNext()) {
                object = (ContentDescriptor)iterator.next();
                byteArrayOutputStream2.write(((ContentDescriptor)object).getBytes());
            }
            object = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream.write(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION.getBytes());
            byteArrayOutputStream.write(Utils.getBytes(((Object)object).length + 24, 8));
            byteArrayOutputStream.write((byte[])object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ContentDescriptor getDescriptor(String string) {
        Integer n;
        if (this.indexMap == null) {
            this.indexMap = new HashMap();
            for (int i = 0; i < this.descriptors.size(); ++i) {
                ContentDescriptor contentDescriptor = (ContentDescriptor)this.descriptors.get(i);
                this.indexMap.put(contentDescriptor.getName(), new Integer(i));
            }
        }
        if ((n = (Integer)this.indexMap.get(string)) != null) {
            return (ContentDescriptor)this.descriptors.get(n);
        }
        return null;
    }

    public long getDescriptorCount() {
        return this.descriptors.size();
    }

    public Collection getDescriptors() {
        return new ArrayList(this.descriptors);
    }

    public String getGenre() {
        String string = null;
        ContentDescriptor contentDescriptor = this.getDescriptor("WM/Genre");
        if (contentDescriptor == null) {
            contentDescriptor = this.getDescriptor("WM/GenreID");
            if (contentDescriptor == null) {
                string = "";
            } else {
                string = contentDescriptor.getString();
                if (string.startsWith("(") && string.endsWith(")")) {
                    string = string.substring(1, string.length() - 1);
                    try {
                        int n = Integer.parseInt(string);
                        if (n >= 0 && n < Tag.DEFAULT_GENRES.length) {
                            string = Tag.DEFAULT_GENRES[n];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else {
            string = contentDescriptor.getString();
        }
        return string;
    }

    public String getTrack() {
        ContentDescriptor contentDescriptor = this.getDescriptor("WM/TrackNumber");
        if (contentDescriptor == null) {
            return "";
        }
        return contentDescriptor.getString();
    }

    public String getYear() {
        ContentDescriptor contentDescriptor = this.getDescriptor("WM/Year");
        if (contentDescriptor == null) {
            return "";
        }
        return contentDescriptor.getString();
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint());
        stringBuffer.insert(0, "\nExtended Content Description:\n");
        Object[] objectArray = this.descriptors.toArray(new ContentDescriptor[this.descriptors.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("   ");
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(Utils.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public ContentDescriptor remove(String string) {
        ContentDescriptor contentDescriptor = this.getDescriptor(string);
        if (contentDescriptor != null) {
            this.descriptors.remove(contentDescriptor);
        }
        this.indexMap = null;
        return contentDescriptor;
    }

    static {
        $assertionsDisabled = !ExtendedContentDescription.class.desiredAssertionStatus();
    }
}

