/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.flac.util;

import entagged.audioformats.Tag;
import entagged.audioformats.ogg.util.OggTagCreator;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class FlacTagCreator {
    public static final int DEFAULT_PADDING = 4000;
    private static final OggTagCreator creator = new OggTagCreator();

    public ByteBuffer convert(Tag tag, int n) throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = creator.convert(tag);
        int n2 = byteBuffer.capacity() + 4;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2 + n);
        byte by = n > 0 ? (byte)4 : -124;
        byteBuffer2.put(by);
        int n3 = n2 - 4;
        byteBuffer2.put(new byte[]{(byte)((n3 & 0xFF0000) >>> 16), (byte)((n3 & 0xFF00) >>> 8), (byte)(n3 & 0xFF)});
        byteBuffer2.put(byteBuffer);
        if (n >= 4) {
            int n4 = n - 4;
            byteBuffer2.put((byte)-127);
            byteBuffer2.put(new byte[]{(byte)((n4 & 0xFF0000) >>> 16), (byte)((n4 & 0xFF00) >>> 8), (byte)(n4 & 0xFF)});
            for (int i = 0; i < n4; ++i) {
                byteBuffer2.put((byte)0);
            }
        }
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public int getTagLength(Tag tag) throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = creator.convert(tag);
        return byteBuffer.capacity() + 4;
    }
}

