/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.flac.util;

import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.flac.util.FlacTagCreator;
import entagged.audioformats.flac.util.FlacTagReader;
import entagged.audioformats.flac.util.MetadataBlock;
import entagged.audioformats.flac.util.MetadataBlockDataApplication;
import entagged.audioformats.flac.util.MetadataBlockDataCueSheet;
import entagged.audioformats.flac.util.MetadataBlockDataPadding;
import entagged.audioformats.flac.util.MetadataBlockDataSeekTable;
import entagged.audioformats.flac.util.MetadataBlockHeader;
import entagged.audioformats.ogg.OggTag;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Vector;

public class FlacTagWriter {
    private Vector metadataBlockPadding = new Vector(1);
    private Vector metadataBlockApplication = new Vector(1);
    private Vector metadataBlockSeekTable = new Vector(1);
    private Vector metadataBlockCueSheet = new Vector(1);
    private FlacTagCreator tc = new FlacTagCreator();
    private FlacTagReader reader = new FlacTagReader();

    public void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotWriteException {
        OggTag oggTag = null;
        try {
            oggTag = this.reader.read(randomAccessFile);
        }
        catch (CannotReadException cannotReadException) {
            this.write(new OggTag(), randomAccessFile, randomAccessFile2);
            return;
        }
        OggTag oggTag2 = new OggTag();
        oggTag2.setVendor(oggTag.getVendor());
        randomAccessFile.seek(0L);
        randomAccessFile2.seek(0L);
        this.write(oggTag2, randomAccessFile, randomAccessFile2);
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        this.metadataBlockPadding.removeAllElements();
        this.metadataBlockApplication.removeAllElements();
        this.metadataBlockSeekTable.removeAllElements();
        this.metadataBlockCueSheet.removeAllElements();
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray);
        String string = new String(byArray);
        if (!string.equals("fLaC")) {
            throw new CannotWriteException("This is not a FLAC file");
        }
        boolean bl = false;
        while (!bl) {
            byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            MetadataBlockHeader metadataBlockHeader = new MetadataBlockHeader(byArray);
            switch (metadataBlockHeader.getBlockType()) {
                case 4: {
                    this.handlePadding(metadataBlockHeader, randomAccessFile);
                    break;
                }
                case 1: {
                    this.handlePadding(metadataBlockHeader, randomAccessFile);
                    break;
                }
                case 2: {
                    this.handleApplication(metadataBlockHeader, randomAccessFile);
                    break;
                }
                case 3: {
                    this.handleSeekTable(metadataBlockHeader, randomAccessFile);
                    break;
                }
                case 5: {
                    this.handleCueSheet(metadataBlockHeader, randomAccessFile);
                    break;
                }
                default: {
                    this.skipBlock(metadataBlockHeader, randomAccessFile);
                }
            }
            bl = metadataBlockHeader.isLastBlock();
        }
        int n = this.computeAvailableRoom();
        int n2 = this.tc.getTagLength(tag);
        int n3 = n2 + this.computeNeededRoom();
        randomAccessFile.seek(0L);
        if (n >= n3) {
            int n4;
            randomAccessFile.seek(42L);
            for (n4 = 0; n4 < this.metadataBlockApplication.size(); ++n4) {
                randomAccessFile.write(((MetadataBlock)this.metadataBlockApplication.elementAt(n4)).getHeader().getBytes());
                randomAccessFile.write(((MetadataBlock)this.metadataBlockApplication.elementAt(n4)).getData().getBytes());
            }
            for (n4 = 0; n4 < this.metadataBlockSeekTable.size(); ++n4) {
                randomAccessFile.write(((MetadataBlock)this.metadataBlockSeekTable.elementAt(n4)).getHeader().getBytes());
                randomAccessFile.write(((MetadataBlock)this.metadataBlockSeekTable.elementAt(n4)).getData().getBytes());
            }
            for (n4 = 0; n4 < this.metadataBlockCueSheet.size(); ++n4) {
                randomAccessFile.write(((MetadataBlock)this.metadataBlockCueSheet.elementAt(n4)).getHeader().getBytes());
                randomAccessFile.write(((MetadataBlock)this.metadataBlockCueSheet.elementAt(n4)).getData().getBytes());
            }
            randomAccessFile.getChannel().write(this.tc.convert(tag, n - n3));
        } else {
            int n5;
            FileChannel fileChannel = randomAccessFile.getChannel();
            byArray = new byte[42];
            randomAccessFile.readFully(byArray);
            randomAccessFile.seek(n + 42);
            FileChannel fileChannel2 = randomAccessFile2.getChannel();
            randomAccessFile2.write(byArray);
            for (n5 = 0; n5 < this.metadataBlockApplication.size(); ++n5) {
                randomAccessFile2.write(((MetadataBlock)this.metadataBlockApplication.elementAt(n5)).getHeader().getBytes());
                randomAccessFile2.write(((MetadataBlock)this.metadataBlockApplication.elementAt(n5)).getData().getBytes());
            }
            for (n5 = 0; n5 < this.metadataBlockSeekTable.size(); ++n5) {
                randomAccessFile2.write(((MetadataBlock)this.metadataBlockSeekTable.elementAt(n5)).getHeader().getBytes());
                randomAccessFile2.write(((MetadataBlock)this.metadataBlockSeekTable.elementAt(n5)).getData().getBytes());
            }
            for (n5 = 0; n5 < this.metadataBlockCueSheet.size(); ++n5) {
                randomAccessFile2.write(((MetadataBlock)this.metadataBlockCueSheet.elementAt(n5)).getHeader().getBytes());
                randomAccessFile2.write(((MetadataBlock)this.metadataBlockCueSheet.elementAt(n5)).getData().getBytes());
            }
            randomAccessFile2.write(this.tc.convert(tag, 4000).array());
            fileChannel2.transferFrom(fileChannel, fileChannel2.position(), fileChannel.size());
        }
    }

    private int computeAvailableRoom() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.metadataBlockApplication.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockApplication.elementAt(n)).getLength();
        }
        for (n = 0; n < this.metadataBlockSeekTable.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockSeekTable.elementAt(n)).getLength();
        }
        for (n = 0; n < this.metadataBlockCueSheet.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockCueSheet.elementAt(n)).getLength();
        }
        for (n = 0; n < this.metadataBlockPadding.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockPadding.elementAt(n)).getLength();
        }
        return n2;
    }

    private int computeNeededRoom() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.metadataBlockApplication.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockApplication.elementAt(n)).getLength();
        }
        for (n = 0; n < this.metadataBlockSeekTable.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockSeekTable.elementAt(n)).getLength();
        }
        for (n = 0; n < this.metadataBlockCueSheet.size(); ++n) {
            n2 += ((MetadataBlock)this.metadataBlockCueSheet.elementAt(n)).getLength();
        }
        return n2;
    }

    private void skipBlock(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)metadataBlockHeader.getDataLength());
    }

    private void handlePadding(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)metadataBlockHeader.getDataLength());
        MetadataBlockDataPadding metadataBlockDataPadding = new MetadataBlockDataPadding(metadataBlockHeader.getDataLength());
        this.metadataBlockPadding.add(new MetadataBlock(metadataBlockHeader, metadataBlockDataPadding));
    }

    private void handleApplication(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[metadataBlockHeader.getDataLength()];
        randomAccessFile.readFully(byArray);
        MetadataBlockDataApplication metadataBlockDataApplication = new MetadataBlockDataApplication(byArray);
        this.metadataBlockApplication.add(new MetadataBlock(metadataBlockHeader, metadataBlockDataApplication));
    }

    private void handleSeekTable(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[metadataBlockHeader.getDataLength()];
        randomAccessFile.readFully(byArray);
        MetadataBlockDataSeekTable metadataBlockDataSeekTable = new MetadataBlockDataSeekTable(byArray);
        this.metadataBlockSeekTable.add(new MetadataBlock(metadataBlockHeader, metadataBlockDataSeekTable));
    }

    private void handleCueSheet(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[metadataBlockHeader.getDataLength()];
        randomAccessFile.readFully(byArray);
        MetadataBlockDataCueSheet metadataBlockDataCueSheet = new MetadataBlockDataCueSheet(byArray);
        this.metadataBlockCueSheet.add(new MetadataBlock(metadataBlockHeader, metadataBlockDataCueSheet));
    }
}

