/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.flac.util;

public class MetadataBlockHeader {
    public static final int STREAMINFO = 0;
    public static final int PADDING = 1;
    public static final int APPLICATION = 2;
    public static final int SEEKTABLE = 3;
    public static final int VORBIS_COMMENT = 4;
    public static final int CUESHEET = 5;
    public static final int UNKNOWN = 6;
    private boolean isLastBlock;
    private int blockType;
    private int dataLength;
    private byte[] bytes;

    public MetadataBlockHeader(byte[] byArray) {
        this.isLastBlock = (byArray[0] & 0x80) >>> 7 == 1;
        int n = byArray[0] & 0x7F;
        switch (n) {
            case 0: {
                this.blockType = 0;
                break;
            }
            case 1: {
                this.blockType = 1;
                break;
            }
            case 2: {
                this.blockType = 2;
                break;
            }
            case 3: {
                this.blockType = 3;
                break;
            }
            case 4: {
                this.blockType = 4;
                break;
            }
            case 5: {
                this.blockType = 5;
                break;
            }
            default: {
                this.blockType = 6;
            }
        }
        this.dataLength = (this.u(byArray[1]) << 16) + (this.u(byArray[2]) << 8) + this.u(byArray[3]);
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.bytes[i] = byArray[i];
        }
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public String getBlockTypeString() {
        switch (this.blockType) {
            case 0: {
                return "STREAMINFO";
            }
            case 1: {
                return "PADDING";
            }
            case 2: {
                return "APPLICATION";
            }
            case 3: {
                return "SEEKTABLE";
            }
            case 4: {
                return "VORBIS_COMMENT";
            }
            case 5: {
                return "CUESHEET";
            }
        }
        return "UNKNOWN-RESERVED";
    }

    public boolean isLastBlock() {
        return this.isLastBlock;
    }

    public byte[] getBytes() {
        this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
        return this.bytes;
    }
}

