/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import entagged.audioformats.Tag;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractTag
implements Tag {
    protected int commonNumber = 0;
    protected HashMap fields = new HashMap();

    public void add(TagField tagField) {
        if (tagField == null || tagField.isEmpty()) {
            return;
        }
        ArrayList<TagField> arrayList = (ArrayList<TagField>)this.fields.get(tagField.getId());
        if (arrayList == null) {
            arrayList = new ArrayList<TagField>();
            arrayList.add(tagField);
            this.fields.put(tagField.getId(), arrayList);
            if (tagField.isCommon()) {
                ++this.commonNumber;
            }
        } else {
            arrayList.add(tagField);
        }
    }

    public void addAlbum(String string) {
        this.add(this.createAlbumField(string));
    }

    public void addArtist(String string) {
        this.add(this.createArtistField(string));
    }

    public void addComment(String string) {
        this.add(this.createCommentField(string));
    }

    public void addGenre(String string) {
        this.add(this.createGenreField(string));
    }

    public void addTitle(String string) {
        this.add(this.createTitleField(string));
    }

    public void addTrack(String string) {
        this.add(this.createTrackField(string));
    }

    public void addYear(String string) {
        this.add(this.createYearField(string));
    }

    protected abstract TagField createAlbumField(String var1);

    protected abstract TagField createArtistField(String var1);

    protected abstract TagField createCommentField(String var1);

    protected abstract TagField createGenreField(String var1);

    protected abstract TagField createTitleField(String var1);

    protected abstract TagField createTrackField(String var1);

    protected abstract TagField createYearField(String var1);

    public List get(String string) {
        List list = (List)this.fields.get(string);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public List getAlbum() {
        return this.get(this.getAlbumId());
    }

    protected abstract String getAlbumId();

    public List getArtist() {
        return this.get(this.getArtistId());
    }

    protected abstract String getArtistId();

    public List getComment() {
        return this.get(this.getCommentId());
    }

    protected abstract String getCommentId();

    public Iterator getFields() {
        final Iterator iterator = this.fields.entrySet().iterator();
        return new Iterator(){
            private Iterator fieldsIt;

            private void changeIt() {
                if (!iterator.hasNext()) {
                    return;
                }
                List list = (List)((Map.Entry)iterator.next()).getValue();
                this.fieldsIt = list.iterator();
            }

            public boolean hasNext() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                return iterator.hasNext() || this.fieldsIt != null && this.fieldsIt.hasNext();
            }

            public Object next() {
                if (!this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                return this.fieldsIt.next();
            }

            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    public String getFirstAlbum() {
        List list = this.get(this.getAlbumId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public String getFirstArtist() {
        List list = this.get(this.getArtistId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public String getFirstComment() {
        List list = this.get(this.getCommentId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public String getFirstGenre() {
        List list = this.get(this.getGenreId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public String getFirstTitle() {
        List list = this.get(this.getTitleId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public String getFirstTrack() {
        List list = this.get(this.getTrackId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public String getFirstYear() {
        List list = this.get(this.getYearId());
        return list.size() != 0 ? ((TagTextField)list.get(0)).getContent() : "";
    }

    public List getGenre() {
        return this.get(this.getGenreId());
    }

    protected abstract String getGenreId();

    public List getTitle() {
        return this.get(this.getTitleId());
    }

    protected abstract String getTitleId();

    public List getTrack() {
        return this.get(this.getTrackId());
    }

    protected abstract String getTrackId();

    public List getYear() {
        return this.get(this.getYearId());
    }

    protected abstract String getYearId();

    public boolean hasCommonFields() {
        return this.commonNumber != 0;
    }

    public boolean hasField(String string) {
        return this.get(string).size() != 0;
    }

    protected abstract boolean isAllowedEncoding(String var1);

    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    public void merge(Tag tag) {
        if (this.getTitle().size() == 0) {
            this.setTitle(tag.getFirstTitle());
        }
        if (this.getArtist().size() == 0) {
            this.setArtist(tag.getFirstArtist());
        }
        if (this.getAlbum().size() == 0) {
            this.setAlbum(tag.getFirstAlbum());
        }
        if (this.getYear().size() == 0) {
            this.setYear(tag.getFirstYear());
        }
        if (this.getComment().size() == 0) {
            this.setComment(tag.getFirstComment());
        }
        if (this.getTrack().size() == 0) {
            this.setTrack(tag.getFirstTrack());
        }
        if (this.getGenre().size() == 0) {
            this.setGenre(tag.getFirstGenre());
        }
    }

    public void set(TagField tagField) {
        if (tagField == null) {
            return;
        }
        if (tagField.isEmpty()) {
            Object v = this.fields.remove(tagField.getId());
            if (v != null && tagField.isCommon()) {
                --this.commonNumber;
            }
            return;
        }
        ArrayList<TagField> arrayList = (ArrayList<TagField>)this.fields.get(tagField.getId());
        if (arrayList != null) {
            TagField tagField2 = (TagField)arrayList.get(0);
            tagField2.copyContent(tagField);
            return;
        }
        arrayList = new ArrayList<TagField>();
        arrayList.add(tagField);
        this.fields.put(tagField.getId(), arrayList);
        if (tagField.isCommon()) {
            ++this.commonNumber;
        }
    }

    public void setAlbum(String string) {
        this.set(this.createAlbumField(string));
    }

    public void setArtist(String string) {
        this.set(this.createArtistField(string));
    }

    public void setComment(String string) {
        this.set(this.createCommentField(string));
    }

    public boolean setEncoding(String string) {
        if (!this.isAllowedEncoding(string)) {
            return false;
        }
        Iterator iterator = this.getFields();
        while (iterator.hasNext()) {
            TagField tagField = (TagField)iterator.next();
            if (!(tagField instanceof TagTextField)) continue;
            ((TagTextField)tagField).setEncoding(string);
        }
        return true;
    }

    public void setGenre(String string) {
        this.set(this.createGenreField(string));
    }

    public void setTitle(String string) {
        this.set(this.createTitleField(string));
    }

    public void setTrack(String string) {
        this.set(this.createTrackField(string));
    }

    public void setYear(String string) {
        this.set(this.createYearField(string));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tag content:\n");
        Iterator iterator = this.getFields();
        while (iterator.hasNext()) {
            TagField tagField = (TagField)iterator.next();
            stringBuffer.append("\t");
            stringBuffer.append(tagField.getId());
            stringBuffer.append(" : ");
            stringBuffer.append(((Object)tagField).toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }
}

