/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import entagged.audioformats.AudioFile;
import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.exceptions.ModifyVetoException;
import entagged.audioformats.generic.AudioFileModificationListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AudioFileWriter {
    private AudioFileModificationListener modificationListener = null;

    /*
     * Loose catch block
     */
    public synchronized void delete(AudioFile audioFile) throws CannotWriteException {
        block24: {
            if (!audioFile.canWrite()) {
                throw new CannotWriteException("Can't write to file \"" + audioFile.getAbsolutePath() + "\"");
            }
            if (audioFile.length() <= 150L) {
                throw new CannotWriteException("Less than 150 byte \"" + audioFile.getAbsolutePath() + "\"");
            }
            RandomAccessFile randomAccessFile = null;
            RandomAccessFile randomAccessFile2 = null;
            File file = null;
            boolean bl = false;
            file = File.createTempFile("entagged", ".tmp", audioFile.getParentFile());
            randomAccessFile2 = new RandomAccessFile(file, "rw");
            randomAccessFile = new RandomAccessFile(audioFile, "rw");
            randomAccessFile.seek(0L);
            randomAccessFile2.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(audioFile, true);
                }
                this.deleteTag(randomAccessFile, randomAccessFile2);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(audioFile, file);
                }
            }
            catch (ModifyVetoException modifyVetoException) {
                throw new CannotWriteException(modifyVetoException);
            }
            Object var8_8 = null;
            File file2 = audioFile;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
                if (file.length() > 0L && !bl) {
                    audioFile.delete();
                    file.renameTo(audioFile);
                    file2 = file;
                } else {
                    file.delete();
                }
            }
            catch (Exception exception) {
                System.err.println("AudioFileWriter:113:\"" + audioFile.getAbsolutePath() + "\" or \"" + file.getAbsolutePath() + "\" :" + exception);
            }
            if (this.modificationListener != null) {
                this.modificationListener.fileOperationFinished(file2);
            }
            break block24;
            {
                catch (Exception exception) {
                    bl = true;
                    throw new CannotWriteException("\"" + audioFile.getAbsolutePath() + "\" :" + exception, exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                File file3 = audioFile;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (randomAccessFile2 != null) {
                        randomAccessFile2.close();
                    }
                    if (file.length() > 0L && !bl) {
                        audioFile.delete();
                        file.renameTo(audioFile);
                        file3 = file;
                    } else {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    System.err.println("AudioFileWriter:113:\"" + audioFile.getAbsolutePath() + "\" or \"" + file.getAbsolutePath() + "\" :" + exception);
                }
                if (this.modificationListener != null) {
                    this.modificationListener.fileOperationFinished(file3);
                }
                throw throwable;
            }
        }
    }

    public synchronized void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        randomAccessFile.seek(0L);
        randomAccessFile2.seek(0L);
        this.deleteTag(randomAccessFile, randomAccessFile2);
    }

    protected abstract void deleteTag(RandomAccessFile var1, RandomAccessFile var2) throws CannotWriteException, IOException;

    public synchronized void setAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        this.modificationListener = audioFileModificationListener;
    }

    /*
     * Loose catch block
     */
    public synchronized void write(AudioFile audioFile) throws CannotWriteException {
        block25: {
            if (audioFile.getTag().isEmpty()) {
                this.delete(audioFile);
                return;
            }
            if (!audioFile.canWrite()) {
                throw new CannotWriteException("Can't write to file \"" + audioFile.getAbsolutePath() + "\"");
            }
            if (audioFile.length() <= 150L) {
                throw new CannotWriteException("Less than 150 byte \"" + audioFile.getAbsolutePath() + "\"");
            }
            RandomAccessFile randomAccessFile = null;
            RandomAccessFile randomAccessFile2 = null;
            File file = null;
            boolean bl = false;
            file = File.createTempFile("entagged", ".tmp", audioFile.getParentFile());
            randomAccessFile2 = new RandomAccessFile(file, "rw");
            randomAccessFile = new RandomAccessFile(audioFile, "rw");
            randomAccessFile.seek(0L);
            randomAccessFile2.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(audioFile, false);
                }
                this.writeTag(audioFile.getTag(), randomAccessFile, randomAccessFile2);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(audioFile, file);
                }
            }
            catch (ModifyVetoException modifyVetoException) {
                throw new CannotWriteException(modifyVetoException);
            }
            Object var8_8 = null;
            File file2 = audioFile;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
                if (!bl && file.length() > 0L) {
                    audioFile.delete();
                    file.renameTo(audioFile);
                    file2 = file;
                } else {
                    file.delete();
                }
            }
            catch (Exception exception) {
                System.err.println("AudioFileWriter:165:\"" + audioFile.getAbsolutePath() + "\" or \"" + file.getAbsolutePath() + "\" :" + exception);
            }
            if (this.modificationListener != null) {
                this.modificationListener.fileOperationFinished(file2);
            }
            break block25;
            {
                catch (Exception exception) {
                    bl = true;
                    throw new CannotWriteException("\"" + audioFile.getAbsolutePath() + "\" :" + exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                File file3 = audioFile;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (randomAccessFile2 != null) {
                        randomAccessFile2.close();
                    }
                    if (!bl && file.length() > 0L) {
                        audioFile.delete();
                        file.renameTo(audioFile);
                        file3 = file;
                    } else {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    System.err.println("AudioFileWriter:165:\"" + audioFile.getAbsolutePath() + "\" or \"" + file.getAbsolutePath() + "\" :" + exception);
                }
                if (this.modificationListener != null) {
                    this.modificationListener.fileOperationFinished(file3);
                }
                throw throwable;
            }
        }
    }

    protected abstract void writeTag(Tag var1, RandomAccessFile var2, RandomAccessFile var3) throws CannotWriteException, IOException;
}

