/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import entagged.audioformats.mp3.util.id3frames.TimeId3Frame;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class Id3V2TagConverter {
    private static final HashMap conversion22to23;
    public static final String DATE = "TDAT";
    private static final HashSet discard24;
    public static final String RECORD_DAT = "TRDA";
    private static final HashSet specialStore24;
    public static final String TIME = "TIME";
    public static final String YEAR = "TYER";
    public static final String RECORDING_TIME = "TDRC";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Id3v2Tag convert(Id3v2Tag id3v2Tag, int n) {
        if (!$assertionsDisabled && (id3v2Tag == null || n != Id3v2Tag.ID3V22 && n != Id3v2Tag.ID3V23 && n != Id3v2Tag.ID3V24 || id3v2Tag.getRepresentedVersion() != Id3v2Tag.ID3V22 && id3v2Tag.getRepresentedVersion() != Id3v2Tag.ID3V23 && id3v2Tag.getRepresentedVersion() != Id3v2Tag.ID3V24)) {
            throw new AssertionError();
        }
        Id3v2Tag id3v2Tag2 = null;
        if (n <= id3v2Tag.getRepresentedVersion()) {
            id3v2Tag2 = id3v2Tag;
        } else {
            if (id3v2Tag.getRepresentedVersion() < Id3v2Tag.ID3V23) {
                id3v2Tag2 = Id3V2TagConverter.convert22to23(id3v2Tag);
            }
            if (id3v2Tag.getRepresentedVersion() < Id3v2Tag.ID3V24 && n <= Id3v2Tag.ID3V24) {
                id3v2Tag2 = Id3V2TagConverter.convert23to24(id3v2Tag2);
            }
        }
        if (!$assertionsDisabled && id3v2Tag2 == null) {
            throw new AssertionError();
        }
        return id3v2Tag2;
    }

    private static Id3v2Tag convert22to23(Id3v2Tag id3v2Tag) {
        if (!($assertionsDisabled || id3v2Tag != null && id3v2Tag.getRepresentedVersion() == Id3v2Tag.ID3V22)) {
            throw new AssertionError();
        }
        Iterator iterator = id3v2Tag.getFields();
        while (iterator.hasNext()) {
            String string;
            TagField tagField = (TagField)iterator.next();
            String string2 = tagField.getId();
            if (!string2.equals(string = (String)conversion22to23.get(string2))) continue;
            iterator.remove();
            if (!(tagField instanceof TextId3Frame)) continue;
            id3v2Tag.add(new TextId3Frame(string, ((TextId3Frame)tagField).getContent()));
        }
        id3v2Tag.setRepresentedVersion(Id3v2Tag.ID3V23);
        return id3v2Tag;
    }

    private static Id3v2Tag convert23to24(Id3v2Tag id3v2Tag) {
        TagField tagField;
        if (!($assertionsDisabled || id3v2Tag != null && id3v2Tag.getRepresentedVersion() == Id3v2Tag.ID3V22)) {
            throw new AssertionError();
        }
        Iterator iterator = id3v2Tag.getFields();
        HashMap<String, TagField> hashMap = new HashMap<String, TagField>();
        while (iterator.hasNext()) {
            tagField = (TagField)iterator.next();
            if (specialStore24.contains(tagField.getId())) {
                hashMap.put(tagField.getId(), tagField);
            }
            if (!discard24.contains(tagField.getId())) continue;
            iterator.remove();
        }
        tagField = Id3V2TagConverter.createTimeField((TextId3Frame)hashMap.get(DATE), (TextId3Frame)hashMap.get(TIME), (TextId3Frame)hashMap.get(YEAR));
        id3v2Tag.set(tagField);
        id3v2Tag.setRepresentedVersion(Id3v2Tag.ID3V24);
        return id3v2Tag;
    }

    private static TimeId3Frame createTimeField(TextId3Frame textId3Frame, TextId3Frame textId3Frame2, TextId3Frame textId3Frame3) {
        TimeId3Frame timeId3Frame = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        try {
            if (textId3Frame != null) {
                if (textId3Frame.getContent().length() == 4) {
                    gregorianCalendar.set(5, Integer.parseInt(textId3Frame.getContent().substring(0, 2)));
                    gregorianCalendar.set(2, Integer.parseInt(textId3Frame.getContent().substring(2, 4)) - 1);
                } else {
                    System.err.println("Field TDAT ignroed, since it is not spec conform: \"" + textId3Frame.getContent() + "\"");
                }
            }
            if (textId3Frame2 != null) {
                if (textId3Frame2.getContent().length() == 4) {
                    gregorianCalendar.set(11, Integer.parseInt(textId3Frame2.getContent().substring(0, 2)));
                    gregorianCalendar.set(12, Integer.parseInt(textId3Frame2.getContent().substring(2, 4)));
                } else {
                    System.err.println("Field TIME ignroed, since it is not spec conform: \"" + textId3Frame2.getContent() + "\"");
                }
            }
            if (textId3Frame3 != null) {
                if (textId3Frame3.getContent().length() == 4) {
                    gregorianCalendar.set(1, Integer.parseInt(textId3Frame3.getContent()));
                } else {
                    System.err.println("Field TYER ignroed, since it is not spec conform: \"" + textId3Frame3.getContent() + "\"");
                }
            }
            timeId3Frame = new TimeId3Frame(RECORD_DAT, gregorianCalendar);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Numberformatexception occured in timestamp interpretation, date is set to zero.");
            numberFormatException.printStackTrace();
            gregorianCalendar.clear();
        }
        return timeId3Frame;
    }

    static {
        $assertionsDisabled = !Id3V2TagConverter.class.desiredAssertionStatus();
        conversion22to23 = new HashMap();
        String[] stringArray = new String[]{"BUF", "CNT", "COM", "CRA", "CRM", "ETC", "EQU", "GEO", "IPL", "LNK", "MCI", "MLL", "PIC", "POP", "REV", "RVA", "SLT", "STC", "TAL", "TBP", "TCM", "TCO", "TCR", "TDA", "TDY", "TEN", "TFT", "TIM", "TKE", "TLA", "TLE", "TMT", "TOA", "TOF", "TOL", "TOR", "TOT", "TP1", "TP2", "TP3", "TP4", "TPA", "TPB", "TRC", "TRD", "TRK", "TSI", "TSS", "TT1", "TT2", "TT3", "TXT", "TXX", "TYE", "UFI", "ULT", "WAF", "WAR", "WAS", "WCM", "WCP", "WPB", "WXX"};
        String[] stringArray2 = new String[]{"RBUF", "PCNT", "COMM", "AENC", "", "ETCO", "EQUA", "GEOB", "IPLS", "LINK", "MCDI", "MLLT", "APIC", "POPM", "RVRB", "RVAD", "SYLT", "SYTC", "TALB", "TBPM", "TCOM", "TCON", "TCOP", DATE, "TDLY", "TENC", "TFLT", TIME, "TKEY", "TLAN", "TLEN", "TMED", "TOPE", "TOFN", "TOLY", "TORY", "TOAL", "TPE1", "TPE2", "TPE3", "TPE4", "TPOS", "TPUB", "TSRC", RECORD_DAT, "TRCK", "TSIZ", "TSSE", "TIT1", "TIT2", "TIT3", "TEXT", "TXXX", YEAR, "UFID", "USLT", "WOAF", "WOAR", "WOAS", "WCOM", "WCOP", "WPUB", "WXXX"};
        for (int i = 0; i < stringArray.length; ++i) {
            conversion22to23.put(stringArray[i], stringArray2[i]);
        }
        specialStore24 = new HashSet<String>(Arrays.asList(TIME, YEAR, DATE));
        discard24 = new HashSet<String>(Arrays.asList(RECORD_DAT));
        discard24.addAll(specialStore24);
    }
}

