/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.generic.AudioFileReader;
import entagged.audioformats.generic.GenericTag;
import entagged.audioformats.mp3.Id3v1Tag;
import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.Id3v1TagReader;
import entagged.audioformats.mp3.util.Id3v2TagReader;
import entagged.audioformats.mp3.util.Mp3InfoReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Mp3FileReader
extends AudioFileReader {
    private Mp3InfoReader ir = new Mp3InfoReader();
    private Id3v2TagReader idv2tr = new Id3v2TagReader();
    private Id3v1TagReader idv1tr = new Id3v1TagReader();

    protected EncodingInfo getEncodingInfo(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        return this.ir.read(randomAccessFile);
    }

    protected Tag getTag(RandomAccessFile randomAccessFile) throws IOException {
        String string = "";
        Id3v2Tag id3v2Tag = null;
        Id3v1Tag id3v1Tag = null;
        try {
            id3v2Tag = this.idv2tr.read(randomAccessFile);
        }
        catch (CannotReadException cannotReadException) {
            id3v2Tag = null;
            string = string + "(" + cannotReadException.getMessage() + ")";
        }
        try {
            id3v1Tag = this.idv1tr.read(randomAccessFile);
        }
        catch (CannotReadException cannotReadException) {
            id3v1Tag = null;
            string = string + "(" + cannotReadException.getMessage() + ")";
        }
        if (id3v1Tag == null && id3v2Tag == null) {
            return new GenericTag();
        }
        if (id3v2Tag == null) {
            return id3v1Tag;
        }
        if (id3v1Tag != null) {
            id3v2Tag.merge(id3v1Tag);
            id3v2Tag.hasId3v1(true);
        }
        return id3v2Tag;
    }
}

