/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.Tag;
import entagged.audioformats.generic.AbstractTagCreator;
import entagged.audioformats.mp3.Id3v2Tag;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class Id3v2TagCreator
extends AbstractTagCreator {
    public static final int DEFAULT_PADDING = 4000;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static byte[] getSyncSafe(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n >> (3 - i) * 7 & 0x7F);
        }
        if (!($assertionsDisabled || (byArray[0] & 0x80) == 0 && (byArray[1] & 0x80) == 0 && (byArray[2] & 0x80) == 0 && (byArray[3] & 0x80) == 0)) {
            throw new AssertionError();
        }
        return byArray;
    }

    public void create(Tag tag, ByteBuffer byteBuffer, List list, int n, int n2) {
        byteBuffer.put((byte)73).put((byte)68).put((byte)51);
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)0);
        boolean[] blArray = new boolean[]{false, false, false, false};
        byteBuffer.put(this.createID3Flags(blArray));
        int n3 = n - 10 + n2;
        byteBuffer.put(Id3v2TagCreator.getSyncSafe(n3));
        if (blArray[1]) {
            // empty if block
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byteBuffer.put((byte[])iterator.next());
        }
        for (int i = 0; i < n2; ++i) {
            byteBuffer.put((byte)0);
        }
    }

    private byte createID3Flags(boolean[] blArray) {
        byte by = 0;
        if (blArray[0]) {
            by = (byte)(by + 128);
        }
        if (blArray[1]) {
            by = (byte)(by + 64);
        }
        if (blArray[2]) {
            by = (byte)(by + 32);
        }
        if (blArray[3]) {
            by = (byte)(by + 16);
        }
        return by;
    }

    protected Tag getCompatibleTag(Tag tag) {
        if (!(tag instanceof Id3v2Tag)) {
            Id3v2Tag id3v2Tag = new Id3v2Tag();
            id3v2Tag.merge(tag);
            return id3v2Tag;
        }
        return tag;
    }

    protected int getFixedTagLength(Tag tag) {
        return 10;
    }

    static {
        $assertionsDisabled = !Id3v2TagCreator.class.desiredAssertionStatus();
    }
}

