/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.mp3.util.LameMPEGFrame;
import entagged.audioformats.mp3.util.MPEGFrame;
import entagged.audioformats.mp3.util.VBRIMPEGFrame;
import entagged.audioformats.mp3.util.VbrInfoFrame;
import entagged.audioformats.mp3.util.XingMPEGFrame;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Mp3InfoReader {
    public EncodingInfo read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        double d;
        byte[] byArray;
        EncodingInfo encodingInfo = new EncodingInfo();
        if (randomAccessFile.length() == 0L) {
            System.err.println("Error: File empty");
            throw new CannotReadException("File is empty");
        }
        int n = 0;
        randomAccessFile.seek(0L);
        byte[] byArray2 = new byte[3];
        randomAccessFile.read(byArray2);
        randomAccessFile.seek(0L);
        String string = new String(byArray2);
        if (string.equals("ID3")) {
            randomAccessFile.seek(6L);
            n = this.read_syncsafe_integer(randomAccessFile);
            randomAccessFile.seek(n + 10);
        }
        MPEGFrame mPEGFrame = null;
        byte[] byArray3 = new byte[4];
        randomAccessFile.read(byArray3);
        while (((byArray3[0] & 0xFF) != 255 || (byArray3[1] & 0xE0) != 224 || (byArray3[1] & 6) == 0 || (byArray3[2] & 0xF0) == 240 || (byArray3[2] & 0xC) == 12) && randomAccessFile.getFilePointer() < randomAccessFile.length() - 4L) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 3L);
            randomAccessFile.read(byArray3);
        }
        mPEGFrame = new MPEGFrame(byArray3);
        if (mPEGFrame == null || !mPEGFrame.isValid() || mPEGFrame.getSamplingRate() == 0) {
            throw new CannotReadException("Error: could not synchronize to first mp3 frame");
        }
        int n2 = mPEGFrame.getFrameLength();
        int n3 = 0;
        if (mPEGFrame.getMPEGVersion() == 3 && mPEGFrame.getChannelMode() == 3) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + 17L);
            n3 += 17;
        } else if (mPEGFrame.getMPEGVersion() == 3) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + 32L);
            n3 += 32;
        } else if (mPEGFrame.getMPEGVersion() == 2 && mPEGFrame.getChannelMode() == 3) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + 9L);
            n3 += 9;
        } else if (mPEGFrame.getMPEGVersion() == 2) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + 17L);
            n3 += 17;
        }
        int n4 = 0;
        byte[] byArray4 = new byte[16];
        randomAccessFile.read(byArray4);
        randomAccessFile.seek(randomAccessFile.getFilePointer() + 100L);
        byte[] byArray5 = new byte[4];
        randomAccessFile.read(byArray5);
        VbrInfoFrame vbrInfoFrame = new XingMPEGFrame(byArray4, byArray5);
        if (vbrInfoFrame.isValid()) {
            n4 += 120;
            byArray = new byte[36];
            randomAccessFile.read(byArray);
            LameMPEGFrame lameMPEGFrame = new LameMPEGFrame(byArray);
            if (!lameMPEGFrame.isValid()) {
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 36L);
            } else {
                n4 += 36;
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)n2 - (long)(n3 + n4 + 4));
        } else {
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 120L - (long)n3 + 32L);
            byArray = new byte[18];
            randomAccessFile.read(byArray);
            vbrInfoFrame = new VBRIMPEGFrame(byArray);
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 18L - 4L);
        }
        double d2 = (double)mPEGFrame.getSampleNumber() / (double)mPEGFrame.getSamplingRate();
        if (vbrInfoFrame.isValid()) {
            d = d2 * (double)vbrInfoFrame.getFrameCount();
            encodingInfo.setVbr(vbrInfoFrame.isVbr());
            int n5 = vbrInfoFrame.getFileSize();
            encodingInfo.setBitrate((int)((double)((n5 == 0 ? randomAccessFile.length() - (long)n : (long)n5) * 8L) / (d2 * (double)vbrInfoFrame.getFrameCount() * 1000.0)));
        } else {
            int n6 = mPEGFrame.getFrameLength();
            if (n6 == 0) {
                throw new CannotReadException("Error while reading header(maybe file is corrupted, or missing first mpeg frame before xing header)");
            }
            d = d2 * (double)((randomAccessFile.length() - (long)n) / (long)n6);
            encodingInfo.setVbr(false);
            encodingInfo.setBitrate(mPEGFrame.getBitrate());
        }
        encodingInfo.setPreciseLength((float)d);
        encodingInfo.setChannelNumber(mPEGFrame.getChannelNumber());
        encodingInfo.setSamplingRate(mPEGFrame.getSamplingRate());
        encodingInfo.setEncodingType(mPEGFrame.MPEGVersionToString(mPEGFrame.getMPEGVersion()) + " || " + mPEGFrame.layerToString(mPEGFrame.getLayerVersion()));
        encodingInfo.setExtraEncodingInfos("");
        return encodingInfo;
    }

    private int read_syncsafe_integer(RandomAccessFile randomAccessFile) throws IOException {
        int n = 0;
        n += (randomAccessFile.read() & 0xFF) << 21;
        n += (randomAccessFile.read() & 0xFF) << 14;
        n += (randomAccessFile.read() & 0xFF) << 7;
        return n += randomAccessFile.read() & 0xFF;
    }
}

