/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util.id3frames;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class CommId3Frame
extends TextId3Frame
implements TagTextField {
    private String shortDesc;
    private String lang;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CommId3Frame(String string) {
        super("COMM", string);
        this.shortDesc = "";
        this.lang = Locale.getDefault().getISO3Language();
    }

    public CommId3Frame(byte[] byArray, byte by) throws UnsupportedEncodingException {
        super("COMM", byArray, by);
    }

    public String getLangage() {
        return this.lang;
    }

    protected void populate(byte[] byArray) throws UnsupportedEncodingException {
        this.encoding = byArray[this.flags.length];
        if (this.flags.length + 1 + 3 > byArray.length - 1) {
            this.lang = "XXX";
            this.content = "";
            this.shortDesc = "";
            return;
        }
        this.lang = new String(byArray, this.flags.length + 1, 3);
        int n = this.getCommentStart(byArray, this.flags.length + 4, this.getEncoding());
        this.shortDesc = this.getString(byArray, this.flags.length + 4, n - this.flags.length - 4, this.getEncoding());
        this.content = this.getString(byArray, n, byArray.length - n, this.getEncoding());
        if (!($assertionsDisabled || this.lang != null && this.shortDesc != null && this.content != null)) {
            throw new AssertionError();
        }
    }

    public int getCommentStart(byte[] byArray, int n, String string) {
        int n2 = 0;
        if ("UTF-16".equals(string)) {
            for (n2 = n; n2 < byArray.length; n2 += 2) {
                if (byArray[n2] != 0 || byArray[n2 + 1] != 0) continue;
                n2 += 2;
                break;
            }
        } else {
            for (n2 = n; n2 < byArray.length; ++n2) {
                if (byArray[n2] != 0) continue;
                ++n2;
                break;
            }
        }
        return n2;
    }

    protected byte[] build() throws UnsupportedEncodingException {
        byte[] byArray = this.getBytes(this.shortDesc, this.getEncoding());
        byte[] byArray2 = this.getBytes(this.content, this.getEncoding());
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byte[] byArray4 = this.lang.getBytes();
        byte[] byArray5 = new byte[8 + this.flags.length + 1 + 3 + byArray3.length];
        int n = 0;
        this.copy(this.getIdBytes(), byArray5, n);
        this.copy(this.getSize(byArray5.length - 10), byArray5, n += 4);
        this.copy(this.flags, byArray5, n += 4);
        byArray5[n += this.flags.length] = this.encoding;
        this.copy(byArray4, byArray5, ++n);
        this.copy(byArray3, byArray5, n += byArray4.length);
        return byArray5;
    }

    public String getShortDescription() {
        return this.shortDesc;
    }

    public boolean isEmpty() {
        return this.content.equals("") && this.shortDesc.equals("");
    }

    public void copyContent(TagField tagField) {
        super.copyContent(tagField);
        if (tagField instanceof CommId3Frame) {
            this.shortDesc = ((CommId3Frame)tagField).getShortDescription();
            this.lang = ((CommId3Frame)tagField).getLangage();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getLangage()).append("] ").append("(").append(this.getShortDescription()).append(") ").append(this.getContent());
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !CommId3Frame.class.desiredAssertionStatus();
    }
}

