/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util.id3frames;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.mp3.util.id3frames.Id3Frame;
import java.io.UnsupportedEncodingException;

public class GenericId3Frame
extends Id3Frame {
    private byte[] data;
    private String id;

    public GenericId3Frame(String string, byte[] byArray, byte by) throws UnsupportedEncodingException {
        super(byArray, by);
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public boolean isBinary() {
        return true;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isCommon() {
        return false;
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof GenericId3Frame) {
            this.data = ((GenericId3Frame)tagField).getData();
        }
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    protected void populate(byte[] byArray) {
        this.data = new byte[byArray.length - this.flags.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = byArray[i + this.flags.length];
        }
    }

    protected byte[] build() {
        byte[] byArray = new byte[8 + this.data.length + this.flags.length];
        int n = 0;
        this.copy(this.getIdBytes(), byArray, n);
        this.copy(this.getSize(byArray.length - 10), byArray, n += 4);
        this.copy(this.flags, byArray, n += 4);
        this.copy(this.data, byArray, n += this.flags.length);
        return byArray;
    }

    public String toString() {
        return this.id + " : No associated view";
    }
}

