/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mpc.util;

import entagged.audioformats.generic.Utils;

public class MpcHeader {
    byte[] b;

    public MpcHeader(byte[] byArray) {
        this.b = byArray;
    }

    public int getSamplesNumber() {
        if (this.b[0] == 7) {
            return Utils.getNumber(this.b, 1, 4);
        }
        return -1;
    }

    public int getSamplingRate() {
        if (this.b[0] == 7) {
            switch (this.b[6] & 2) {
                case 0: {
                    return 44100;
                }
                case 1: {
                    return 48000;
                }
                case 2: {
                    return 37800;
                }
                case 3: {
                    return 32000;
                }
            }
            return -1;
        }
        return -1;
    }

    public int getChannelNumber() {
        if (this.b[0] == 7) {
            return 2;
        }
        return 2;
    }

    public String getEncodingType() {
        StringBuffer stringBuffer = new StringBuffer().append("MPEGplus (MPC)");
        if (this.b[0] == 7) {
            stringBuffer.append(" rev.7, Profile:");
            switch ((this.b[7] & 0xF0) >> 4) {
                case 0: {
                    stringBuffer.append("No profile");
                    break;
                }
                case 1: {
                    stringBuffer.append("Unstable/Experimental");
                    break;
                }
                case 2: {
                    stringBuffer.append("Unused");
                    break;
                }
                case 3: {
                    stringBuffer.append("Unused");
                    break;
                }
                case 4: {
                    stringBuffer.append("Unused");
                    break;
                }
                case 5: {
                    stringBuffer.append("Below Telephone (q= 0.0)");
                    break;
                }
                case 6: {
                    stringBuffer.append("Below Telephone (q= 1.0)");
                    break;
                }
                case 7: {
                    stringBuffer.append("Telephone (q= 2.0)");
                    break;
                }
                case 8: {
                    stringBuffer.append("Thumb (q= 3.0)");
                    break;
                }
                case 9: {
                    stringBuffer.append("Radio (q= 4.0)");
                    break;
                }
                case 10: {
                    stringBuffer.append("Standard (q= 5.0)");
                    break;
                }
                case 11: {
                    stringBuffer.append("Xtreme (q= 6.0)");
                    break;
                }
                case 12: {
                    stringBuffer.append("Insane (q= 7.0)");
                    break;
                }
                case 13: {
                    stringBuffer.append("BrainDead (q= 8.0)");
                    break;
                }
                case 14: {
                    stringBuffer.append("Above BrainDead (q= 9.0)");
                    break;
                }
                case 15: {
                    stringBuffer.append("Above BrainDead (q=10.0)");
                    break;
                }
                default: {
                    stringBuffer.append("No profile");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getEncoderInfo() {
        byte by = this.b[24];
        StringBuffer stringBuffer = new StringBuffer().append("Mpc encoder v").append((double)by / 100.0).append(" ");
        if (by % 10 == 0) {
            stringBuffer.append("Release");
        } else if (by % 2 == 0) {
            stringBuffer.append("Beta");
        } else if (by % 2 == 1) {
            stringBuffer.append("Alpha");
        }
        return stringBuffer.toString();
    }
}

