/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

import entagged.audioformats.Tag;
import entagged.audioformats.generic.AbstractTagCreator;
import entagged.audioformats.generic.Utils;
import entagged.audioformats.ogg.OggTag;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class OggTagCreator
extends AbstractTagCreator {
    public void create(Tag tag, ByteBuffer byteBuffer, List list, int n, int n2) throws UnsupportedEncodingException {
        String string = ((OggTag)tag).getVendor();
        int n3 = Utils.getUTF8Bytes(string).length;
        byteBuffer.put(new byte[]{(byte)(n3 & 0xFF), (byte)((n3 & 0xFF00) >> 8), (byte)((n3 & 0xFF0000) >> 16), (byte)((n3 & 0xFF000000) >> 24)});
        byteBuffer.put(Utils.getUTF8Bytes(string));
        int n4 = list.size();
        byte[] byArray = new byte[4];
        byArray[3] = (byte)((n4 & 0xFF000000) >> 24);
        byArray[2] = (byte)((n4 & 0xFF0000) >> 16);
        byArray[1] = (byte)((n4 & 0xFF00) >> 8);
        byArray[0] = (byte)(n4 & 0xFF);
        byteBuffer.put(byArray);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byteBuffer.put((byte[])iterator.next());
        }
    }

    protected Tag getCompatibleTag(Tag tag) {
        if (!(tag instanceof OggTag)) {
            OggTag oggTag = new OggTag();
            oggTag.merge(tag);
            return oggTag;
        }
        return tag;
    }

    protected int getFixedTagLength(Tag tag) throws UnsupportedEncodingException {
        return 8 + Utils.getUTF8Bytes(((OggTag)tag).getVendor()).length;
    }
}

