/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.Plugin;
import net.sf.jmp3renamer.Translatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslatablePlugin
implements Translatable,
Plugin {
    protected static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$AbstractTranslatablePlugin == null ? (class$net$sf$jmp3renamer$AbstractTranslatablePlugin = AbstractTranslatablePlugin.class$("net.sf.jmp3renamer.AbstractTranslatablePlugin")) : class$net$sf$jmp3renamer$AbstractTranslatablePlugin);
    private File file;
    protected Properties lang = new Properties();
    static /* synthetic */ Class class$net$sf$jmp3renamer$AbstractTranslatablePlugin;

    public Properties getLanguageTable(String locale) throws IOException {
        Properties lang = new Properties();
        this.loadLanguageFromJar(lang, locale);
        this.loadlLanguageFromFile(lang, locale);
        return lang;
    }

    public void initLanguage() {
        try {
            this.loadLanguageFromJar(this.lang, Locale.ENGLISH.getLanguage());
        }
        catch (IOException e) {
            logger.error(I18N.translate("error.load_default_language"), e);
        }
    }

    public void loadLanguage() {
        this.initLanguage();
        Properties english = (Properties)this.lang.clone();
        String language = Main.getProperty("lang");
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        try {
            this.loadLanguageFromJar(this.lang, language);
        }
        catch (Exception e) {
            logger.warn(I18N.translate("error.load_language_jar", new String[]{this.getName()}), e);
        }
        try {
            this.loadlLanguageFromFile(this.lang, language);
        }
        catch (IOException e) {
            logger.warn(I18N.translate("error.load_language_file", new String[]{this.getName()}), e);
        }
        I18N.registerLanguageTable(this.lang, language);
        I18N.registerLanguageTable(english, "en");
    }

    public void loadLanguageFromJar(Properties lang, String locale) throws IOException {
        String internalName = this.getClass().getName();
        internalName = internalName.substring(internalName.lastIndexOf(".") + 1);
        internalName = internalName + "_" + locale + ".properties";
        InputStream is = this.getClass().getResourceAsStream("lang/" + internalName);
        if (is != null) {
            lang.load(is);
        }
    }

    public void loadlLanguageFromFile(Properties lang, String locale) throws IOException {
        String dirString = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "lang";
        String internalName = this.getClass().getName();
        internalName = internalName.substring(internalName.lastIndexOf(".") + 1);
        File file = new File(dirString, internalName = internalName + "_" + locale + ".properties");
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            lang.load(fis);
        }
    }

    public abstract String getName();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

