/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.gui.DataPanel;

class DatasetTable
extends JTable {
    public static final int TITLE_ROW = 0;
    public static final int ARTIST_ROW = 1;
    public static final int ALBUM_ROW = 2;
    public static final int TRACK_ROW = 3;
    public static final int YEAR_ROW = 4;
    public static final int GENRE_ROW = 5;
    public static final int COMPOSER_ROW = 6;
    public static final int ORIG_ARTIST_ROW = 7;
    public static final int COPYRIGHT_ROW = 8;
    public static final int URL_ROW = 9;
    public static final int COMMENT_ROW = 10;
    public static final int ENCODED_BY_ROW = 11;
    public static final int PART_OF_SET_ROW = 12;
    public static final int COMPILATION_ROW = 13;
    public static final int ID_ROW = 14;
    public final String I18N_TITLE = I18N.translate("title");
    public final String I18N_ARTIST = I18N.translate("artist");
    public final String I18N_ALBUM = I18N.translate("album");
    public final String I18N_TRACK = I18N.translate("track");
    public final String I18N_YEAR = I18N.translate("year");
    public final String I18N_GENRE = I18N.translate("genre");
    public final String I18N_COMPOSER = I18N.translate("composer");
    public final String I18N_ORIG_ARTIST = I18N.translate("orig_artist");
    public final String I18N_COPYRIGHT = I18N.translate("copyright");
    public final String I18N_COMMENT = I18N.translate("comment");
    public final String I18N_ENCODED_BY = I18N.translate("encoded_by");
    public final String I18N_PART_OF_SET = I18N.translate("part_of_set");
    public final String I18N_COMPILATION = I18N.translate("compilation");
    private DefaultTableModel model;
    private boolean ignoreTableEvent = false;
    private DefaultCellEditor cbEditor = new DefaultCellEditor(new JCheckBox());
    private DefaultCellEditor defaultEditor = new DefaultCellEditor(new JTextField());

    DatasetTable(DataPanel datapanel) {
        this.model = new DefaultTableModel(new Object[0][], new String[]{I18N.translate("attribute"), I18N.translate("value")});
        this.model.addTableModelListener(datapanel);
        this.setModel(this.model);
        this.setSurrendersFocusOnKeystroke(true);
        this.getColumnModel().getColumn(1).setCellRenderer(new DatasetTableCellRenderer());
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0 && row < 14;
    }

    public TableCellEditor getCellEditor(int row, int col) {
        if (row == 13 && col == 1) {
            return this.cbEditor;
        }
        return this.defaultEditor;
    }

    protected void showDataset(final DataSet dataset) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DatasetTable.this.ignoreTableEvent = true;
                DatasetTable.this.model.setRowCount(0);
                for (int i = 0; i <= 14; ++i) {
                    DatasetTable.this.model.addRow(new Object[]{"", ""});
                }
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_TITLE, 0, 0);
                DatasetTable.this.model.setValueAt(dataset.getTitle(), 0, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_ARTIST, 1, 0);
                DatasetTable.this.model.setValueAt(dataset.getArtist(), 1, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_ALBUM, 2, 0);
                DatasetTable.this.model.setValueAt(dataset.getAlbum(), 2, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_TRACK, 3, 0);
                DatasetTable.this.model.setValueAt(dataset.getTrack(), 3, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_YEAR, 4, 0);
                DatasetTable.this.model.setValueAt(dataset.getYear(), 4, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_GENRE, 5, 0);
                DatasetTable.this.model.setValueAt(dataset.getGenre(), 5, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_COMPOSER, 6, 0);
                DatasetTable.this.model.setValueAt(dataset.getComposer(), 6, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_ORIG_ARTIST, 7, 0);
                DatasetTable.this.model.setValueAt(dataset.getOrigArtist(), 7, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_COPYRIGHT, 8, 0);
                DatasetTable.this.model.setValueAt(dataset.getCopyright(), 8, 1);
                DatasetTable.this.model.setValueAt("URL", 9, 0);
                DatasetTable.this.model.setValueAt(dataset.getUrl(), 9, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_COMMENT, 10, 0);
                DatasetTable.this.model.setValueAt(dataset.getComment(), 10, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_ENCODED_BY, 11, 0);
                DatasetTable.this.model.setValueAt(dataset.getEncodedBy(), 11, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_PART_OF_SET, 12, 0);
                DatasetTable.this.model.setValueAt(dataset.getPartOfSet(), 12, 1);
                DatasetTable.this.model.setValueAt(DatasetTable.this.I18N_COMPILATION, 13, 0);
                DatasetTable.this.model.setValueAt(new Boolean(dataset.isPartOfCompilation()), 13, 1);
                DatasetTable.this.model.setValueAt("ID", 14, 0);
                DatasetTable.this.model.setValueAt(new Integer(dataset.getId()), 14, 1);
                DatasetTable.this.ignoreTableEvent = false;
            }
        });
    }

    protected boolean getIgnoreTableEvent() {
        return this.ignoreTableEvent;
    }

    private class DatasetTableCellRenderer
    extends DefaultTableCellRenderer {
        private JCheckBox checkBox = new JCheckBox();

        private DatasetTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.checkBox.setSelected((Boolean)value);
                this.checkBox.setOpaque(false);
                return this.checkBox;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

