/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.ImageLoader;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.gui.MainGUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HelpDialog
extends JFrame
implements HyperlinkListener {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$gui$HelpDialog == null ? (class$net$sf$jmp3renamer$gui$HelpDialog = HelpDialog.class$("net.sf.jmp3renamer.gui.HelpDialog")) : class$net$sf$jmp3renamer$gui$HelpDialog);
    private JEditorPane view;
    private JScrollPane scroll_view;
    private JEditorPane navi;
    private JScrollPane scroll_navi;
    private JSplitPane splitpane = new JSplitPane();
    static /* synthetic */ Class class$net$sf$jmp3renamer$gui$HelpDialog;

    HelpDialog(MainGUI parent) {
        try {
            ImageIcon icon = ImageLoader.getInstance().loadImage("images/help.png");
            this.setIconImage(icon.getImage());
            Class<?> c = this.getClass();
            URL url = c.getResource("help/" + Main.getProperty("lang") + "/welcome.html");
            try {
                this.view = new JEditorPane(url);
            }
            catch (IOException ioe) {
                logger.warn(I18N.translate("error.localized_file_not_found"));
                url = c.getResource("help/en/welcome.html");
                this.view = new JEditorPane(url);
            }
            this.view.setEditable(false);
            this.view.setContentType("text/html");
            this.view.addHyperlinkListener(this);
            url = c.getResource("help/" + Main.getProperty("lang") + "/topics.html");
            try {
                this.navi = new JEditorPane(url);
            }
            catch (IOException ioe) {
                logger.warn(I18N.translate("error.localized_file_not_found"));
                url = c.getResource("help/en/topics.html");
                this.navi = new JEditorPane(url);
            }
            this.navi.setEditable(false);
            this.navi.setContentType("text/html");
            this.navi.addHyperlinkListener(this);
            this.scroll_view = new JScrollPane(this.view);
            this.scroll_view.getVerticalScrollBar().setUnitIncrement(10);
            this.scroll_navi = new JScrollPane(this.navi);
            this.scroll_navi.getVerticalScrollBar().setUnitIncrement(10);
            this.splitpane.setLeftComponent(this.scroll_navi);
            this.splitpane.setRightComponent(this.scroll_view);
            this.splitpane.setDividerSize(5);
            this.splitpane.setDividerLocation(200);
            this.getContentPane().add(this.splitpane);
            this.setSize(parent.getSize());
            this.setLocation(parent.getLocation());
            this.setTitle("JMP3Renamer " + I18N.translate("help"));
            this.setVisible(true);
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.create_dialog"), e);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.view.setPage(event.getURL());
            }
            catch (Exception e) {
                logger.error(I18N.translate("error.loading_page"), e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

