/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.Plugin;
import net.sf.jmp3renamer.PluginList;
import net.sf.jmp3renamer.PluginLoader;
import net.sf.jmp3renamer.gui.MainGUI;
import net.sf.jmp3renamer.util.PluginComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginManager
extends JDialog
implements ActionListener,
ListSelectionListener {
    private Vector pluginListEntries = new Vector();
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$gui$PluginManager == null ? (class$net$sf$jmp3renamer$gui$PluginManager = PluginManager.class$("net.sf.jmp3renamer.gui.PluginManager")) : class$net$sf$jmp3renamer$gui$PluginManager);
    private final String SERVER_URL = Main.getProperty("pluginmanager.url");
    private MainGUI gui;
    public boolean downloadCanceled = false;
    private JTabbedPane tabbedpane = new JTabbedPane();
    private JPanel buttonPanel = new JPanel();
    private JButton bOk = new JButton(I18N.translate("ok"));
    private JPanel descriptionPanel = new JPanel();
    private JLabel lName = new JLabel();
    private JLabel lAuthor = new JLabel();
    private JLabel lVersion = new JLabel();
    private JLabel lStatus = new JLabel();
    private JTextArea taDescription = new JTextArea();
    private JPanel installedPlugins = new JPanel();
    private DefaultListModel installedModel = new DefaultListModel();
    private JList installedList = new JList(this.installedModel);
    private JButton bUpdate = new JButton(I18N.translate("update"));
    private JButton bRemove = new JButton(I18N.translate("remove"));
    private JPanel availablePlugins = new JPanel();
    private DefaultListModel availableModel = new DefaultListModel();
    private JList availableList = new JList(this.availableModel);
    private JButton bInstall = new JButton(I18N.translate("install"));
    static /* synthetic */ Class class$net$sf$jmp3renamer$gui$PluginManager;

    PluginManager(MainGUI gui) {
        super((Frame)gui, false);
        this.gui = gui;
        this.initGUI();
        this.updateInstalledList();
        gui.setCursor(new Cursor(0));
    }

    public void getList() {
        logger.info(I18N.translate("info.loading_plugin_list"), (Object)this.SERVER_URL);
        try {
            URL[] url = new URL[]{new URL(this.SERVER_URL)};
            URLClassLoader ucl = new URLClassLoader(url);
            Class<?> c = ucl.loadClass("List");
            PluginList l = (PluginList)c.newInstance();
            String[][] list = l.getList();
            for (int i = 0; i < list.length; ++i) {
                PluginListEntry entry = new PluginListEntry(list[i]);
                this.pluginListEntries.addElement(entry);
            }
            Collections.sort(this.pluginListEntries, new PluginListEntryComparator());
            this.updateAvailableList();
            this.bInstall.setEnabled(true);
        }
        catch (UnsupportedClassVersionError error) {
            logger.error(I18N.translate("error.class_version"));
        }
        catch (Throwable t) {
            logger.error(I18N.translate("error.load_list"), t);
        }
    }

    private void initGUI() {
        this.getContentPane().setLayout(null);
        this.tabbedpane.addTab(I18N.translate("installed"), this.installedPlugins);
        this.tabbedpane.addTab(I18N.translate("available"), this.availablePlugins);
        this.tabbedpane.setBounds(10, 10, 190, 370);
        this.getContentPane().add(this.tabbedpane);
        this.installedPlugins.setLayout(new GridBagLayout());
        JScrollPane s = new JScrollPane(this.installedList);
        this.installedPlugins.add((Component)s, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.9, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bUpdate.addActionListener(this);
        this.installedPlugins.add((Component)this.bUpdate, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.bRemove.addActionListener(this);
        this.installedPlugins.add((Component)this.bRemove, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.installedList.addListSelectionListener(this);
        this.availablePlugins.setLayout(new GridBagLayout());
        JScrollPane t = new JScrollPane(this.availableList);
        t.setPreferredSize(new Dimension(150, 250));
        this.availablePlugins.add((Component)t, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.9, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bInstall.addActionListener(this);
        this.bInstall.setEnabled(false);
        this.availablePlugins.add((Component)this.bInstall, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.availableList.addListSelectionListener(this);
        this.availableModel.addElement(I18N.translate("downloading_plugins"));
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder(I18N.translate("description")));
        this.descriptionPanel.setLayout(null);
        JLabel name = new JLabel(I18N.translate("name"));
        name.setBounds(20, 20, 70, 25);
        this.descriptionPanel.add(name);
        this.lName.setBounds(80, 20, 300, 25);
        this.descriptionPanel.add(this.lName);
        JLabel author = new JLabel(I18N.translate("author"));
        author.setBounds(20, 50, 70, 25);
        this.descriptionPanel.add(author);
        this.lAuthor.setBounds(80, 50, 300, 25);
        this.descriptionPanel.add(this.lAuthor);
        JLabel version = new JLabel(I18N.translate("version"));
        version.setBounds(20, 80, 70, 25);
        this.descriptionPanel.add(version);
        this.lVersion.setBounds(80, 80, 300, 25);
        this.descriptionPanel.add(this.lVersion);
        JLabel status = new JLabel(I18N.translate("status"));
        status.setBounds(20, 110, 70, 25);
        this.descriptionPanel.add(status);
        this.lStatus.setBounds(80, 110, 300, 25);
        this.descriptionPanel.add(this.lStatus);
        JLabel description = new JLabel(I18N.translate("description") + ":");
        description.setBounds(20, 140, 200, 25);
        this.descriptionPanel.add(description);
        this.taDescription.setRows(10);
        this.taDescription.setLineWrap(true);
        this.taDescription.setWrapStyleWord(true);
        this.taDescription.setEditable(false);
        JScrollPane scrollpane = new JScrollPane(this.taDescription);
        scrollpane.setBounds(20, 165, 335, 197);
        this.descriptionPanel.add(scrollpane);
        this.descriptionPanel.setBounds(210, 10, 370, 372);
        this.getContentPane().add(this.descriptionPanel);
        this.bOk.addActionListener(this);
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.bOk);
        this.buttonPanel.setBounds(10, 385, 580, 35);
        this.getContentPane().add(this.buttonPanel);
        this.setSize(600, 450);
        int par_x = (int)this.gui.getLocation().getX();
        int par_y = (int)this.gui.getLocation().getY();
        int par_width = this.gui.getWidth();
        int par_height = this.gui.getHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        int x = (par_width - width) / 2 + par_x;
        int y = (par_height - height) / 2 + par_y;
        this.setLocation(new Point(x, y));
        this.setTitle("JMP3Renamer " + I18N.translate("plugins"));
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.dispose();
            Main.getGUI().repaint();
        } else if (e.getSource() == this.bUpdate) {
            int[] indices = this.installedList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            Vector<PluginListEntry> entries = new Vector<PluginListEntry>();
            Vector<Plugin> plugins = new Vector<Plugin>();
            File dir = PluginLoader.getInstance().getPluginDirs()[0];
            String path = dir.getAbsolutePath();
            for (int i = 0; i < indices.length; ++i) {
                Plugin plugin = (Plugin)this.installedModel.getElementAt(indices[i]);
                if (!this.checkStatus(plugin).startsWith(I18N.translate("update_available"))) continue;
                plugins.add(plugin);
                String file = plugin.getClass().getName();
                file = file.substring(file.lastIndexOf(".") + 1, file.length());
                file = file + ".jar";
                String f = path + File.separator + file;
                File pluginfile = new File(f);
                long size = pluginfile.length();
                String[] temp = new String[]{"", "", "", "", Long.toString(size), file};
                PluginListEntry entry = new PluginListEntry(temp);
                entries.add(entry);
            }
            File temp = new File(PluginLoader.getInstance().getPluginDirs()[0], "temp_update");
            new PluginDownloader(this, entries, temp);
            if (!this.downloadCanceled) {
                Enumeration en = plugins.elements();
                while (en.hasMoreElements()) {
                    Plugin current = (Plugin)en.nextElement();
                    String file = current.getClass().getName();
                    file = file.substring(file.lastIndexOf(".") + 1, file.length());
                    if (!PluginLoader.getInstance().unloadPlugin(file)) continue;
                    file = file + ".jar";
                    String f = path + File.separator + file;
                    File currentfile = new File(f);
                    currentfile.delete();
                }
                File[] files = temp.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File newfile = new File(files[i].getParentFile().getParentFile(), files[i].getName());
                    files[i].renameTo(newfile);
                }
                temp.delete();
                en = plugins.elements();
                while (en.hasMoreElements()) {
                    Plugin current = (Plugin)en.nextElement();
                    String file = current.getClass().getName();
                    file = file.substring(file.lastIndexOf(".") + 1, file.length());
                    file = file + ".jar";
                    String f = path + File.separator + file;
                    File currentfile = new File(f);
                    Plugin plug = PluginLoader.getInstance().loadPlugin(currentfile);
                    if (plug == null) continue;
                    plug.coreStarted();
                }
                this.installedModel.removeAllElements();
                Vector p = PluginLoader.getInstance().getPlugins();
                Enumeration enumeration = p.elements();
                while (enumeration.hasMoreElements()) {
                    this.installedModel.addElement(enumeration.nextElement());
                }
                JOptionPane.showMessageDialog(Main.getGUI(), I18N.translate("plugins_updated"), "PluginManager", 1);
            }
        } else if (e.getSource() == this.bRemove) {
            int[] indices = this.installedList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            Vector<Plugin> plugins = new Vector<Plugin>();
            try {
                Plugin plugin;
                for (int i = 0; i < indices.length; ++i) {
                    plugin = (Plugin)this.installedModel.getElementAt(indices[i]);
                    plugins.addElement(plugin);
                }
                Enumeration en = plugins.elements();
                while (en.hasMoreElements()) {
                    plugin = (Plugin)en.nextElement();
                    String file = plugin.getClass().getName();
                    file = file.substring(file.lastIndexOf(".") + 1, file.length());
                    if (!PluginLoader.getInstance().unloadPlugin(file)) continue;
                    File current = plugin.getFile();
                    current.delete();
                    this.installedModel.removeElement(plugin);
                }
                this.availableModel.removeAllElements();
                Enumeration enumeration = this.pluginListEntries.elements();
                while (enumeration.hasMoreElements()) {
                    PluginListEntry entry = (PluginListEntry)enumeration.nextElement();
                    if (this.isInstalled(entry)) continue;
                    this.availableModel.addElement(entry);
                }
            }
            catch (Exception ex) {
                logger.error(I18N.translate("error.uninstall_plugins"), ex);
            }
            JOptionPane.showMessageDialog(Main.getGUI(), I18N.translate("plugins_removed"), "PluginManager", 1);
        } else if (e.getSource() == this.bInstall) {
            int[] indices = this.availableList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            Vector<PluginListEntry> entries = new Vector<PluginListEntry>();
            for (int i = 0; i < indices.length; ++i) {
                PluginListEntry entry = (PluginListEntry)this.availableModel.getElementAt(indices[i]);
                entries.addElement(entry);
            }
            File dir = PluginLoader.getInstance().getPluginDirs()[0];
            if (!dir.exists()) {
                dir.mkdir();
            }
            File temp = new File(dir, "temp_install");
            new PluginDownloader(this, entries, temp);
            if (!this.downloadCanceled) {
                File[] files = temp.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File newfile = new File(files[i].getParentFile().getParentFile(), files[i].getName());
                    files[i].renameTo(newfile);
                }
                temp.delete();
                Enumeration enumeration = entries.elements();
                while (enumeration.hasMoreElements()) {
                    PluginListEntry ple = (PluginListEntry)enumeration.nextElement();
                    this.availableModel.removeElement(ple);
                    String filename = ple.filename;
                    File plugin = new File(PluginLoader.getInstance().getPluginDirs()[0], filename);
                    PluginLoader.getInstance().loadPlugin(plugin);
                }
                this.installedModel.removeAllElements();
                Vector plugins = PluginLoader.getInstance().getPlugins();
                enumeration = plugins.elements();
                while (enumeration.hasMoreElements()) {
                    this.installedModel.addElement(enumeration.nextElement());
                }
                JOptionPane.showMessageDialog(Main.getGUI(), I18N.translate("plugins_installed"), "PluginManager", 1);
            }
        }
    }

    private boolean isInstalled(PluginListEntry entry) {
        Enumeration enumeration = this.installedModel.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            if (!plugin.getName().equals(entry.getName())) continue;
            return true;
        }
        return false;
    }

    private String checkStatus(Plugin plugin) {
        String status = I18N.translate("loaded");
        Enumeration enumeration = this.pluginListEntries.elements();
        while (enumeration.hasMoreElements()) {
            PluginListEntry entry = (PluginListEntry)enumeration.nextElement();
            if (!plugin.getName().equals(entry.getName())) continue;
            if (plugin.getVersion().equals(entry.getVersion())) {
                status = I18N.translate("loaded");
                continue;
            }
            status = I18N.translate("update_available") + ": " + entry.getVersion();
        }
        return status;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object selected;
            if (e.getSource() == this.installedList) {
                if (this.installedList.getSelectedIndices().length > 0) {
                    Plugin plugin = (Plugin)this.installedModel.getElementAt(this.installedList.getSelectedIndex());
                    this.lName.setText(plugin.getName());
                    this.lAuthor.setText(plugin.getAuthor());
                    this.lVersion.setText(plugin.getVersion());
                    String status = this.checkStatus(plugin);
                    this.lStatus.setText(status);
                    this.taDescription.setText(plugin.getDescription());
                }
            } else if (e.getSource() == this.availableList && this.availableList.getSelectedIndices().length > 0 && (selected = this.availableModel.getElementAt(this.availableList.getSelectedIndex())) instanceof PluginListEntry) {
                PluginListEntry entry = (PluginListEntry)selected;
                this.lName.setText(entry.getName());
                this.lAuthor.setText(entry.getAuthor());
                this.lVersion.setText(entry.getVersion());
                this.lStatus.setText(I18N.translate("not_installed"));
                this.taDescription.setText(entry.getDescription());
            }
        }
    }

    private void updateInstalledList() {
        this.installedModel = new DefaultListModel();
        Vector installed = PluginLoader.getInstance().getPlugins();
        Collections.sort(installed, new PluginComparator());
        Iterator iterator = installed.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            this.installedModel.addElement(plugin);
        }
        this.installedList.setModel(this.installedModel);
    }

    private void updateAvailableList() {
        this.availableModel = new DefaultListModel();
        Iterator iterator = this.pluginListEntries.iterator();
        while (iterator.hasNext()) {
            PluginListEntry entry = (PluginListEntry)iterator.next();
            if (this.isInstalled(entry)) continue;
            this.availableModel.addElement(entry);
        }
        this.availableList.setModel(this.availableModel);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PluginListEntryComparator
    implements Comparator {
        private PluginListEntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            PluginListEntry p1 = (PluginListEntry)o1;
            PluginListEntry p2 = (PluginListEntry)o2;
            String nameP1 = p1.getName();
            String nameP2 = p2.getName();
            return nameP1.compareTo(nameP2);
        }
    }

    private class PluginDownloader
    extends JDialog
    implements Runnable,
    ActionListener {
        private PluginManager pm;
        private Vector entries;
        private File plugDir;
        private long byteLoaded = 0L;
        private long byteSize = 0L;
        private JButton cancel = new JButton(I18N.translate("cancel"));
        private JProgressBar progress = new JProgressBar();
        private InputStream in;
        private OutputStream out;
        private boolean running = true;

        PluginDownloader(PluginManager pm, Vector entries, File plugDir) {
            super((Dialog)pm, true);
            this.pm = pm;
            this.entries = entries;
            this.plugDir = plugDir;
            Enumeration enumeration = entries.elements();
            while (enumeration.hasMoreElements()) {
                PluginListEntry entry = (PluginListEntry)enumeration.nextElement();
                this.byteSize += Long.parseLong(entry.getSize());
            }
            long sizeTemp = this.byteSize;
            String size = sizeTemp + " Bytes";
            if (sizeTemp > 1024L) {
                size = (sizeTemp /= 1024L) > 1024L ? (sizeTemp /= 1024L) + " MB" : sizeTemp + " KB";
            }
            this.setTitle(size);
            Thread thread = new Thread(this);
            thread.start();
            this.initGUI();
        }

        private void initGUI() {
            this.getContentPane().setLayout(null);
            this.progress.setMinimum(0);
            this.progress.setMaximum(100);
            this.progress.setStringPainted(true);
            this.progress.setBounds(20, 20, 260, 20);
            this.getContentPane().add(this.progress);
            this.cancel.addActionListener(this);
            this.cancel.setBounds(100, 60, 100, 20);
            this.getContentPane().add(this.cancel);
            this.setSize(300, 130);
            int par_x = (int)this.pm.getLocation().getX();
            int par_y = (int)this.pm.getLocation().getY();
            int par_width = this.pm.getWidth();
            int par_height = this.pm.getHeight();
            int width = this.getWidth();
            int height = this.getHeight();
            int x = (par_width - width) / 2 + par_x;
            int y = (par_height - height) / 2 + par_y;
            this.setLocation(x, y);
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            try {
                this.pm.downloadCanceled = true;
                this.running = false;
                this.out.close();
                Enumeration enumeration = this.entries.elements();
                while (enumeration.hasMoreElements()) {
                    PluginListEntry entry = (PluginListEntry)enumeration.nextElement();
                    String name = entry.getFilename();
                    File file = new File(this.plugDir + File.separator + name);
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispose();
        }

        public void run() {
            Enumeration enumeration = this.entries.elements();
            while (enumeration.hasMoreElements()) {
                if (!this.running) {
                    this.dispose();
                    return;
                }
                PluginListEntry entry = (PluginListEntry)enumeration.nextElement();
                String name = entry.getFilename();
                this.download(name);
            }
            this.pm.downloadCanceled = false;
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void download(String name) {
            try {
                URL url = new URL(PluginManager.this.SERVER_URL + name);
                this.in = url.openStream();
                if (!this.plugDir.exists() && !this.plugDir.mkdir()) {
                    logger.error(I18N.translate("error.create_plugin_directory"));
                    this.running = false;
                    return;
                }
                this.out = new FileOutputStream(this.plugDir + File.separator + name);
                int length = 0;
                byte[] buffer = new byte[1024];
                while ((length = this.in.read(buffer)) > 0 && this.running) {
                    this.out.write(buffer, 0, length);
                    this.out.flush();
                    this.byteLoaded += (long)length;
                    this.updateBar();
                }
            }
            catch (Exception e) {
                logger.error(I18N.translate("error.download_plugin"), e);
            }
            finally {
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void updateBar() {
            int value = (int)((double)this.byteLoaded / (double)this.byteSize * 100.0);
            this.progress.setValue(value);
        }
    }

    private class PluginListEntry {
        public String name;
        public String author;
        public String version;
        public String description;
        public String size;
        public String filename;
        public String status;

        PluginListEntry(String[] entry) {
            this.name = entry[0];
            this.author = entry[1];
            this.version = entry[2];
            this.description = entry[3];
            this.size = entry[4];
            this.filename = entry[5];
        }

        public String getName() {
            return this.name;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSize() {
            return this.size;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return this.name;
        }
    }
}

