/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.RowObserver;
import net.sf.jmp3renamer.gui.DBTable;
import net.sf.jmp3renamer.gui.FileTable;
import net.sf.jmp3renamer.gui.MainGUI;
import net.sf.jmp3renamer.util.MyFile;

public class SplitPanel
extends JSplitPane
implements ActionListener,
KeyListener,
ListSelectionListener,
Observer,
RowObserver,
MouseListener {
    private MainGUI mainGUI;
    private JButton bUp;
    private JButton bDown;
    private JButton bSort;
    private JButton bDir;
    private DBTable dbtable = new DBTable();
    private JScrollPane dbScrollPane;
    private JPopupMenu dbScrollpanePopup = new JPopupMenu();
    private JPopupMenu dbTablePopup = new JPopupMenu();
    private JPopupMenu dirTablePopup = new JPopupMenu();
    public static FileTable dirtable = new FileTable();

    SplitPanel(MainGUI mainGUI) {
        this.mainGUI = mainGUI;
        DataManager.getInstance().addObserver(this);
        FileManager.getInstance().addRowObserver(this);
        this.initGUI();
    }

    private void initGUI() {
        this.bUp = new JButton(I18N.translate("move_up"));
        this.bUp.setActionCommand("UP");
        this.bUp.addActionListener(this);
        this.bDown = new JButton(I18N.translate("move_down"));
        this.bDown.setActionCommand("DOWN");
        this.bDown.addActionListener(this);
        this.bDir = new JButton(I18N.translate("select_dir"));
        this.bDir.addActionListener(this);
        this.bSort = new JButton(I18N.translate("sort"));
        this.bSort.addActionListener(this);
        this.setDividerSize(5);
        this.dbScrollPane = new JScrollPane(this.dbtable);
        JPanel dummy = new JPanel(new BorderLayout());
        dummy.add((Component)this.dbScrollPane, "Center");
        JPanel dummy2 = new JPanel(new BorderLayout());
        dummy2.add((Component)this.bSort, "Center");
        dummy2.add((Component)this.bUp, "West");
        dummy2.add((Component)this.bDown, "East");
        dummy.add((Component)dummy2, "South");
        this.dbtable.addKeyListener(this);
        this.add((Component)dummy, "right");
        this.dbtable.getSelectionModel().addListSelectionListener(this);
        JMenuItem add = new JMenuItem(I18N.translate("add_row"));
        add.setActionCommand("ADD_ROW");
        add.setAccelerator(KeyStroke.getKeyStroke('+'));
        add.addActionListener(this);
        this.dbScrollpanePopup.add(add);
        this.dbScrollPane.addMouseListener(this);
        JMenuItem add2 = new JMenuItem(I18N.translate("add_row"));
        add2.setActionCommand("ADD_ROW");
        add2.setAccelerator(KeyStroke.getKeyStroke('+'));
        add2.addActionListener(this);
        this.dbTablePopup.add(add2);
        JMenuItem up = new JMenuItem(I18N.translate("move_up"));
        up.setActionCommand("UP");
        up.setAccelerator(KeyStroke.getKeyStroke("LEFT"));
        up.addActionListener(this);
        this.dbTablePopup.add(up);
        JMenuItem down = new JMenuItem(I18N.translate("move_down"));
        down.setActionCommand("DOWN");
        down.setAccelerator(KeyStroke.getKeyStroke("RIGHT"));
        down.addActionListener(this);
        this.dbTablePopup.add(down);
        JMenuItem removeDatasets = new JMenuItem(I18N.translate("remove_selected_rows"));
        removeDatasets.setActionCommand("REMOVE_SELECTED_ROWS");
        removeDatasets.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        removeDatasets.addActionListener(this);
        this.dbTablePopup.add(removeDatasets);
        this.dbtable.addMouseListener(this);
        JPanel dummy3 = new JPanel(new BorderLayout());
        dirtable.addKeyListener(this);
        dummy3.add((Component)new JScrollPane(dirtable), "Center");
        dummy3.add((Component)this.bDir, "South");
        this.add((Component)dummy3, "left");
        JMenuItem removeFiles = new JMenuItem(I18N.translate("remove_selected_rows"));
        removeFiles.setActionCommand("REMOVE_SELECTED_FILES");
        removeFiles.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        removeFiles.addActionListener(this);
        this.dirTablePopup.add(removeFiles);
        dirtable.addMouseListener(this);
    }

    public void update(Observable o, final Object arg) {
        if (o == DataManager.getInstance()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int row = SplitPanel.this.dbtable.getSelectedRow();
                    row = row < 0 ? 0 : row;
                    Vector datasets = (Vector)arg;
                    SplitPanel.this.setDatasets(datasets);
                    if (datasets.size() <= row) {
                        row = 0;
                    }
                    if (datasets.size() > 0) {
                        SplitPanel.this.mainGUI.showDataset((DataSet)datasets.elementAt(row));
                        SplitPanel.this.dbtable.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            });
        }
    }

    public void update(Object o, int row, int action) {
        DefaultTableModel model = (DefaultTableModel)dirtable.getModel();
        if (action == 1) {
            MyFile file = (MyFile)o;
            Vector<Serializable> r = new Vector<Serializable>();
            r.add(file.getIcon());
            r.add(file);
            model.addRow(r);
            model.fireTableRowsInserted(model.getRowCount() - 1, model.getRowCount() - 1);
        } else if (action == -1) {
            model.removeRow(row);
            model.fireTableRowsDeleted(row, row);
        } else if (action == 0) {
            MyFile file = (MyFile)o;
            model.setValueAt(file.getIcon(), row, 0);
            model.setValueAt(file, row, 1);
            model.fireTableRowsUpdated(row, row);
        } else if (action == -10) {
            model.setRowCount(0);
            dirtable.repaint();
        }
    }

    private void setDatasets(Vector datasets) {
        DefaultTableModel model = (DefaultTableModel)this.dbtable.getModel();
        model.setRowCount(0);
        Enumeration enumeration = datasets.elements();
        while (enumeration.hasMoreElements()) {
            DataSet dataset = (DataSet)enumeration.nextElement();
            Vector<DataSet> row = new Vector<DataSet>();
            row.addElement(dataset);
            model.addRow(row);
        }
    }

    public void actionPerformed(ActionEvent e) {
        block3: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (!e.getActionCommand().equals("UP")) break block2;
                                    this.dbtable.moveUp();
                                    break block3;
                                }
                                if (!e.getActionCommand().equals("DOWN")) break block4;
                                this.dbtable.moveDown();
                                break block3;
                            }
                            if (e.getSource() != this.bDir) break block5;
                            FileManager.getInstance().openDir();
                            break block3;
                        }
                        if (e.getSource() != this.bSort) break block6;
                        DataManager.getInstance().trySort();
                        break block3;
                    }
                    if (!e.getActionCommand().equals("ADD_ROW")) break block7;
                    this.addRow();
                    break block3;
                }
                if (!e.getActionCommand().equals("REMOVE_SELECTED_ROWS")) break block8;
                int[] rows = this.dbtable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    DataManager.getInstance().removeRow(rows[i]);
                }
                break block3;
            }
            if (!e.getActionCommand().equals("REMOVE_SELECTED_FILES")) break block3;
            int[] rows = dirtable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                FileManager.getInstance().removeRow(rows[i]);
            }
        }
    }

    private void addRow() {
        DefaultTableModel model = (DefaultTableModel)this.dbtable.getModel();
        DataSet dataset = new DataSet();
        if (this.dbtable.getRowCount() > 0) {
            DataSet row0 = (DataSet)model.getValueAt(0, 0);
            dataset.setAlbum(row0.getAlbum());
            dataset.setArtist(row0.getArtist());
            dataset.setComment(row0.getComment());
            dataset.setComposer(row0.getComposer());
            dataset.setCopyright(row0.getCopyright());
            dataset.setEncodedBy(row0.getEncodedBy());
            dataset.setGenre(row0.getGenre());
            dataset.setUrl(row0.getUrl());
            dataset.setYear(row0.getYear());
        }
        DataManager.getInstance().addRow(dataset);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            if (e.getSource() == dirtable) {
                int[] rows = dirtable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    FileManager.getInstance().removeRow(rows[i]);
                }
            } else if (e.getSource() == this.dbtable) {
                int[] rows = this.dbtable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    DataManager.getInstance().removeRow(rows[i]);
                }
            }
        } else if (e.getKeyCode() == 37) {
            this.dbtable.moveUp();
        } else if (e.getKeyCode() == 39) {
            this.dbtable.moveDown();
        } else if (e.getKeyCode() == 521) {
            this.addRow();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.dbtable.getSelectionModel()) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                return;
            }
            if (this.dbtable.getRowCount() > 0) {
                DataSet dataset = (DataSet)this.dbtable.getValueAt(this.dbtable.getSelectedRow(), 0);
                this.mainGUI.showDataset(dataset);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.dbScrollPane && e.getButton() == 3) {
            this.dbScrollpanePopup.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getSource() == this.dbtable && e.getButton() == 3) {
            this.dbTablePopup.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getSource() == dirtable && e.getButton() == 3) {
            this.dirTablePopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

