/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.MagicCookieBaker;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.gui.components.historycombobox.JHistoryComboBox;
import net.sf.jmp3renamer.gui.components.historycombobox.SuggestingJHistoryComboBox;

public class FilenamePanel
extends JPanel
implements KeyListener,
ItemListener {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JLabel lMagicCookies = new JLabel();
    private JPanel albumPanel = new JPanel();
    private JPanel compilationPanel = new JPanel();
    private JHistoryComboBox cAlbumFilename;
    private JLabel lAlbumFilename = new JLabel();
    private JLabel lAlbumPreview = new JLabel();
    private JLabel lAlbumPreviewView = new JLabel();
    private JLabel lAlbumDirectory = new JLabel();
    private JLabel lAlbumDirectoryPreview = new JLabel();
    private JLabel lAlbumDirectoryPreviewView = new JLabel();
    private JLabel lAlbumDirectoryDescription = new JLabel();
    private JHistoryComboBox cAlbumDirectory;
    private JHistoryComboBox cCompilationFilename;
    private JLabel lCompilationFilename = new JLabel();
    private JLabel lCompilationPreview = new JLabel();
    private JLabel lCompilationPreviewView = new JLabel();
    private JLabel lCompilationDirectory = new JLabel();
    private JLabel lCompilationDirectoryPreview = new JLabel();
    private JLabel lCompilationDirectoryPreviewView = new JLabel();
    private JLabel lCompilationDirectoryDescription = new JLabel();
    private JHistoryComboBox cCompilationDirectory;

    protected FilenamePanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(10, 10));
        this.lMagicCookies.setText(MagicCookieBaker.getCookieText());
        this.lAlbumFilename.setText(I18N.translate("filename"));
        this.cAlbumFilename = new SuggestingJHistoryComboBox(MagicCookieBaker.getCookies(), Main.getProperties(), "filenameHistory");
        this.cAlbumFilename.getEditor().getEditorComponent().addKeyListener(this);
        this.cAlbumFilename.getEditor().setItem(Main.getProperty("filename"));
        this.cAlbumFilename.addItemListener(this);
        this.lAlbumDirectory.setText(I18N.translate("directory"));
        this.lAlbumPreview.setText(I18N.translate("preview") + ":");
        this.lAlbumDirectoryDescription.setText(I18N.translate("dir_desc"));
        this.lAlbumDirectoryDescription.setVerticalAlignment(1);
        this.cAlbumDirectory = new SuggestingJHistoryComboBox(MagicCookieBaker.getCookies(), Main.getProperties(), "directoryHistory");
        this.cAlbumDirectory.getEditor().getEditorComponent().addKeyListener(this);
        this.cAlbumDirectory.getEditor().setItem(Main.getProperty("directory"));
        this.cAlbumDirectory.addItemListener(this);
        this.lAlbumDirectoryPreview.setText(I18N.translate("preview") + ":");
        this.albumPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.albumPanel.add((Component)this.lAlbumFilename, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.albumPanel.add((Component)this.cAlbumFilename, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        this.albumPanel.add((Component)this.lAlbumPreview, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.albumPanel.add((Component)this.lAlbumPreviewView, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        this.albumPanel.add((Component)this.lAlbumDirectory, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.albumPanel.add((Component)this.cAlbumDirectory, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        this.albumPanel.add((Component)this.lAlbumDirectoryPreview, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.albumPanel.add((Component)this.lAlbumDirectoryPreviewView, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.albumPanel.add((Component)this.lAlbumDirectoryDescription, gbc);
        this.lCompilationFilename.setText(I18N.translate("filename"));
        this.cCompilationFilename = new SuggestingJHistoryComboBox(MagicCookieBaker.getCookies(), Main.getProperties(), "filenameCompilationHistory");
        this.cCompilationFilename.getEditor().getEditorComponent().addKeyListener(this);
        this.cCompilationFilename.getEditor().setItem(Main.getProperty("filenameCompilation"));
        this.cCompilationFilename.addItemListener(this);
        this.lCompilationPreview.setText(I18N.translate("preview") + ":");
        this.lCompilationDirectory.setText(I18N.translate("directory"));
        this.lCompilationDirectoryPreview.setText(I18N.translate("preview") + ":");
        this.lCompilationDirectoryDescription.setText(I18N.translate("dir_desc"));
        this.lCompilationDirectoryDescription.setVerticalAlignment(1);
        this.cCompilationDirectory = new SuggestingJHistoryComboBox(MagicCookieBaker.getCookies(), Main.getProperties(), "directoryCompilationHistory");
        this.cCompilationDirectory.getEditor().getEditorComponent().addKeyListener(this);
        this.cCompilationDirectory.getEditor().setItem(Main.getProperty("directoryCompilation"));
        this.cCompilationDirectory.addItemListener(this);
        this.compilationPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.compilationPanel.add((Component)this.lCompilationFilename, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.compilationPanel.add((Component)this.cCompilationFilename, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        this.compilationPanel.add((Component)this.lCompilationPreview, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.compilationPanel.add((Component)this.lCompilationPreviewView, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        this.compilationPanel.add((Component)this.lCompilationDirectory, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.compilationPanel.add((Component)this.cCompilationDirectory, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        this.compilationPanel.add((Component)this.lCompilationDirectoryPreview, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.compilationPanel.add((Component)this.lCompilationDirectoryPreviewView, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.compilationPanel.add((Component)this.lCompilationDirectoryDescription, gbc);
        this.tabbedPane.addTab(I18N.translate("albums"), this.albumPanel);
        this.tabbedPane.addTab(I18N.translate("compilations"), this.compilationPanel);
        JPanel dummy = new JPanel(new FlowLayout(0, 10, 10));
        dummy.add(this.lMagicCookies);
        this.add((Component)dummy, "South");
        this.add((Component)this.tabbedPane, "Center");
        this.preview();
        this.setBorder(BorderFactory.createTitledBorder(I18N.translate("filename")));
    }

    private void preview() {
        this.lAlbumPreviewView.setText(MagicCookieBaker.createPreview(this.cAlbumFilename.getEditor().getItem().toString()));
        this.lAlbumDirectoryPreviewView.setText(MagicCookieBaker.createPreview(this.cAlbumDirectory.getEditor().getItem().toString()));
        this.lCompilationPreviewView.setText(MagicCookieBaker.createPreview(this.cCompilationFilename.getEditor().getItem().toString()));
        this.lCompilationDirectoryPreviewView.setText(MagicCookieBaker.createPreview(this.cCompilationDirectory.getEditor().getItem().toString()));
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.preview();
    }

    public void applyConfig() {
        this.cAlbumFilename.addCurrentItemToHistory();
        this.cAlbumDirectory.addCurrentItemToHistory();
        this.cCompilationFilename.addCurrentItemToHistory();
        this.cCompilationDirectory.addCurrentItemToHistory();
        Main.setProperty("filename", this.cAlbumFilename.getEditor().getItem().toString());
        Main.setProperty("directory", this.cAlbumDirectory.getEditor().getItem().toString());
        Main.setProperty("filenameCompilation", this.cCompilationFilename.getEditor().getItem().toString());
        Main.setProperty("directoryCompilation", this.cCompilationDirectory.getEditor().getItem().toString());
        Vector datasets = DataManager.getInstance().getDatasets();
        Enumeration enumeration = datasets.elements();
        while (enumeration.hasMoreElements()) {
            DataSet dataset = (DataSet)enumeration.nextElement();
            if (dataset.isPartOfCompilation()) {
                dataset.setRegex(Main.getProperty("filenameCompilation"));
                continue;
            }
            dataset.setRegex(Main.getProperty("filename"));
        }
        DataManager.getInstance().setDatasets(datasets);
    }

    public void itemStateChanged(ItemEvent e) {
        this.preview();
    }
}

