/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;

public class ProxyPanel
extends JPanel
implements ActionListener {
    private JLabel lProxyServer = new JLabel(I18N.translate("host"));
    private JLabel lProxyPort = new JLabel(I18N.translate("port"));
    private JLabel lProxyUser = new JLabel(I18N.translate("username"));
    private JLabel lProxyPass = new JLabel(I18N.translate("password"));
    private JTextField tProxyServer = new JTextField();
    private JTextField tProxyPort = new JTextField();
    private JTextField tProxyUser = new JTextField();
    private JTextField tProxyPass = new JTextField();
    private JCheckBox cbProxyAuth = new JCheckBox(I18N.translate("proxy_login"));

    public ProxyPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(I18N.translate("proxy")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.lProxyServer, gbc);
        gbc.gridy = 1;
        this.add((Component)this.lProxyPort, gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.tProxyServer, gbc);
        gbc.gridy = 1;
        this.add((Component)this.tProxyPort, gbc);
        JPanel authenticationPanel = new JPanel();
        authenticationPanel.setBorder(BorderFactory.createTitledBorder(I18N.translate("authentication")));
        authenticationPanel.setLayout(new GridBagLayout());
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        authenticationPanel.add((Component)this.cbProxyAuth, gbc);
        this.cbProxyAuth.addActionListener(this);
        gbc.gridy = 1;
        authenticationPanel.add((Component)this.lProxyUser, gbc);
        gbc.gridy = 2;
        authenticationPanel.add((Component)this.lProxyPass, gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        authenticationPanel.add((Component)this.tProxyUser, gbc);
        gbc.gridy = 2;
        authenticationPanel.add((Component)this.tProxyPass, gbc);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        this.add((Component)authenticationPanel, gbc);
        this.tProxyServer.setText(Main.getProperty("proxyHost"));
        this.tProxyPort.setText(Main.getProperty("proxyPort"));
        this.tProxyUser.setText(Main.getProperty("http.proxyUser"));
        this.tProxyPass.setText(Main.getProperty("http.proxyPassword"));
        if (Main.getProperty("proxyAuth").equals("true")) {
            this.cbProxyAuth.setSelected(true);
        } else {
            this.lProxyUser.setEnabled(false);
            this.tProxyUser.setEnabled(false);
            this.lProxyPass.setEnabled(false);
            this.tProxyPass.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbProxyAuth) {
            this.lProxyUser.setEnabled(!this.lProxyUser.isEnabled());
            this.tProxyUser.setEnabled(!this.tProxyUser.isEnabled());
            this.lProxyPass.setEnabled(!this.lProxyPass.isEnabled());
            this.tProxyPass.setEnabled(!this.tProxyPass.isEnabled());
        }
    }

    public void applyConfig() {
        String host = this.tProxyServer.getText();
        Main.setProperty("proxyHost", host);
        Main.setProperty("proxyPort", this.tProxyPort.getText());
        Main.setProperty("http.proxyUser", this.tProxyUser.getText());
        Main.setProperty("http.proxyPassword", this.tProxyPass.getText());
        Main.setProperty("proxyAuth", new Boolean(this.cbProxyAuth.isSelected()).toString());
        if (!host.equals("")) {
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", host);
            System.setProperty("proxyPort", this.tProxyPort.getText());
            if (this.cbProxyAuth.isSelected()) {
                System.setProperty("http.proxyUser", this.tProxyUser.getText());
                System.setProperty("http.proxyPassword", this.tProxyPass.getText());
            }
        } else {
            System.setProperty("proxySet", "false");
        }
    }
}

